/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.monitor.session;

import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.monitor.session.HttpSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HttpSessionObjectNode {
    protected boolean modified = true;
    protected boolean isSent = true;
    private int currentNumberOfSessions = 0;
    private int reportingCount = 0;
    private long maxGrossTime = 0L;
    private long avgGrossTime = 0L;
    private long closedSessionsGrossTimes = 0L;
    private long closedSessionsCount = 0L;
    private String attributeName = HttpSession.NAMES[4];
    private HttpSession[] sessions = new HttpSession[0];
    private HttpSession[] reportingSessions = new HttpSession[0];
    private Hashtable closeTimes = new Hashtable(11);

    private void addSession(HttpSession session) {
        HttpSession[] newSessions = new HttpSession[this.sessions.length + 1];
        int low = 0;
        int high = this.sessions.length - 1;
        if (this.sessions.length > 0) {
            if (session.isLessThan(this.sessions[0], this.attributeName)) {
                newSessions[0] = session;
                System.arraycopy(this.sessions, 0, newSessions, 1, this.sessions.length);
            } else if (this.sessions[this.sessions.length - 1].isLessThan(session, this.attributeName)) {
                System.arraycopy(this.sessions, 0, newSessions, 0, this.sessions.length);
                newSessions[this.sessions.length] = session;
            } else {
                int mid = 0;
                while (low < high) {
                    mid = low + high >>> 1;
                    if (this.sessions[mid].isLessThan(session, this.attributeName)) {
                        low = mid + 1;
                        continue;
                    }
                    if (!session.isLessThan(this.sessions[mid], this.attributeName)) break;
                    high = mid - 1;
                }
                System.arraycopy(this.sessions, 0, newSessions, 0, mid + 1);
                newSessions[mid + 1] = session;
                System.arraycopy(this.sessions, mid + 1, newSessions, mid + 2, this.sessions.length - mid - 1);
            }
            this.sessions = newSessions;
        } else {
            this.sessions = new HttpSession[]{session};
        }
    }

    public int getCurrentNumberOfSessions() {
        return this.currentNumberOfSessions;
    }

    public void setReportedSubnodesCount(int count) {
        if (this.reportingCount != count) {
            this.reportingCount = count;
            int size = Math.min(this.reportingCount, this.currentNumberOfSessions);
            this.reportingSessions = new HttpSession[size];
            System.arraycopy(this.sessions, 0, this.reportingSessions, 0, size);
        }
    }

    public int getReportedSubnodesCount() {
        return this.reportingCount;
    }

    public String getSortingAttribute() {
        return this.attributeName;
    }

    public void setSortingAttribute(String attributeName) {
        if (!this.attributeName.equals(attributeName)) {
            this.attributeName = attributeName;
            this.sort();
            int size = Math.min(this.reportingCount, this.currentNumberOfSessions);
            System.arraycopy(this.sessions, 0, this.reportingSessions, 0, size);
        }
    }

    private void sort() {
        HttpSession temp = null;
        int j = 0;
        while (j < this.sessions.length - 1) {
            int i = this.sessions.length - 1;
            while (i > j) {
                if (this.sessions[i].isLessThan(this.sessions[i - 1], this.attributeName)) {
                    temp = this.sessions[i];
                    this.sessions[i] = this.sessions[i - 1];
                    this.sessions[i - 1] = temp;
                }
                --i;
            }
            ++j;
        }
    }

    private void removeSession(int index) {
        HttpSession[] newSessions = new HttpSession[this.sessions.length - 1];
        System.arraycopy(this.sessions, 0, newSessions, 0, index);
        System.arraycopy(this.sessions, index + 1, newSessions, index, newSessions.length - index);
        this.sessions = newSessions;
    }

    public void update() {
        String sessId = null;
        Vector<String> ids = new Vector<String>(10, 10);
        if (SBasic.startedWebApplications.size() > 0) {
            Enumeration en = SBasic.startedWebApplications.elements();
            while (en.hasMoreElements()) {
                Hashtable hash = ((ApplicationContext)en.nextElement()).getSessionServletContext().getSession();
                if (hash.size() <= 0) continue;
                Enumeration enumeration = hash.keys();
                while (enumeration.hasMoreElements()) {
                    sessId = (String)enumeration.nextElement();
                    if (ids.contains(sessId)) continue;
                    ids.add(sessId);
                }
            }
        }
        HttpSession info = null;
        this.modified = false;
        int i = 0;
        while (i < this.sessions.length) {
            info = this.sessions[i];
            if (!this.checkOut(info.getSessionId(), ids)) {
                if (info.getCloseTime() <= 0L) {
                    info.setCloseTime(System.currentTimeMillis());
                    long grossTime = info.getCloseTime() - info.getCreationTime();
                    if (grossTime > 0L) {
                        this.setMaxGrossTime(grossTime);
                        this.closedSessionsGrossTimes += grossTime;
                        ++this.closedSessionsCount;
                        this.modified = true;
                    }
                } else {
                    this.removeSession(i);
                    this.modified = true;
                }
            }
            ++i;
        }
        this.avgGrossTime = this.closedSessionsCount > 0L ? this.closedSessionsGrossTimes / this.closedSessionsCount : 0L;
        int i2 = 0;
        while (i2 < ids.size()) {
            if (ids.elementAt(i2) != null) {
                this.modified = true;
                info = new HttpSession((String)ids.elementAt(i2));
                try {
                    info.update();
                    this.addSession(info);
                }
                catch (Exception e) {
                    ids.removeElementAt(i2);
                    --i2;
                }
            }
            ++i2;
        }
        int count = ids.size();
        if (this.currentNumberOfSessions != count) {
            this.currentNumberOfSessions = count;
            count = Math.min(this.reportingCount, this.currentNumberOfSessions);
            this.reportingSessions = new HttpSession[count];
            System.arraycopy(this.sessions, 0, this.reportingSessions, 0, count);
            this.modified = true;
        }
        this.closeTimes.clear();
    }

    private boolean checkOut(String sessionId, Vector sessionIds) {
        int i = 0;
        while (i < sessionIds.size()) {
            if (sessionId.equals(sessionIds.elementAt(i))) {
                sessionIds.setElementAt(null, i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void onSessionClosure(String sessionId) {
        this.closeTimes.put(sessionId, new Long(System.currentTimeMillis()));
    }

    protected void setMaxGrossTime(long grossTime) {
        if (grossTime > this.maxGrossTime) {
            this.maxGrossTime = grossTime;
        }
    }

    protected long getMaxGrossTime() {
        return this.maxGrossTime;
    }

    protected long getAvgGrossTime() {
        return this.avgGrossTime;
    }

    public long getMaxSessionGrossTime() {
        return this.maxGrossTime;
    }

    public long getAvgSessionGrossTime() {
        return this.avgGrossTime;
    }

    public long getClosedSessionsCount() {
        return this.closedSessionsCount;
    }

    protected void setSent(boolean flag) {
        if (flag == this.isSent) {
            this.modified = false;
        } else {
            this.isSent = true;
            this.modified = true;
        }
    }
}

