/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.monitor.session;

import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.util.Enumeration;

public class HttpSession {
    public static final String[] NAMES = new String[]{"Session-id", "User-principal", "Accessed", "Expires", "Creation time", "Close time", "Thread-id"};
    private boolean modified = false;
    private long closeTime = -1L;
    private long creationTime = -1L;
    private long lastAccessed = -1L;
    private long expiration = -1L;
    private String sessionId = "-1";
    private String nodeName = "unknown";
    private String userId = "";
    private String threadId = null;
    private String[] attributes = null;

    public HttpSession() {
        this.attributes = new String[1];
    }

    protected HttpSession(String sessionId) {
        this.sessionId = sessionId;
        this.nodeName = "Session " + sessionId;
        this.attributes = new String[1];
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getName() {
        return this.nodeName;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void initialize(long creationTime, long lastAccessed, long closeTime, long expirationPeriod, String sessionId, String userId) {
        this.creationTime = creationTime;
        this.lastAccessed = lastAccessed;
        this.closeTime = closeTime;
        this.expiration = expirationPeriod;
        this.sessionId = sessionId;
        this.userId = userId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public long getExpirationPeriod() {
        return this.expiration;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Object getThreadId() {
        return null;
    }

    protected void setCloseTime(long time) {
        this.closeTime = time;
    }

    synchronized boolean update() {
        long time = -1L;
        String value = "unknown";
        Enumeration en = SBasic.startedWebApplications.elements();
        ApplicationSession tempSession = null;
        while (tempSession == null && en.hasMoreElements()) {
            tempSession = (ApplicationSession)((ApplicationContext)en.nextElement()).getSessionServletContext().getSession().get(this.sessionId);
        }
        this.creationTime = tempSession.getCreationTime();
        this.expiration = tempSession.getMaxInactiveInterval() == -1 ? Long.MAX_VALUE : tempSession.getLastAccessedTime() + (long)(tempSession.getMaxInactiveInterval() * 1000);
        if (this.userId == null || this.userId.equals("")) {
            this.userId = (String)tempSession.getSecurityValue("j_username");
        }
        if ((time = tempSession.getLastAccessedTime()) != this.lastAccessed) {
            this.lastAccessed = time;
            this.modified = true;
        }
        value = tempSession.getSecurityValueNoAccess("clientIP");
        if (this.attributes[0] == null || !this.attributes[0].equals(value)) {
            this.attributes[0] = value;
            this.modified = true;
        }
        return this.modified;
    }

    public String toString() {
        return "Session: " + this.getName();
    }

    public boolean isLessThan(HttpSession info, String attributeName) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(attributeName)) break;
            ++i;
        }
        switch (i) {
            case 0: {
                if (this.sessionId == null) {
                    return true;
                }
                return this.sessionId.compareTo(info.getSessionId()) < 0;
            }
            case 1: {
                return this.userId.compareTo(info.getUserId()) < 0;
            }
            case 2: {
                return this.lastAccessed < info.getLastAccessedTime();
            }
            case 3: {
                return this.expiration < info.getExpirationPeriod();
            }
            case 4: {
                return this.creationTime < info.getCreationTime();
            }
            case 5: {
                return this.closeTime < info.getCloseTime();
            }
            case 6: {
                return this.threadId.compareTo(info.getThreadId()) < 0;
            }
        }
        return false;
    }
}

