/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.logging;

import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.tc.logging.Location;

public class LogLocation {
    private String locationName = null;
    private Location location = null;

    public LogLocation(String locationName) {
        this.locationName = locationName;
        this.location = Location.getLocation((String)locationName);
    }

    public Location getLocation() {
        return this.location;
    }

    public void trace(String msg, String webApp) {
        if (this.location.beDebug() || this.location.bePath()) {
            this.location.pathT(Log.getExceptionStackTrace(new Exception(msg)));
        } else {
            this.location.infoT(msg);
        }
    }

    public void traceFatal(String msg, Throwable t, String webApp) {
        this.location.fatalT(msg + " The error is: " + Log.getExceptionStackTrace(t));
    }

    public void traceError(String msg, String webApp) {
        this.location.errorT(msg);
    }

    public void traceError(String msg, Throwable t, String webApp) {
        this.location.errorT(msg + " The error is: " + Log.getExceptionStackTrace(t));
    }

    public void traceWarning(String msg, String webApp) {
        this.location.warningT(msg);
    }

    public void traceWarning(String msg, Throwable t, String webApp) {
        this.location.warningT(msg + " The error is: " + Log.getExceptionStackTrace(t));
    }

    public void traceInfo(String msg, String webApp) {
        this.location.infoT(msg);
    }

    public void traceDebug(String msg, String webApp) {
        this.location.debugT(msg);
    }

    public void tracePath(String msg, String webApp) {
        this.location.pathT(msg);
    }
}

