/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.lib;

public class StringUtils {
    public static String escapeJavaCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    String s1;
                    if (c > '\u00ff') {
                        s1 = "00" + Integer.toHexString(c);
                        sb.append("\\u").append(s1.substring(s1.length() - 4));
                        break;
                    }
                    if (c < ' ' || c >= '\u007f') {
                        s1 = "00" + Integer.toOctalString(c);
                        sb.append('\\').append(s1.substring(s1.length() - 3));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unquote(byte[] quotedString, int off, int len) {
        int cutQuotes = 0;
        int middle = len / 2;
        while (cutQuotes < middle) {
            if (quotedString[off + cutQuotes] != 34 || quotedString[off + len - 1 - cutQuotes] != 34) break;
            ++cutQuotes;
        }
        return new String(quotedString, off + cutQuotes, len - cutQuotes * 2);
    }
}

