/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.jsp.eclipse;

import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class JspLineMapping {
    protected File jspFile;
    protected File javaFile;
    protected ArrayList jspToJava;
    protected ArrayList javaToJsp;
    protected final Integer UNMAPPED_LINE_OBJECT = new Integer(-1);
    public static final int UNMAPPED_LINE = -1;

    public JspLineMapping(File javaFile, File jspFile) {
        this.javaFile = javaFile;
        this.jspFile = jspFile;
    }

    public ArrayList getJspToJavaList() {
        return this.jspToJava;
    }

    public ArrayList getJavaToJspList() {
        return this.javaToJsp;
    }

    protected void buildJspToJavaMapping() {
        int i = this.javaToJsp.size();
        int j = 0;
        while (j < i) {
            if (this.javaToJsp.get(j) != this.UNMAPPED_LINE_OBJECT) {
                int k = (Integer)this.javaToJsp.get(j);
                int l = this.jspToJava.size();
                if (l <= k) {
                    while (l < k) {
                        this.jspToJava.add(this.UNMAPPED_LINE_OBJECT);
                        ++l;
                    }
                    this.jspToJava.add(new Integer(j));
                } else if (this.jspToJava.get(k) == this.UNMAPPED_LINE_OBJECT) {
                    this.jspToJava.set(k, new Integer(j));
                }
            }
            ++j;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException {
        this.javaToJsp = new ArrayList();
        this.jspToJava = new ArrayList();
        BufferedReader in = null;
        try {
            try {
                String htmlTag = "// HTML ";
                String beginTag = "// begin [file=";
                String endTag = ")]";
                String fromTag = ";from=(";
                String toTag = ");to=(";
                String endOfFileTag = "// end";
                in = new BufferedReader(new FileReader(this.javaFile));
                String line = in.readLine();
                if (line != null) {
                    this.javaToJsp.add(this.UNMAPPED_LINE_OBJECT);
                    block7: do {
                        this.javaToJsp.add(this.UNMAPPED_LINE_OBJECT);
                        line = line.trim();
                        if (!line.startsWith(beginTag) || !line.endsWith(endTag)) continue;
                        int i = line.indexOf(fromTag);
                        int j = line.indexOf(toTag);
                        if (i == -1 || j == -1) continue;
                        int k = line.indexOf(44, i);
                        String lineNumber = line.substring(i + fromTag.length(), k);
                        int l = Integer.parseInt(lineNumber) + 1;
                        k = line.indexOf(44, j);
                        lineNumber = line.substring(j + toTag.length(), k);
                        int i1 = Integer.parseInt(lineNumber) + 1;
                        while (true) {
                            line = in.readLine();
                            if ((line = line.trim()).startsWith(endOfFileTag)) {
                                this.javaToJsp.add(this.UNMAPPED_LINE_OBJECT);
                                continue block7;
                            }
                            this.javaToJsp.add(new Integer(l));
                            if (l >= i1) continue;
                            ++l;
                        }
                    } while ((line = in.readLine()) != null);
                }
                this.buildJspToJavaMapping();
            }
            catch (Exception exc) {
                throw new WebIOException("servlet_jsp_0256", exc);
            }
            Object var16_16 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw new WebIOException("servlet_jsp_0251", exception2);
            }
        }
        try {}
        catch (Exception exception2) {
            throw new WebIOException("servlet_jsp_0251", exception2);
        }
        in.close();
    }

    public int[] getJspLines(int[] lines) {
        int[] result = new int[lines.length];
        int j = 0;
        int k = 0;
        while (k < lines.length) {
            Integer integer = (Integer)this.javaToJsp.get(lines[k]);
            if (integer != this.UNMAPPED_LINE_OBJECT) {
                result[j] = integer;
                ++j;
            }
            ++k;
        }
        if (j != lines.length) {
            int[] newRes = new int[j];
            System.arraycopy(result, 0, newRes, 0, j);
            return newRes;
        }
        return result;
    }

    public int getJspLine(int i) {
        try {
            Integer integer = (Integer)this.javaToJsp.get(i);
            return integer;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public int getJavaLine(int i) {
        try {
            Integer integer = (Integer)this.jspToJava.get(i);
            return integer;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public File getJspFile() {
        return this.jspFile;
    }

    public File getJavaFile() {
        return this.javaFile;
    }
}

