/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.jsp.eclipse;

import com.sap.engine.services.servlets_jsp.server.jsp.eclipse.SourceMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ClassMapper {
    private DataInputStream m_in;
    private String[] m_cpStrings = null;
    private int[] m_cpStringsIdx = null;
    private String m_sourceFileName;
    private SourceMapper m_sourceMapper;
    private Vector m_lineNumberTables = new Vector();
    private boolean m_alreadyInstrumented;
    private String m_sourceDir = "";
    private String m_classDir = "";
    private static final String CLASS_EXTENSION = ".class";
    private static int CLASS_EXTENSION_LEN = ".class".length();
    private static final String JAVA_EXTENSION = ".java";
    private static int JAVA_EXTENSION_LEN = ".java".length();
    private static int ALREADY_INST = -1;
    private static int INST_OK = 0;
    private static int NO_ARGS = 1;
    private static int NO_JSP_FILE = 2;
    private static int NO_LINE_INFO = 3;
    private static int NO_CLASS_FOUND = 4;
    private static int SEC_ERR = 5;
    private static int UNABLE = 6;
    private ClassBuffer m_classBytes;
    private static final int CLASS_ATTRIBUTE = 1;
    private static final int FIELD_ATTRIBUTE = 2;
    private static final int METHOD_ATTRIBUTE = 3;
    private static final int CODE_ATTRIBUTE = 4;

    protected DataInputStream getInputStream(Class cls, OutputStream buffer) throws SecurityException {
        String filename = "/" + cls.getName().replace('.', '/') + CLASS_EXTENSION;
        BufferedInputStream is = new BufferedInputStream(cls.getResourceAsStream(filename));
        return this.getInputStream(is, buffer);
    }

    protected DataInputStream getInputStream(InputStream is, final OutputStream buffer) throws SecurityException {
        if (is == null) {
            throw new SecurityException("could not find class file ");
        }
        return new DataInputStream(new FilterInputStream(is){

            public int read(byte[] b, int off, int len) throws IOException {
                int result = super.read(b, off, len);
                if (result != -1) {
                    buffer.write(b, off, result);
                }
                return result;
            }

            public int read() throws IOException {
                int result = super.read();
                if (result != -1) {
                    buffer.write(result);
                }
                return result;
            }

            public long skip(long n) throws IOException {
                int ch = 0;
                long i = 0L;
                while (ch != -1 && i < n) {
                    ch = this.read();
                    ++i;
                }
                return i;
            }
        });
    }

    protected SourceMapper getSourceMapper(Class cls) throws SecurityException, IOException {
        String main = "/" + cls.getName().replace('.', '/');
        String filename = main + JAVA_EXTENSION;
        String jspName = main + ".jsp";
        return new SourceMapper(jspName, filename);
    }

    protected SourceMapper getSourceMapper(String javaFile, String jspFile) throws IOException {
        return new SourceMapper(jspFile, javaFile);
    }

    public void readClass() throws IOException {
        this.m_in.skipBytes(8);
        int count = this.u2();
        this.m_cpStrings = new String[count];
        this.m_cpStringsIdx = new int[count];
        int i = 1;
        while (i < count) {
            i = this.cp_info(i);
        }
        this.m_in.skipBytes(4);
        this.m_in.skipBytes(2);
        count = this.u2();
        this.m_in.skipBytes(count * 2);
        count = this.u2();
        int i2 = 0;
        while (i2 < count) {
            this.field_info();
            ++i2;
        }
        count = this.u2();
        int i3 = 0;
        while (i3 < count) {
            this.method_info();
            ++i3;
        }
        count = this.u2();
        int i4 = 0;
        while (i4 < count) {
            this.attribute_info(1);
            ++i4;
        }
    }

    public int cp_info(int ndx) throws IOException {
        int tag = this.u1();
        switch (tag) {
            case 7: {
                this.m_in.skipBytes(2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.m_in.skipBytes(4);
                break;
            }
            case 8: {
                this.m_in.skipBytes(2);
                break;
            }
            case 5: 
            case 6: {
                this.m_in.skipBytes(8);
                ++ndx;
                break;
            }
            case 1: {
                this.m_cpStrings[ndx] = this.m_in.readUTF();
                this.m_cpStringsIdx[ndx] = this.m_classBytes.getCount();
                break;
            }
            default: {
                throw new IllegalArgumentException("tag " + tag + " at ndx " + ndx);
            }
        }
        return ndx + 1;
    }

    public void field_info() throws IOException {
        this.m_in.skipBytes(6);
        int count = this.u2();
        int i = 0;
        while (i < count) {
            this.attribute_info(2);
            ++i;
        }
    }

    public void method_info() throws IOException {
        this.m_in.skipBytes(6);
        int count = this.u2();
        int i = 0;
        while (i < count) {
            this.attribute_info(3);
            ++i;
        }
    }

    public void attribute_info(int attributeType) throws IOException {
        int ndx = this.u2();
        int length = this.u4();
        if (attributeType == 1 && this.m_cpStrings[ndx].equals("SourceFile")) {
            int sourceFileIndex = this.u2();
            this.m_sourceFileName = this.m_cpStrings[sourceFileIndex];
            this.m_alreadyInstrumented = !this.m_sourceFileName.endsWith(JAVA_EXTENSION);
        } else if (attributeType == 4 && this.m_cpStrings[ndx].equals("LineNumberTable")) {
            int table_length = this.u2();
            int table_pos = this.m_classBytes.getCount();
            this.m_lineNumberTables.addElement(new LineTable(table_length, table_pos));
            int i = 0;
            while (i < table_length) {
                this.m_in.skipBytes(4);
                ++i;
            }
        } else if (attributeType == 3 && this.m_cpStrings[ndx].equals("Code")) {
            this.code_attribute();
        } else {
            this.m_in.skipBytes(length);
        }
    }

    public void code_attribute() throws IOException {
        this.m_in.skipBytes(4);
        long codeLength = this.u4();
        while (codeLength > Integer.MAX_VALUE) {
            this.m_in.skipBytes(Integer.MAX_VALUE);
            codeLength -= Integer.MAX_VALUE;
        }
        this.m_in.skipBytes((int)codeLength);
        int exceptionTableLength = this.u2();
        this.m_in.skipBytes(exceptionTableLength * 8);
        int attributesCount = this.u2();
        int i = 0;
        while (i < attributesCount) {
            this.attribute_info(4);
            ++i;
        }
    }

    public int u4() throws IOException {
        return this.m_in.readInt();
    }

    public int u2() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    public int u1() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    public static int mainStatus(String classFile, String javaFile, String jspFile) {
        ClassMapper cm = new ClassMapper();
        return cm.runMain(classFile, javaFile, jspFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int runMain(String classFile, String javaFile, String jspFile) {
        int status = INST_OK;
        try {
            this.m_classBytes = new ClassBuffer();
            this.m_in = this.getInputStream(new BufferedInputStream(new FileInputStream(classFile)), (OutputStream)this.m_classBytes);
            this.m_sourceMapper = this.getSourceMapper(javaFile, jspFile);
            if (this.m_sourceMapper.size() == 0) {
                return NO_JSP_FILE;
            }
            try {
                block13: {
                    try {
                        this.readClass();
                        if (this.m_alreadyInstrumented) {
                            status = ALREADY_INST;
                            break block13;
                        }
                        if (this.m_lineNumberTables.size() == 0) {
                            status = NO_LINE_INFO;
                        } else {
                            this.m_classBytes.adjustLineNumbers();
                            FileOutputStream os = new FileOutputStream(classFile);
                            this.m_classBytes.writeTo(os);
                            ((OutputStream)os).close();
                        }
                    }
                    catch (IOException e) {
                        throw new ClassFormatError(classFile);
                    }
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    this.m_in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassFormatError(classFile);
                }
            }
            try {}
            catch (IOException e) {
                throw new ClassFormatError(classFile);
            }
            this.m_in.close();
            return status;
        }
        catch (Exception e) {
            return UNABLE;
        }
    }

    class LineTable {
        private int m_numEntries;
        private int m_position;

        LineTable(int numEntries, int position) {
            this.m_numEntries = numEntries;
            this.m_position = position;
        }

        int getNumEntries() {
            return this.m_numEntries;
        }

        int getPosition() {
            return this.m_position;
        }
    }

    class ClassBuffer
    extends ByteArrayOutputStream {
        ClassBuffer() {
        }

        void setIntAt(int value, int position) {
            this.buf[position] = (byte)(value >>> 8 & 0xFF);
            this.buf[position + 1] = (byte)(value >>> 0 & 0xFF);
        }

        int getIntAt(int position) {
            byte b1 = this.buf[position];
            byte b2 = this.buf[position + 1];
            return b2 & 0xFF | (b1 & 0xFF) << 8;
        }

        void writeASCIIStringAt(String val, int position) {
            int i = 0;
            while (i < val.length()) {
                this.buf[position + i] = (byte)val.charAt(i);
                ++i;
            }
        }

        int getCount() {
            return this.count;
        }

        void adjustLineNumbers() {
            int acount = 0;
            int j = 0;
            while (j < ClassMapper.this.m_lineNumberTables.size()) {
                LineTable lt = (LineTable)ClassMapper.this.m_lineNumberTables.elementAt(j);
                int pos = lt.getPosition();
                int i = 0;
                while (i < lt.getNumEntries()) {
                    int startPC = this.getIntAt(pos);
                    int lineNumber = this.getIntAt(pos += 2);
                    this.setIntAt(ClassMapper.this.m_sourceMapper.getLineNumber(lineNumber), pos);
                    pos += 2;
                    ++acount;
                    ++i;
                }
                ++j;
            }
        }
    }
}

