/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.jsp;

import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIndexOutOfBoundsException;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.lib.FilterUtils;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;

public class JspWriterImpl
extends JspWriter {
    private Writer out;
    private ServletResponse response;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private boolean autoflush;
    private boolean isBuffered = true;
    private boolean isClosed = false;
    private boolean flushed = false;

    public JspWriterImpl(ServletResponse servletresponse, int i, boolean flag) {
        super(i, flag);
        if (i <= 0) {
            if (i == 0) {
                i = 1;
                this.isBuffered = false;
            } else {
                throw new WebIllegalArgumentException("servlet_jsp_0006");
            }
        }
        this.response = servletresponse;
        this.cb = new char[i];
        this.nChars = i;
        this.nextChar = 0;
        this.autoflush = flag;
        this.isClosed = false;
    }

    public final void init(ServletResponse servletresponse, int i, boolean flag) {
        this.out = null;
        ((Writer)((Object)this)).lock = this;
        this.bufferSize = i;
        this.autoFlush = flag;
        this.response = servletresponse;
        if (i == 0) {
            i = 1;
            this.isBuffered = false;
        } else {
            this.isBuffered = true;
        }
        if (i > 0 && (this.cb == null || i > this.cb.length)) {
            this.cb = new char[i];
        }
        this.nChars = i;
        this.nextChar = 0;
        this.autoflush = flag;
        this.isClosed = false;
        this.flushed = false;
    }

    public void markClosed() throws IOException {
        FilterUtils.unWrapResponse(this.response).markClosed();
    }

    final void flushBuffer() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (!this.ensureOpen()) {
                return;
            }
            if (this.nextChar == 0) {
                return;
            }
            if (this.out == null) {
                this.out = this.response.getWriter();
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
            this.flushed = true;
        }
    }

    private void flushToClient() throws IOException {
        if (this.out != null && this.isBuffered) {
            this.out.flush();
        }
    }

    public final void clear() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (!this.isBuffered) {
                throw new WebIOException("servlet_jsp_0030");
            }
            if (this.flushed) {
                throw new WebIOException("servlet_jsp_0031");
            }
            this.clearBuffer();
        }
    }

    private final void bufferOverflow() throws IOException {
        throw new WebIOException("servlet_jsp_0029");
    }

    public void flush() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.flushBuffer();
            if (this.out != null) {
                this.out.flush();
            }
            this.response.flushBuffer();
        }
    }

    public void close() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (this.response == null) {
                return;
            }
            FilterUtils.unWrapResponse(this.response).markClosed();
            this.flushBuffer();
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
            this.isClosed = true;
        }
    }

    public int getBufferSize() {
        return this.isBuffered ? this.nChars : 0;
    }

    public int getRemaining() {
        if (!this.isBuffered) {
            return 0;
        }
        return this.nChars - this.nextChar;
    }

    public boolean isAutoFlush() {
        return this.autoflush;
    }

    private boolean ensureOpen() throws IOException {
        if (this.response != null && FilterUtils.unWrapResponse(this.response).isSentError()) {
            return false;
        }
        if (this.response == null || this.isClosed) {
            throw new WebIOException("servlet_jsp_0024");
        }
        return true;
    }

    public void write(int i) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (!this.ensureOpen()) {
                return;
            }
            if (this.nextChar >= this.nChars) {
                if (this.autoflush) {
                    this.flushBuffer();
                    this.flushToClient();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)i;
        }
    }

    private int min(int i, int j) {
        if (i < j) {
            return i;
        }
        return j;
    }

    public void write(char[] ac, int i, int j) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (!this.ensureOpen()) {
                return;
            }
            if (i < 0 || i > ac.length || j < 0 || i + j > ac.length || i + j < 0) {
                throw new WebIndexOutOfBoundsException(WebIndexOutOfBoundsException.Incorrect_parameters_in_array_of_charactes_for_writing);
            }
            if (j == 0) {
                return;
            }
            if (j >= this.nChars) {
                if (this.autoflush) {
                    this.flushBuffer();
                    this.flushToClient();
                } else {
                    this.bufferOverflow();
                }
                this.out.write(ac, i, j);
                return;
            }
            int k = i;
            int l = i + j;
            while (k < l) {
                int i1 = this.min(this.nChars - this.nextChar, l - k);
                System.arraycopy(ac, k, this.cb, this.nextChar, i1);
                k += i1;
                this.nextChar += i1;
                if (this.nextChar < this.nChars) continue;
                if (this.autoflush) {
                    this.flushBuffer();
                    this.flushToClient();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(char[] ac) throws IOException {
        this.write(ac, 0, ac.length);
    }

    public void write(String s, int i, int j) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (!this.ensureOpen()) {
                return;
            }
            int k = i;
            int l = i + j;
            while (k < l) {
                int i1 = this.min(this.nChars - this.nextChar, l - k);
                s.getChars(k, k + i1, this.cb, this.nextChar);
                k += i1;
                this.nextChar += i1;
                if (this.nextChar < this.nChars) continue;
                if (this.autoflush) {
                    this.flushBuffer();
                    this.flushToClient();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void newLine() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.write(Constants.lineSeparator);
        }
    }

    public void print(boolean flag) throws IOException {
        this.write(flag ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] ac) throws IOException {
        this.write(ac);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean flag) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(flag);
            this.println();
        }
    }

    public void println(char c) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    public void println(int i) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(i);
            this.println();
        }
    }

    public void println(long l) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    public void println(float f) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    public void println(double d) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    public void println(char[] ac) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(ac);
            this.println();
        }
    }

    public void println(String s) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(s);
            this.println();
        }
    }

    public void println(Object obj) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(obj);
            this.println();
        }
    }

    public void clearBuffer() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.ensureOpen();
            this.nextChar = 0;
        }
    }
}

