/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.jsp;

import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibraryInfoImpl;
import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.PageDataImpl;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.ParserImpl;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.ServletNotFoundException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import com.sap.engine.services.servlets_jsp.server.jsp.Directive;
import com.sap.engine.services.servlets_jsp.server.jsp.GenerateJavaFile;
import com.sap.engine.services.servlets_jsp.server.jsp.JavaCompiler;
import com.sap.engine.services.servlets_jsp.server.jsp.eclipse.ClassMapper;
import com.sap.engine.services.servlets_jsp.server.jsp.exceptions.CompilingException;
import com.sap.engine.services.servlets_jsp.server.jsp.exceptions.ParseException;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;

public class JSPParser {
    private ApplicationContext context = null;
    private String workDir = null;
    private boolean isXml;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$jsp$JSPParser == null ? (class$com$sap$engine$services$servlets_jsp$server$jsp$JSPParser = JSPParser.class$("com.sap.engine.services.servlets_jsp.server.jsp.JSPParser")) : class$com$sap$engine$services$servlets_jsp$server$jsp$JSPParser));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$jsp$JSPParser;

    public JSPParser(ApplicationContext context) {
        this.context = context;
        this.workDir = context.getWorkingDir();
    }

    public String parse(String jspFile, String encoding, boolean needCompiling, ClassLoader threadLoader) throws ParseException, CompilingException, IOException {
        return this.parse(jspFile, encoding, needCompiling, threadLoader, null);
    }

    public String parse(String jspFile, String encoding, boolean needCompiling, ClassLoader threadLoader, HttpServletRequestFacade unwrappedRequest) throws ParseException, CompilingException, IOException {
        String newClass = null;
        String classNamesKey = null;
        if (unwrappedRequest == null) {
            classNamesKey = jspFile.substring(this.context.getWebApplicationRootDir().length() - 1);
        } else {
            int ind;
            String aliasName = unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasName().toString();
            String aliasValue = unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasValue().toString();
            if (aliasValue != null && aliasName != null && (ind = jspFile.indexOf(aliasValue)) != -1) {
                classNamesKey = "@" + jspFile;
            }
        }
        if (needCompiling) {
            try {
                ParserImpl pr = this.initParser(jspFile, encoding, threadLoader);
                newClass = this.generateJavaFile(jspFile, new File(jspFile).getCanonicalPath().replace(File.separatorChar, '/'), pr, classNamesKey);
            }
            catch (CompilingException e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(this.currentLocation, "Runtime error in compiling of the JSP file <" + jspFile + "> !", e, this.context.getAliasName());
                this.context.getClassNamesHashtable().remove(classNamesKey);
                throw new WebIOException("servlet_jsp_0028", new Object[]{jspFile}, e);
            }
        } else {
            newClass = (String)this.context.getClassNamesHashtable().get(classNamesKey);
            if (newClass == null) {
                throw new ParseException("servlet_jsp_0055");
            }
            if (Log.isTracing()) {
                Log.getLocation(3).traceInfo("The class for JSP file <" + jspFile + "> found. It will not be recompiled!\r\n" + "The servlet class is: " + newClass, this.context.getAliasName());
            }
        }
        return newClass;
    }

    private String getEncoding(String sJsp) {
        String contenTypeEncoding;
        String encoding;
        block15: {
            encoding = null;
            contenTypeEncoding = null;
            if (sJsp.indexOf("pageEncoding") == -1 && sJsp.indexOf("contentType") == -1 && sJsp.indexOf("response.setContentType(") == -1 && sJsp.indexOf("<jsp:directive.page") == -1) {
                return "ISO-8859-1";
            }
            if (this.isXml) {
                int pageStart = sJsp.indexOf("<jsp:directive.page");
                while (pageStart > -1) {
                    int pageEnd;
                    block16: {
                        pageEnd = sJsp.indexOf("/>", pageStart);
                        if (pageEnd == -1) break block15;
                        String directiveString = sJsp.substring(pageStart + 15, pageEnd);
                        try {
                            Directive directive = new Directive(directiveString);
                            String enc = (String)directive.getElements().get("pageEncoding");
                            if (enc == null) {
                                int loc;
                                enc = (String)directive.getElements().get("contentType");
                                if (enc != null && (loc = enc.indexOf("charset=")) != -1) {
                                    contenTypeEncoding = enc.substring(loc + 8);
                                }
                                break block16;
                            }
                            encoding = enc;
                            directive = null;
                            break;
                        }
                        catch (ParseException pe) {
                            Log.getCategory(2).logError(this.currentLocation, "Error in parsing the jsp file " + sJsp + " for encoding.", (Throwable)((Object)pe), "");
                        }
                    }
                    pageStart = sJsp.indexOf("<jsp:directive.page", pageEnd);
                }
            } else {
                int pageStart = sJsp.indexOf("<%@");
                while (pageStart > -1) {
                    int pageEnd;
                    block17: {
                        pageEnd = sJsp.indexOf("%>", pageStart);
                        if (pageEnd == -1) break block15;
                        String directiveString = sJsp.substring(pageStart + 3, pageEnd);
                        try {
                            Directive directive = new Directive(directiveString);
                            if (!"page".equals(directive.getName())) break block17;
                            String enc = (String)directive.getElements().get("pageEncoding");
                            if (enc == null) {
                                int loc;
                                enc = (String)directive.getElements().get("contentType");
                                if (enc != null && (loc = enc.indexOf("charset=")) != -1) {
                                    contenTypeEncoding = enc.substring(loc + 8);
                                }
                                break block17;
                            }
                            encoding = enc;
                            directive = null;
                            break;
                        }
                        catch (ParseException pe) {
                            Log.getCategory(2).logError(this.currentLocation, "Error in parsing the jsp file " + sJsp + " for encoding.", (Throwable)((Object)pe), "");
                        }
                    }
                    pageStart = sJsp.indexOf("<%@", pageEnd);
                }
            }
        }
        if (encoding == null) {
            if (contenTypeEncoding != null) {
                return contenTypeEncoding;
            }
            encoding = "ISO-8859-1";
        }
        return encoding;
    }

    private void validate(PageDataImpl page, Hashtable tagLibsInPage) throws ParseException {
        if (!this.context.getWebComponents().hasTagLibraryValidators()) {
            return;
        }
        Enumeration enumeration = tagLibsInPage.elements();
        while (enumeration.hasMoreElements()) {
            TagLibraryInfoImpl tli = (TagLibraryInfoImpl)enumeration.nextElement();
            TagLibraryValidator tlv = this.context.getWebComponents().getTagLibraryValidator(tli.getURI());
            if (tlv == null) continue;
            tlv.setInitParameters((Map)tli.getValidator().getInitParamsMap());
            ValidationMessage[] errors = tlv.validate(tli.getPrefixString(), tli.getURI(), (PageData)page);
            tlv.release();
            if (errors == null || errors.length == 0) continue;
            String msg = "\n\t";
            int i = 0;
            while (i < errors.length) {
                msg = msg + errors[i].getMessage() + "\n\t";
                ++i;
            }
            throw new ParseException("servlet_jsp_0056", new Object[]{tli.getURI(), msg});
        }
    }

    private String getFileName(String jspFile) {
        String className = jspFile.substring(jspFile.lastIndexOf("/") + 1, jspFile.lastIndexOf("."));
        StringBuffer javaClassName = new StringBuffer();
        char c = className.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            javaClassName.append(c);
        } else {
            javaClassName.append("_" + Integer.toHexString(c) + "_");
        }
        int i = 1;
        while (i < className.length()) {
            c = className.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                javaClassName.append(c);
            } else {
                javaClassName.append("_" + Integer.toHexString(c) + "_");
            }
            ++i;
        }
        className = "jsp_" + javaClassName;
        return this.workDir + className + System.currentTimeMillis() + ".java";
    }

    private String readFile(File file) throws ServletNotFoundException, ParseException {
        if (!file.isFile()) {
            throw new ServletNotFoundException(ServletNotFoundException.Requested_resource_not_found, new Object[]{file.getName()});
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            char[] source = new char[fis.available()];
            isr.read(source);
            isr.close();
            if (source.length > 2 && (source[0] == '\u00ff' && source[1] == '\u00fe' || source[0] == '\u00fe' && source[1] == '\u00ff')) {
                fis = new FileInputStream(file);
                isr = new InputStreamReader((InputStream)fis, "Unicode");
                source = new char[fis.available()];
                isr.read(source);
                isr.close();
            }
            return String.valueOf(source).trim();
        }
        catch (IOException io) {
            throw new ParseException("servlet_jsp_0054", new Object[]{file.getName()}, io);
        }
    }

    private void checkXml(String sJsp) {
        this.isXml = sJsp.indexOf("<jsp:root") > -1;
    }

    private void putJSPinClassNamesHashtable(String jspFile, String newClass, String _javaFile, String classNamesKey) {
        String oldJSP = (String)this.context.getClassNamesHashtable().get(classNamesKey);
        this.context.getClassNamesHashtable().put(classNamesKey, newClass);
        if (oldJSP == null) {
            return;
        }
        String path = _javaFile.substring(0, _javaFile.lastIndexOf(47) + 1);
        try {
            new File(path + oldJSP + ".java").delete();
            new File(path + oldJSP + ".class").delete();
        }
        catch (SecurityException _) {
            Log.getCategory(2).logError(this.currentLocation, "Error deleting the old java and class files generated for the jsp file " + jspFile + ".", _, "");
        }
    }

    private ParserImpl initParser(String jspFile, String encoding, ClassLoader threadLoader) throws ServletNotFoundException, JspParseException, ParseException, IOException {
        ParserImpl pr = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader inThreadLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(threadLoader);
        try {
            File file = new File(jspFile);
            String jspStr = this.readFile(file);
            this.checkXml(jspStr);
            if (encoding == null) {
                encoding = this.getEncoding(jspStr);
            }
            pr = new ParserImpl(file, this.context.getClassLoader(), this.context.getClass().getClassLoader(), this.context.getWebApplicationRootDir(), this.context.getWebComponents().getTagLibDescriptors(), encoding);
            pr.setIsXml(this.isXml);
            String filePath = file.getCanonicalPath();
            pr.setPath(filePath.substring(0, filePath.lastIndexOf(File.separator)));
            pr.parse().action();
            Object var11_10 = null;
            currentThread.setContextClassLoader(inThreadLoader);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            currentThread.setContextClassLoader(inThreadLoader);
            throw throwable;
        }
        if (pr != null && pr.getTaglibs() != null && pr.getTaglibs().size() > 0) {
            PageDataImpl pageData = new PageDataImpl(pr.getParsed(), this.isXml);
            currentThread.setContextClassLoader(threadLoader);
            try {
                this.validate(pageData, pr.getTaglibs());
                Object var13_13 = null;
                currentThread.setContextClassLoader(inThreadLoader);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                currentThread.setContextClassLoader(inThreadLoader);
                throw throwable;
            }
        }
        return pr;
    }

    private String generateJavaFile(String jspFile, String jspFileName, ParserImpl pr, String classNamesKey) throws CompilingException {
        String _javaFile = this.getFileName(jspFile);
        String newClass = _javaFile.substring(_javaFile.lastIndexOf("/") + 1, _javaFile.lastIndexOf("."));
        this.putJSPinClassNamesHashtable(jspFileName, newClass, _javaFile, classNamesKey);
        if (Log.isTracing()) {
            Log.getLocation(3).traceInfo("The JSP file <" + jspFile + "> is successfully parsed!", this.context.getAliasName());
        }
        new GenerateJavaFile(pr, _javaFile, newClass);
        JavaCompiler compiler = new JavaCompiler();
        try {
            compiler.compile(_javaFile, this.workDir, this.context.getApplicationName(), this.context.getJarClassPathHashtable(new ArrayObject()));
        }
        catch (CompilingException tr) {
            this.context.getClassNamesHashtable().remove(classNamesKey);
            if (Log.isTracing()) {
                Log.getLocation(3).traceInfo("Error in compiling of the JSP file <" + jspFile + "> !\r\n" + "The Java file is: " + _javaFile, this.context.getAliasName());
            }
            throw tr;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(2).logError(this.currentLocation, "Error in compiling the jsp file " + jspFile + ".", e, "");
            throw new CompilingException(CompilingException.ERROR_IN_COMPILING_THE_JSP_FILE, new Object[]{jspFile}, e);
        }
        if (SBasic.webContainerProperties.eclipseSupport()) {
            String className = _javaFile.substring(0, _javaFile.length() - 4) + "class";
            new ClassMapper().runMain(className, _javaFile, jspFile);
        }
        if (Log.isTracing()) {
            Log.getLocation(3).traceInfo("The generated Java file for the JSP file <" + jspFile + "> is successfully compiled!\r\n", this.context.getAliasName());
        }
        try {
            int count = 0;
            while ((long)count < 100L) {
                try {
                    SBasic.persistentStorage.writeHashtable(this.context.getApplicationName() + "/" + SBasic.serverId + "/" + this.context.getAliasForDirectory(), this.context.getClassNamesHashtable());
                    break;
                }
                catch (InconsistentReadException e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Log.getCategory(4).logError(this.currentLocation, "Error in waiting for READ configuration!", ie, "");
                    }
                    if ((long)count == 99L) {
                        Log.getCategory(4).logError(this.currentLocation, "Cannot store information about the compiled jsp classes.", (Throwable)((Object)e), "");
                    }
                    ++count;
                }
            }
        }
        catch (IOException e) {
            Log.getCategory(4).logError(this.currentLocation, "Cannot store information about the compiled jsp classes.", e, "");
        }
        return newClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

