/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.jsp;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.ParserImpl;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.jsp.GenerateJavaFile;
import com.sap.engine.services.servlets_jsp.server.jsp.JSPParser;
import com.sap.engine.services.servlets_jsp.server.jsp.exceptions.CompilingException;
import com.sap.engine.services.servlets_jsp.server.jsp.exceptions.ParseException;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.jsp.HttpJspPage;

public class JSPCompiler
extends Thread {
    private String rootdir = null;
    private ApplicationContext context;
    private JSPParser parser = null;
    private static String classPath = null;
    private static String outputDir = null;
    private static boolean recursive = false;
    private static int countOK = 0;
    private static int countFail = 0;
    private static String quote = "";
    private static String sepPath = SystemProperties.getProperty("path.separator");
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$jsp$JSPCompiler == null ? (class$com$sap$engine$services$servlets_jsp$server$jsp$JSPCompiler = JSPCompiler.class$("com.sap.engine.services.servlets_jsp.server.jsp.JSPCompiler")) : class$com$sap$engine$services$servlets_jsp$server$jsp$JSPCompiler));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$jsp$JSPCompiler;

    public JSPCompiler() {
    }

    public JSPCompiler(ApplicationContext context, String root) {
        this.context = context;
        this.rootdir = root;
        this.parser = new JSPParser(context);
    }

    public void compile(String jspFile) {
        File f = new File(jspFile);
        try {
            long lastM = 0L;
            boolean needCompiling = false;
            if (lastM < f.lastModified()) {
                needCompiling = true;
            } else {
                HttpJspPage jsp;
                Object className = null;
                if (this.context != null) {
                    String classNamesKey = jspFile.substring(this.context.getWebApplicationRootDir().length() - 1);
                    className = this.context.getClassNamesHashtable().get(classNamesKey);
                }
                if (className != null && (jsp = this.context.getWebComponents().getJSP(className, null)) == null) {
                    needCompiling = true;
                }
            }
            this.parser.parse(jspFile, null, needCompiling, SBasic.classLoader);
            if (needCompiling) {
                Log.getLocation(3).traceInfo("JSPCompiler > COMPILED : " + jspFile, this.context.getAliasName());
            } else {
                Log.getLocation(3).traceInfo("JSPCompiler > Don't need compiling : " + jspFile, this.context.getAliasName());
            }
        }
        catch (ParseException pex) {
            Log.getCategory(2).logError(this.currentLocation, "Error in parsing the jsp file " + jspFile + ".", (Throwable)((Object)pex), this.context.getAliasName());
        }
        catch (CompilingException pex) {
            Log.getCategory(2).logError(this.currentLocation, "Error in compiling the jsp file " + jspFile + ".", (Throwable)((Object)pex), this.context.getAliasName());
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(2).logError(this.currentLocation, "Error in generating a servlet from the jsp file " + jspFile + ".", e, this.context.getAliasName());
        }
    }

    public void run() {
        Log.getLocation(3).traceInfo("Start compiling all jsp files in the applicatiion.", this.context.getAliasName());
        try {
            this.compileJsp();
            SBasic.persistentStorage.writeHashtable(this.context.getApplicationName() + "/" + SBasic.serverId + "/" + this.context.getAliasForDirectory(), this.context.getClassNamesHashtable());
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(2).logError(this.currentLocation, "Error in compiling all jsp files of the application.", e, this.context.getAliasName());
        }
        Log.getLocation(3).traceInfo("The compiling of all jsp files in the applicatiion finished.", this.context.getAliasName());
    }

    private void compileJsp() throws Exception {
        this.recursiveFind(this.rootdir);
    }

    private void recursiveFind(String dirName) throws Exception {
        File[] dirFiles;
        File f = new File(dirName);
        if (f.isDirectory() && (dirFiles = f.listFiles()) != null) {
            int i = 0;
            while (i < dirFiles.length) {
                if (dirFiles[i].exists()) {
                    if (dirFiles[i].isDirectory()) {
                        this.recursiveFind(dirFiles[i].getPath().replace(File.separatorChar, '/'));
                    } else if (dirFiles[i].getName().toUpperCase().endsWith(".JSP")) {
                        this.compile(dirFiles[i].getAbsolutePath().replace(File.separatorChar, '/'));
                    }
                }
                ++i;
            }
        }
    }

    private String readFile(File file) throws ParseException {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            char[] source = new char[fis.available()];
            isr.read(source);
            isr.close();
            return String.valueOf(source).trim();
        }
        catch (IOException io) {
            throw new ParseException("servlet_jsp_0054", new Object[]{file.getName()}, io);
        }
    }

    private void process(String jspFile) {
        try {
            System.out.println("Compiling > " + jspFile);
            ParserImpl pr = null;
            File file = new File(jspFile);
            String jspStr = this.readFile(file);
            pr = new ParserImpl(file, null);
            pr.setIsXml(jspStr.indexOf("<jsp:root") > -1);
            pr.parse().action();
            String newClass = jspFile.substring(jspFile.lastIndexOf("/") + 1, jspFile.lastIndexOf("."));
            String javaName = outputDir + (outputDir.endsWith("/") ? "" : "/") + newClass + ".java";
            new GenerateJavaFile(pr, javaName, newClass);
            this.doCompile(javaName);
            ++countOK;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            ++countFail;
            Log.getCategory(2).logError(this.currentLocation, "Error in compiling the jsp file " + jspFile + ".", e, "");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doCompile(String file) throws CompilingException, IOException {
        Runtime r = Runtime.getRuntime();
        Process p = null;
        String generateDir = outputDir;
        if (outputDir.endsWith("/")) {
            generateDir = outputDir.substring(0, outputDir.length() - 1);
        }
        try {
            String[] as = new String[]{"javac", "-nowarn", file, "-classpath", quote + SystemProperties.getProperty("java.class.path") + sepPath + classPath + quote, "-d", generateDir};
            p = r.exec(as);
        }
        catch (IOException ex) {
            String javaHome = SystemProperties.getProperty("java.home");
            if (javaHome != null && javaHome.length() > 0 && (javaHome.endsWith("jre") || javaHome.endsWith("jre" + File.separator))) {
                javaHome = javaHome.substring(0, javaHome.indexOf("jre"));
                javaHome = javaHome + "bin" + File.separator + "javac";
            }
            String[] as = new String[]{javaHome, "-nowarn", file, "-classpath", quote + SystemProperties.getProperty("java.class.path") + sepPath + classPath + quote, "-d", generateDir};
            p = r.exec(as);
        }
        InputStream is = p.getErrorStream();
        StringBuffer errBuffer = new StringBuffer();
        while (true) {
            int c;
            if ((c = is.read()) != -1) {
                void as;
                errBuffer.append((char)as);
                continue;
            }
            try {
                if (p.exitValue() != 0) {
                    throw new CompilingException(CompilingException.ERROR_IN_EXECUTING_THE_PROCESS_OF_COMPILATION, new Object[]{errBuffer.toString()});
                }
                if (errBuffer.length() <= 0) break;
                return;
            }
            catch (IllegalThreadStateException e) {
                continue;
            }
            break;
        }
    }

    private void processRecursive(File f, String parent) {
        File[] dirFiles = f.listFiles();
        if (dirFiles != null) {
            int i = 0;
            while (i < dirFiles.length) {
                if (dirFiles[i].exists()) {
                    if (dirFiles[i].isDirectory()) {
                        outputDir = parent + "/" + dirFiles[i].getName();
                        this.processRecursive(dirFiles[i], outputDir);
                    } else if (dirFiles[i].getName().toUpperCase().endsWith(".JSP")) {
                        outputDir = parent;
                        new File(outputDir).mkdirs();
                        this.process(dirFiles[i].getAbsolutePath().replace(File.separatorChar, '/'));
                    }
                }
                ++i;
            }
        }
    }

    private static void usage() {
        System.out.println("\nUSAGE:");
        System.out.println("\n java JSPCompiler -cp <classpath> -d <output directory> path <file> -s");
        System.out.println("\n\t[-cp]  classpath");
        System.out.println("\n\t[-d]   directory for generated files");
        System.out.println("\n\t[path] path to jsp file or directory with jsp files");
        System.out.println("\n\t[-s]   searching in subdirectories");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("-?") || args[0].equals("?") || args[0].toLowerCase().startsWith("-h")) {
            JSPCompiler.usage();
            return;
        }
        cmd = null;
        files = null;
        i = 0;
        while (i < args.length) {
            cmd = args[i];
            if (cmd.equals("-cp")) {
                JSPCompiler.classPath = args[++i];
            } else if (cmd.equals("-d")) {
                JSPCompiler.outputDir = args[++i];
            } else if (cmd.equals("-s")) {
                JSPCompiler.recursive = true;
            } else if (files == null) {
                files = args[i];
            } else {
                System.out.println("\nError in parameters!\n");
                JSPCompiler.usage();
                return;
            }
            ++i;
        }
        if (JSPCompiler.classPath == null) {
            JSPCompiler.classPath = ".";
        }
        if (JSPCompiler.outputDir == null) {
            JSPCompiler.outputDir = ".";
        }
        if (files == null) {
            files = ".";
        }
        try {
            JSPCompiler.quote = SystemProperties.getProperty("os.name").toUpperCase().startsWith("WINDOWS") != false ? "\"" : "";
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Can't get the system property \"os.name\".");
            e.printStackTrace();
            JSPCompiler.quote = "";
        }
        new File(JSPCompiler.outputDir).mkdirs();
        System.out.println("\n");
        f = new File(files);
        if (!f.exists()) ** GOTO lbl68
        comp = new JSPCompiler();
        if (f.isDirectory()) {
            if (JSPCompiler.recursive) {
                comp.processRecursive(f, JSPCompiler.outputDir);
            } else {
                list = f.listFiles();
                path = null;
                i = 0;
                while (i < list.length) {
                    path = list[i].getAbsolutePath().replace(File.separatorChar, '/');
                    if (path.toLowerCase().endsWith(".jsp")) {
                        comp.process(path);
                    }
                    ++i;
                }
            }
        } else if (files.toLowerCase().endsWith(".jsp")) {
            comp.process(f.getAbsolutePath().replace(File.separatorChar, '/'));
        } else {
            System.out.println("\nFile (" + files + ") must be with .jsp extention!\n");
            return;
lbl68:
            // 1 sources

            System.out.println("\nFile (" + files + ") not found!\n");
            return;
        }
        System.out.println("\nTotal compiled : " + (JSPCompiler.countOK + JSPCompiler.countFail));
        System.out.println("            OK : " + JSPCompiler.countOK);
        System.out.println("        Failed : " + JSPCompiler.countFail);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

