/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.jsp;

import com.sap.engine.services.servlets_jsp.server.exceptions.WebIndexOutOfBoundsException;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

public class BodyContentImpl
extends BodyContent {
    private static final int K = 1024;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufferSize = 8192;
    private char[] cb = new char[this.bufferSize];
    private int nextChar = 0;

    public BodyContentImpl(JspWriter writer) {
        super(writer);
    }

    public void write(int c) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (this.nextChar >= this.bufferSize) {
                this.reAllocBuff(0);
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new WebIndexOutOfBoundsException(WebIndexOutOfBoundsException.Incorrect_parameters_in_array_of_charactes_for_writing);
            }
            if (len == 0) {
                return;
            }
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
            this.nextChar += len;
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            if (len >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(len);
            }
            s.getChars(off, off + len, this.cb, this.nextChar);
            this.nextChar += len;
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void newLine() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.write(Constants.lineSeparator);
        }
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(char x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(int x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(long x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(float x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(double x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(char[] x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(String x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void println(Object x) throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    public void clear() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.cb = new char[8192];
            this.bufferSize = 8192;
            this.nextChar = 0;
        }
    }

    public void clearBuffer() throws IOException {
        this.clear();
    }

    public void close() throws IOException {
        Object object = ((Writer)((Object)this)).lock;
        synchronized (object) {
            this.cb = null;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    public Reader getReader() {
        return new CharArrayReader(this.cb, 0, this.nextChar);
    }

    public String getString() {
        return new String(this.cb, 0, this.nextChar);
    }

    public void writeOut(Writer out) throws IOException {
        out.write(this.cb, 0, this.nextChar);
    }

    private void reAllocBuff(int len) {
        char[] tmp = new char[this.bufferSize];
        System.arraycopy(this.cb, 0, tmp, 0, this.cb.length);
        if (len <= 8192) {
            this.cb = new char[this.bufferSize + 8192];
            this.bufferSize += 8192;
        } else {
            this.cb = new char[this.bufferSize + len];
            this.bufferSize += len;
        }
        System.arraycopy(tmp, 0, this.cb, 0, tmp.length);
    }
}

