/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.UpdateSecurityContext;
import com.sap.engine.lib.lang.ObjectPool;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.AdditionalWebDescrDocument;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.WebMonitoring;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainer;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebContainerServiceException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebResourceAccessor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.jsp.JspFactoryImpl;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.security.auth.login.AppConfigurationEntry;
import javax.servlet.jsp.JspFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WebContainerHelper {
    private HttpProvider httpProvider = null;
    private WebMonitoring monitoring = null;
    private SecurityContext securityContext = null;
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$container$WebContainerHelper;
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade;
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade;

    public WebContainerHelper(SecurityContext securityContext, WebMonitoring monitoring) throws WebContainerServiceException {
        this.securityContext = securityContext;
        this.monitoring = monitoring;
        this.sendAppAliasesToHttp();
    }

    private void sendAppAliasesToHttp() {
        String[] allAppls = SBasic.deployCommunicator.getDeployedApplications();
        if (allAppls == null) {
            return;
        }
        int j = 0;
        while (j < allAppls.length) {
            try {
                String[] aliases = SBasic.deployCommunicator.getAliases(allAppls[j]);
                if (aliases != null) {
                    int k = 0;
                    while (k < aliases.length) {
                        if (aliases[k].equals("/") || aliases[k].equals("\\")) {
                            SBasic.startedWebApplications.remove(Constants.defaultAliasMB);
                        } else {
                            SBasic.startedWebApplications.remove(new MessageBytes(ParseUtils.separatorsToFS((String)aliases[k])));
                        }
                        ++k;
                    }
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(WebContainer.currentLocation, "Cannot add http aliases to http server ", e, "");
            }
            ++j;
        }
    }

    public void setHttp(HttpProvider httpProvider) {
        this.httpProvider = httpProvider;
    }

    public HttpProvider getHttpProvider() {
        return this.httpProvider;
    }

    public Vector deploy(String applicationName, String aliasName, Configuration appConfig, String[] addedAliases) throws DeploymentException {
        Vector warnings = new Vector();
        if (!aliasName.equals("/") && !aliasName.equals("\\")) {
            aliasName = ParseUtils.convertAlias((String)aliasName);
        }
        this.initXmls(applicationName, aliasName, appConfig, warnings, addedAliases);
        return warnings;
    }

    public Vector update(String applicationName, String aliasName, Configuration appConfig) throws DeploymentException {
        Vector warnings = new Vector();
        String aliasDir = aliasName;
        if (aliasDir.equals("/") || aliasDir.equals("\\")) {
            aliasDir = "_default";
        }
        aliasName = ParseUtils.convertAlias((String)aliasName);
        String tempDir = this.getDeployTempDir(applicationName);
        tempDir = tempDir + "/" + aliasDir + "/" + "root" + "/";
        this.removeSecurityResources(applicationName, aliasName);
        this.initXmls(applicationName, aliasName, appConfig, warnings, null);
        SBasic.startedWebApplications.remove(new MessageBytes(aliasName.getBytes()));
        return warnings;
    }

    /*
     * Loose catch block
     */
    public void updateSecurity(String applicationName, File[] archiveFiles, Configuration appConfig) throws DeploymentException {
        String[] changedArchives = new String[archiveFiles.length];
        int i = 0;
        while (i < archiveFiles.length) {
            changedArchives[i] = archiveFiles[i].getName();
            ++i;
        }
        String[] oldAliases = SBasic.deployCommunicator.getAliases(applicationName);
        int i2 = 0;
        while (i2 < changedArchives.length) {
            block61: {
                String alias = SBasic.deployCommunicator.getAlias(changedArchives[i2], applicationName);
                boolean aliasFound = false;
                int j = 0;
                while (oldAliases != null && j < oldAliases.length) {
                    if (oldAliases[j].equals(alias)) {
                        aliasFound = true;
                        break;
                    }
                    ++j;
                }
                if (alias != null && aliasFound) {
                    IOException io2222;
                    Object var42_49;
                    ZipInputStream updatedXmlInputStream;
                    FileInputStream existingAdditionalXmlInputStream;
                    FileInputStream existingXmlInputStream;
                    block59: {
                        block58: {
                            Node node;
                            NodeList globalRoles;
                            Object var37_45;
                            Configuration config = null;
                            if (alias.startsWith("/") && !alias.equals("/")) {
                                alias = alias.substring(1);
                            }
                            if (alias.trim().equals("")) {
                                throw new WebDeploymentException(WebDeploymentException.EMPTY_CONTEXT_ROOT_FOR_ARCHIVE_IN_APPLICATION, new Object[]{changedArchives[i2], applicationName});
                            }
                            if (alias.equals("/") || alias.equals("\\")) {
                                alias = "_default";
                            }
                            String aliasForSecurity = null;
                            try {
                                aliasForSecurity = alias.replace('/', '_').replace('\\', '_');
                                config = appConfig.getSubConfiguration(aliasForSecurity);
                            }
                            catch (ConfigurationException e) {
                                Log.getCategory(1).logError(WebContainer.currentLocation, "Cannot get the configuration [" + aliasForSecurity + "] for " + changedArchives[i2] + " war file!", (Throwable)((Object)e), "");
                                throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_CONFIGURATION_FOR_APPLICATION, new Object[]{aliasForSecurity, applicationName}, (Throwable)((Object)e));
                            }
                            aliasForSecurity = alias.replace('/', '_').replace('\\', '_');
                            String policyConfigurationName = applicationName + "*" + aliasForSecurity;
                            String existingXmlFile = null;
                            String existingAdditonalXmlFile = null;
                            String existingApplicationDir = this.getDeployTempDir(applicationName);
                            existingApplicationDir = existingApplicationDir + "/" + alias + "/" + "root" + "/";
                            NodeList existingRoleMappings = null;
                            NodeList existingAuthenticationStack = null;
                            NodeList updatedRoleMappings = null;
                            NodeList updatedAuthenticationStack = null;
                            NodeList existingRoles = null;
                            NodeList updatedRoles = null;
                            String authMethod = "";
                            String policyDomain = "";
                            String realmName = "";
                            existingXmlInputStream = null;
                            existingAdditionalXmlInputStream = null;
                            updatedXmlInputStream = null;
                            InputStream globalWebXmlFile = null;
                            InputStream globalAddWebXmlFile = null;
                            existingXmlFile = existingApplicationDir + "WEB-INF" + File.separator + "web.xml";
                            if (!new File(existingXmlFile).exists()) {
                                throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                            }
                            existingAdditonalXmlFile = existingApplicationDir + "WEB-INF" + File.separator + "web-j2ee-engine.xml";
                            if (!new File(existingAdditonalXmlFile).exists()) {
                                existingAdditonalXmlFile = null;
                            }
                            try {
                                globalWebXmlFile = SBasic.persistentContainer.getPersistentEntryStream("global-web.xml", true);
                            }
                            catch (ServiceException se) {
                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while reading default web.xml while deploying " + alias + " application", alias);
                            }
                            try {
                                globalAddWebXmlFile = SBasic.persistentContainer.getPersistentEntryStream("web-j2ee-engine.xml", true);
                            }
                            catch (ServiceException se) {
                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while reading default additional web.xml while deploying " + alias + " application", alias);
                            }
                            Document parsed = null;
                            Document globalWebXmlParsed = null;
                            Document globalAddXmlParsed = null;
                            StandardDOMParser parser = null;
                            ClassLoader previousLoader = null;
                            try {
                                previousLoader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$servlets_jsp$server$container$WebContainerHelper == null ? WebContainerHelper.class$("com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper") : class$com$sap$engine$services$servlets_jsp$server$container$WebContainerHelper).getClassLoader());
                                parser = new StandardDOMParser();
                                var37_45 = null;
                                Thread.currentThread().setContextClassLoader(previousLoader);
                            }
                            catch (Throwable throwable) {
                                var37_45 = null;
                                Thread.currentThread().setContextClassLoader(previousLoader);
                                throw throwable;
                            }
                            if (SBasic.webContainerProperties.validateDescriptors()) {
                                parser.setValidation(true);
                            } else {
                                parser.setValidation(false);
                                parser.setReadDTD(false);
                            }
                            boolean webXmlFound = false;
                            ZipEntry zipEntry = null;
                            updatedXmlInputStream = new ZipInputStream(new FileInputStream(archiveFiles[i2]));
                            while ((zipEntry = updatedXmlInputStream.getNextEntry()) != null) {
                                Node globalNode;
                                if (!zipEntry.getName().equals("WEB-INF/web.xml")) continue;
                                webXmlFound = true;
                                parsed = parser.parse((InputStream)updatedXmlInputStream);
                                globalWebXmlParsed = parser.parse(globalWebXmlFile);
                                globalRoles = globalWebXmlParsed.getElementsByTagName("security-role");
                                updatedRoles = this.merge(parsed, globalRoles, "security-role", "role-name");
                                node = parsed.getElementsByTagName("auth-method").item(0);
                                if (node != null) {
                                    authMethod = node.getFirstChild().getNodeValue();
                                } else {
                                    globalNode = globalWebXmlParsed.getElementsByTagName("auth-method").item(0);
                                    if (globalNode != null) {
                                        authMethod = globalNode.getFirstChild().getNodeValue();
                                    }
                                }
                                node = parsed.getElementsByTagName("realm-name").item(0);
                                if (node != null) {
                                    realmName = node.getFirstChild().getNodeValue();
                                    break;
                                }
                                globalNode = globalWebXmlParsed.getElementsByTagName("realm-name").item(0);
                                if (globalNode == null) break;
                                realmName = globalNode.getFirstChild().getNodeValue();
                                break;
                            }
                            if (!webXmlFound) {
                                throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                            }
                            updatedXmlInputStream = new ZipInputStream(new FileInputStream(archiveFiles[i2]));
                            while ((zipEntry = updatedXmlInputStream.getNextEntry()) != null) {
                                if (!zipEntry.getName().equals("WEB-INF/web-j2ee-engine.xml")) continue;
                                parsed = parser.parse((InputStream)updatedXmlInputStream);
                                globalAddXmlParsed = parser.parse(globalAddWebXmlFile);
                                NodeList globalRoleMap = globalAddXmlParsed.getElementsByTagName("security-role-map");
                                updatedRoleMappings = this.merge(parsed, globalRoleMap, "security-role-map", "role-name");
                                updatedAuthenticationStack = parsed.getElementsByTagName("login-module");
                                if (updatedAuthenticationStack == null && globalAddWebXmlFile != null) {
                                    updatedAuthenticationStack = globalAddXmlParsed.getElementsByTagName("login-module");
                                }
                                if ((node = parsed.getElementsByTagName("security-policy-domain").item(0)) != null) {
                                    policyDomain = node.getFirstChild().getNodeValue();
                                    break;
                                }
                                node = globalAddXmlParsed.getElementsByTagName("security-policy-domain").item(0);
                                if (node == null) break;
                                policyDomain = node.getFirstChild().getNodeValue();
                                break;
                            }
                            existingXmlInputStream = new FileInputStream(existingXmlFile);
                            parsed = parser.parse((InputStream)existingXmlInputStream);
                            if (globalWebXmlParsed == null) {
                                globalWebXmlParsed = parser.parse(globalWebXmlFile);
                            }
                            globalRoles = globalWebXmlParsed.getElementsByTagName("security-role");
                            existingRoles = this.merge(parsed, globalRoles, "security-role", "role-name");
                            if (existingAdditonalXmlFile != null && new File(existingAdditonalXmlFile).exists()) {
                                existingAdditionalXmlInputStream = new FileInputStream(existingAdditonalXmlFile);
                            }
                            if (globalAddXmlParsed == null) {
                                globalAddXmlParsed = parser.parse(globalAddWebXmlFile);
                            }
                            if (existingAdditionalXmlInputStream != null) {
                                parsed = parser.parse((InputStream)existingAdditionalXmlInputStream);
                                existingRoleMappings = parsed.getElementsByTagName("security-role-map");
                                existingAuthenticationStack = parsed.getElementsByTagName("login-module");
                            }
                            if (existingRoleMappings == null) {
                                existingRoleMappings = globalAddXmlParsed.getElementsByTagName("security-role-map");
                            }
                            if (existingAuthenticationStack == null) {
                                existingAuthenticationStack = globalAddXmlParsed.getElementsByTagName("login-module");
                            }
                            SecurityContext mySecurityContext = this.securityContext.getModificationContext().beginModifications(config);
                            mySecurityContext = mySecurityContext.getPolicyConfigurationContext(policyConfigurationName);
                            UpdateSecurityContext updateContext = this.securityContext.getUpdateSecurityContext();
                            updateContext.setSecurityContext(mySecurityContext);
                            updateContext.setDefaultSourceRoles(existingRoles);
                            updateContext.setDefaultSourceRoleMappings(existingRoleMappings);
                            updateContext.setDefaultSourceAuthenticationStack(existingAuthenticationStack);
                            updateContext.setDefaultTargetRoles(updatedRoles);
                            updateContext.setDefaultTargetRoleMappings(updatedRoleMappings);
                            updateContext.setDefaultTargetAuthenticationStack(updatedAuthenticationStack);
                            updateContext.updateAuthentication();
                            updateContext.updateAuthorization();
                            if (authMethod != null) {
                                mySecurityContext.getAuthenticationContext().setProperty("auth_method", authMethod.toLowerCase());
                            }
                            if (policyDomain == null || policyDomain.length() == 0) {
                                policyDomain = "/" + alias;
                            }
                            mySecurityContext.getAuthenticationContext().setProperty("policy_domain", policyDomain);
                            if (realmName == null) break block58;
                            mySecurityContext.getAuthenticationContext().setProperty("realm_name", realmName);
                        }
                        var42_49 = null;
                        if (existingXmlInputStream == null) break block59;
                        try {
                            existingXmlInputStream.close();
                        }
                        catch (IOException io2222) {
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while deploying " + alias + " application", alias);
                        }
                    }
                    if (existingAdditionalXmlInputStream != null) {
                        try {
                            existingAdditionalXmlInputStream.close();
                        }
                        catch (IOException io2222) {
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while deploying " + alias + " application", alias);
                        }
                    }
                    if (updatedXmlInputStream != null) {
                        try {
                            updatedXmlInputStream.close();
                        }
                        catch (IOException io2222) {
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing ZipInputStream for the WAR file while deploying " + alias + " application", alias);
                        }
                    }
                    break block61;
                    {
                        catch (OutOfMemoryError e) {
                            throw e;
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (IOException io33) {
                            throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                        }
                        catch (Throwable e) {
                            Log.getCategory(1).logError(WebContainer.currentLocation, "Parsing " + archiveFiles[i2] + " of " + applicationName + " web application in non-validation mode failed!", e, applicationName);
                            throw new WebDeploymentException(WebDeploymentException.CANNOT_READ_XML_OR_ERROR_IN_XML_FOR_WEB_APPLICATION, new Object[]{archiveFiles[i2], applicationName}, e);
                        }
                    }
                    catch (Throwable throwable) {
                        var42_49 = null;
                        if (existingXmlInputStream != null) {
                            try {
                                existingXmlInputStream.close();
                            }
                            catch (IOException io2222) {
                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while deploying " + alias + " application", alias);
                            }
                        }
                        if (existingAdditionalXmlInputStream != null) {
                            try {
                                existingAdditionalXmlInputStream.close();
                            }
                            catch (IOException io2222) {
                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while deploying " + alias + " application", alias);
                            }
                        }
                        if (updatedXmlInputStream != null) {
                            try {
                                updatedXmlInputStream.close();
                            }
                            catch (IOException io2222) {
                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing ZipInputStream for the WAR file while deploying " + alias + " application", alias);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            ++i2;
        }
    }

    public void remove(String applicationName, String aliasName, boolean isUpdate) {
        if (aliasName == null || applicationName == null) {
            return;
        }
        if (!isUpdate) {
            this.removeSecurityResources(applicationName, aliasName);
        }
    }

    private ApplicationContext createDefaultContext(String applicationName, String aliasName, Configuration appConfig, Vector warnings) throws DeploymentException {
        if (SBasic.httpServletRequestPool == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
            SBasic.httpServletRequestPool = new ObjectPool(2, 5000, 8, class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade = WebContainerHelper.class$("com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade")) : class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade);
            SBasic.httpServletResponsePool = new ObjectPool(2, 5000, 8, class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade = WebContainerHelper.class$("com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade")) : class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade);
        }
        aliasName = ParseUtils.convertAlias((String)aliasName);
        ApplicationContext scf = (ApplicationContext)SBasic.startedWebApplications.get(Constants.defaultAliasMB);
        if (scf == null) {
            scf = new ApplicationContext(applicationName, aliasName, true, this.httpProvider, this.monitoring);
            try {
                String failoverDB = (String)appConfig.getConfigEntry("failOver");
                if (!failoverDB.equals("disable") && SBasic.failoverPersistentStorage == null) {
                    scf.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), "servlet_jsp_0143", new Object[]{aliasName, applicationName}).toString());
                    Log.getCategory(1).logError(WebContainer.currentLocation, aliasName + " web application from " + applicationName + " applicationName uses fialover service, which currently is not available", aliasName);
                }
                scf.setFailOverEnable(failoverDB);
            }
            catch (ConfigurationException e) {
                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Cannot read from database failover property. Configuration entry is named failOver", aliasName);
            }
            InputStream altDD = null;
            try {
                altDD = appConfig.getFile("altDD__default");
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            warnings = scf.init(this.securityContext, altDD);
        }
        return scf;
    }

    public ApplicationContext createContext(String applicationName, String aliasName, Configuration appConfig, Vector warnings) throws DeploymentException {
        if (SBasic.httpServletRequestPool == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
            SBasic.httpServletRequestPool = new ObjectPool(2, 5000, 8, class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade = WebContainerHelper.class$("com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade")) : class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletRequestFacade);
            SBasic.httpServletResponsePool = new ObjectPool(2, 5000, 8, class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade = WebContainerHelper.class$("com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade")) : class$com$sap$engine$services$servlets_jsp$server$runtime$client$HttpServletResponseFacade);
        }
        if (aliasName.equals("/") || aliasName.equals("\\")) {
            return this.createDefaultContext(applicationName, aliasName, appConfig, warnings);
        }
        ApplicationContext scf = null;
        MessageBytes aliasNameBytes = new MessageBytes((aliasName = ParseUtils.convertAlias((String)aliasName)).getBytes());
        scf = (ApplicationContext)SBasic.startedWebApplications.get(aliasNameBytes);
        if (scf != null) {
            throw new WebDeploymentException(WebDeploymentException.APP_CONTEXT_ALREADY_EXISTS, new Object[]{aliasName});
        }
        scf = new ApplicationContext(applicationName, aliasName, this.httpProvider, this.monitoring);
        try {
            String failoverDB = (String)appConfig.getConfigEntry("failOver");
            if (!failoverDB.equals("disable") && SBasic.failoverPersistentStorage == null) {
                scf.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), "servlet_jsp_0143", new Object[]{aliasName, applicationName}).toString());
                Log.getCategory(1).logError(WebContainer.currentLocation, aliasName + " web application from " + applicationName + " applicationName uses fialover service, which currently is not available", aliasName);
            }
            scf.setFailOverEnable(failoverDB);
        }
        catch (ConfigurationException e) {
            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Cannot read from database failover property. Configuration entry is named failOver", aliasName);
        }
        InputStream altDD = null;
        try {
            altDD = appConfig.getFile("altDD_" + aliasName);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        warnings = scf.init(this.securityContext, altDD);
        return scf;
    }

    /*
     * Loose catch block
     */
    private void initXmls(String applicationName, String aliasName, Configuration appConfig, Vector warnings, String[] addedAliases) throws DeploymentException {
        String xmlFile = null;
        String additonalXmlFile = null;
        String tempDir = this.getDeployTempDir(applicationName);
        tempDir = aliasName.equals("/") ? tempDir + "/" + "_default" + "/" + "root" + "/" : tempDir + "/" + aliasName + "/" + "root" + "/";
        SecurityRoles[] secRoles = null;
        WebDeploymentDescriptor webDesc = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader currentThreadLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(SBasic.classLoader);
        try {
            block54: {
                IOException io3222;
                FileInputStream additonalXmlInputFile;
                FileInputStream xmlInputFile;
                InputStream altDD;
                block50: {
                    block49: {
                        block53: {
                            block52: {
                                IOException io222;
                                InputStream addGlobalWebXml;
                                block48: {
                                    InputStream globalWebXml = null;
                                    try {
                                        globalWebXml = SBasic.persistentContainer.getPersistentEntryStream("global-web.xml", true);
                                    }
                                    catch (ServiceException se) {
                                        Log.getCategory(1).logError(WebContainer.currentLocation, "Error while reading global-web.xml from DB!", (Throwable)((Object)se), aliasName);
                                    }
                                    addGlobalWebXml = null;
                                    try {
                                        addGlobalWebXml = SBasic.persistentContainer.getPersistentEntryStream("web-j2ee-engine.xml", true);
                                    }
                                    catch (ServiceException se) {
                                        Log.getCategory(1).logError(WebContainer.currentLocation, "Error while reading additional global-web.xml from DB!", (Throwable)((Object)se), aliasName);
                                    }
                                    if (globalWebXml == null) break block52;
                                    try {
                                        webDesc = this.parseXml(globalWebXml, addGlobalWebXml, aliasName, "global-web.xml", "web-j2ee-engine.xml");
                                        Object var17_17 = null;
                                        if (globalWebXml == null) break block48;
                                    }
                                    catch (Throwable throwable) {
                                        IOException io222;
                                        Object var17_18 = null;
                                        if (globalWebXml != null) {
                                            try {
                                                globalWebXml.close();
                                            }
                                            catch (IOException io222) {
                                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for global-web.xml while deploying " + aliasName + " application", aliasName);
                                            }
                                        }
                                        if (addGlobalWebXml != null) {
                                            try {
                                                addGlobalWebXml.close();
                                            }
                                            catch (IOException io222) {
                                                Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for global web-j2ee-enine.xml while deploying " + aliasName + " application", aliasName);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        globalWebXml.close();
                                    }
                                    catch (IOException io222) {
                                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for global-web.xml while deploying " + aliasName + " application", aliasName);
                                    }
                                }
                                if (addGlobalWebXml != null) {
                                    try {
                                        addGlobalWebXml.close();
                                    }
                                    catch (IOException io222) {
                                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for global web-j2ee-enine.xml while deploying " + aliasName + " application", aliasName);
                                    }
                                }
                                boolean newAlias = false;
                                int i = 0;
                                while (addedAliases != null && i < addedAliases.length) {
                                    if (addedAliases[i].equals(aliasName)) {
                                        newAlias = true;
                                        break;
                                    }
                                    ++i;
                                }
                                if (newAlias) {
                                    this.createSecurityResources(applicationName, aliasName, appConfig, webDesc, secRoles, warnings);
                                }
                                this.setResourceReferences(aliasName, webDesc);
                                break block53;
                            }
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "File global-web.xml Not Found!", aliasName);
                        }
                        xmlFile = tempDir + "WEB-INF" + File.separator + "web.xml";
                        if (!new File(xmlFile).exists()) {
                            throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{aliasName});
                        }
                        additonalXmlFile = tempDir + "WEB-INF" + File.separator + "web-j2ee-engine.xml";
                        if (!new File(additonalXmlFile).exists()) {
                            additonalXmlFile = null;
                        }
                        altDD = null;
                        xmlInputFile = null;
                        additonalXmlInputFile = null;
                        try {
                            altDD = appConfig.getFile("altDD_" + (aliasName.equals("/") ? "_default" : aliasName));
                        }
                        catch (ConfigurationException e) {
                            // empty catch block
                        }
                        if (altDD == null) {
                            xmlInputFile = new FileInputStream(xmlFile);
                            if (additonalXmlFile != null && new File(additonalXmlFile).exists()) {
                                additonalXmlInputFile = new FileInputStream(additonalXmlFile);
                            }
                            webDesc = this.parseXml(xmlInputFile, additonalXmlInputFile, aliasName, xmlFile, additonalXmlFile);
                            break block49;
                        }
                        if (additonalXmlFile != null && new File(additonalXmlFile).exists()) {
                            additonalXmlInputFile = new FileInputStream(additonalXmlFile);
                        }
                        webDesc = this.parseXml(altDD, additonalXmlInputFile, aliasName, " alternative descriptor ", additonalXmlFile);
                    }
                    Object var21_29 = null;
                    if (xmlInputFile == null) break block50;
                    try {
                        xmlInputFile.close();
                    }
                    catch (IOException io3222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while deploying " + aliasName + " application", aliasName);
                    }
                }
                if (altDD != null) {
                    try {
                        altDD.close();
                    }
                    catch (IOException io3222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for alternative descriptor while deploying " + aliasName + " application", aliasName);
                    }
                }
                if (additonalXmlInputFile != null) {
                    try {
                        additonalXmlInputFile.close();
                    }
                    catch (IOException io3222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while deploying " + aliasName + " application", aliasName);
                    }
                }
                break block54;
                {
                    catch (IOException io4) {
                        throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{aliasName});
                    }
                }
                catch (Throwable throwable) {
                    IOException io3222;
                    Object var21_30 = null;
                    if (xmlInputFile != null) {
                        try {
                            xmlInputFile.close();
                        }
                        catch (IOException io3222) {
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while deploying " + aliasName + " application", aliasName);
                        }
                    }
                    if (altDD != null) {
                        try {
                            altDD.close();
                        }
                        catch (IOException io3222) {
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for alternative descriptor while deploying " + aliasName + " application", aliasName);
                        }
                    }
                    if (additonalXmlInputFile != null) {
                        try {
                            additonalXmlInputFile.close();
                        }
                        catch (IOException io3222) {
                            Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while deploying " + aliasName + " application", aliasName);
                        }
                    }
                    throw throwable;
                }
            }
            boolean newAlias = false;
            int i = 0;
            while (addedAliases != null && i < addedAliases.length) {
                if (addedAliases[i].equals(aliasName)) {
                    newAlias = true;
                    break;
                }
                ++i;
            }
            if (newAlias) {
                this.createSecurityResources(applicationName, aliasName, appConfig, webDesc, secRoles, warnings);
            }
            this.setResourceReferences(aliasName, webDesc);
            Object var24_35 = null;
            currentThread.setContextClassLoader(currentThreadLoader);
        }
        catch (Throwable throwable) {
            Object var24_36 = null;
            currentThread.setContextClassLoader(currentThreadLoader);
            throw throwable;
        }
    }

    private WebDeploymentDescriptor parseXml(InputStream xmlFile, InputStream additonalXmlFile, String webAppName, String xmlFileName, String additonalXmlFileName) throws DeploymentException {
        Document parsed;
        StandardDOMParser parser;
        WebDeploymentDescriptor webDesc = null;
        try {
            WebDescriptorDocument doc = new WebDescriptorDocument();
            parser = new StandardDOMParser();
            if (SBasic.webContainerProperties.validateDescriptors()) {
                parser.setValidation(true);
            } else {
                parser.setValidation(false);
                parser.setReadDTD(false);
            }
            parsed = parser.parse(xmlFile);
            webDesc = doc.loadDescriptorFromDocument(parsed);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(WebContainer.currentLocation, "Parsing " + xmlFileName + " of " + webAppName + " web application in non-validation mode failed!", e, webAppName);
            throw new WebDeploymentException(WebDeploymentException.CANNOT_READ_XML_OR_ERROR_IN_XML_FOR_WEB_APPLICATION, new Object[]{xmlFileName, webAppName}, e);
        }
        if (additonalXmlFile != null) {
            try {
                AdditionalWebDescrDocument addDoc = new AdditionalWebDescrDocument();
                parser = new StandardDOMParser();
                if (SBasic.webContainerProperties.validateDescriptors()) {
                    parser.setValidation(true);
                } else {
                    parser.setValidation(false);
                    parser.setReadDTD(false);
                }
                parsed = parser.parse(additonalXmlFile);
                addDoc.loadDescriptorFromDocument(parsed, webDesc);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(WebContainer.currentLocation, "Parsing " + additonalXmlFileName + " of " + webAppName + " web application in non-validation mode failed!", e, webAppName);
                throw new WebDeploymentException(WebDeploymentException.CANNOT_READ_XML_OR_ERROR_IN_XML_FOR_WEB_APPLICATION, new Object[]{additonalXmlFileName, webAppName}, e);
            }
        }
        return webDesc;
    }

    private void createSecurityResources(String applicationName, String alias, Configuration appConfig, WebDeploymentDescriptor webDesc, SecurityRoles[] secRoles, Vector warnings) throws DeploymentException {
        int i;
        if (webDesc == null) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_LOAD_DESCRIPTOR_FOR_WEBXML_FOR_WEB_APPLICATION, new Object[]{alias});
        }
        if (alias.equals("/") || alias.equals("\\")) {
            alias = "_default";
        }
        String aliasForSecurity = alias.replace('/', '_');
        aliasForSecurity = aliasForSecurity.replace('\\', '_');
        SecurityRoles[] secRolesTemp = webDesc.getSecRoles();
        Vector<SecurityRoles> secRolesVector = new Vector<SecurityRoles>();
        if (secRoles == null) {
            if (secRolesTemp != null) {
                secRoles = secRolesTemp;
            }
        } else if (secRoles != null && secRolesTemp != null) {
            int i2 = 0;
            while (i2 < secRoles.length) {
                secRolesVector.add(secRoles[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < secRolesTemp.length) {
                if (!secRolesVector.contains(secRolesTemp[i3])) {
                    secRolesVector.add(secRolesTemp[i3]);
                }
                ++i3;
            }
            secRoles = new SecurityRoles[secRolesVector.size()];
            i = 0;
            while (i < secRolesVector.size()) {
                secRoles[i] = (SecurityRoles)secRolesVector.elementAt(i);
                ++i;
            }
        }
        SecurityContext appSecurityContext = this.initSecurityConfiguration(applicationName, alias, aliasForSecurity, appConfig, webDesc);
        SecurityRoleContext secRoleContext = appSecurityContext.getAuthorizationContext().getSecurityRoleContext();
        if (secRoles != null) {
            try {
                i = 0;
                while (i < secRoles.length) {
                    block34: {
                        String[] groups;
                        String[] users;
                        SecurityRole secRole;
                        block33: {
                            secRole = secRoleContext.getSecurityRole(secRoles[i].getRoleName());
                            if (secRole == null) {
                                if (secRoles[i].getServerRoleName() != null) {
                                    try {
                                        secRole = secRoleContext.addSecurityRoleReference(secRoles[i].getRoleName(), "SAP-J2EE-Engine", secRoles[i].getServerRoleName());
                                        break block33;
                                    }
                                    catch (OutOfMemoryError e) {
                                        throw e;
                                    }
                                    catch (ThreadDeath e) {
                                        throw e;
                                    }
                                    catch (Throwable e) {
                                        Log.getCategory(1).logError(WebContainer.currentLocation, "Error in mapping security roles", e, alias);
                                        warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.ERROR_IN_SECURITY_MAPPINGS_IN_DESCRIPTOR_IN_WEB_APPLICATION_TO_DEFAULT_SERVER_SECURITY_MAPPINGS_ERROR_IS, new Object[]{alias, e.toString()}));
                                        break block34;
                                    }
                                }
                                secRole = secRoleContext.addSecurityRole(secRoles[i].getRoleName());
                            }
                        }
                        if ((users = secRoles[i].getUserNames()) != null) {
                            int j = 0;
                            while (j < users.length) {
                                try {
                                    if (this.securityContext.getUserStoreContext().getActiveUserStore().getUserContext().getUserInfo(users[j]) == null) {
                                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Unknown user " + users[j] + ", descriped in " + secRoles[i].getRoleName() + " security role!", alias);
                                        warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNKNOWN_USER_DESCRIPED_IN_SECURITY_ROLE_IN_WEB_APPLICATION, new Object[]{users[j], secRoles[i].getRoleName(), alias}));
                                    }
                                }
                                catch (SecurityException se) {
                                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Unknown user " + users[j] + ", descriped in " + secRoles[i].getRoleName() + " security role!" + se.toString(), alias);
                                    warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNKNOWN_USER_DESCRIPED_IN_SECURITY_ROLE_IN_WEB_APPLICATION, new Object[]{users[j], secRoles[i].getRoleName(), alias}));
                                }
                                secRole.addUser(users[j]);
                                ++j;
                            }
                        }
                        if ((groups = secRoles[i].getUserGroup()) != null) {
                            int j = 0;
                            while (j < groups.length) {
                                try {
                                    if (this.securityContext.getUserStoreContext().getActiveUserStore().getGroupContext().getGroupInfo(groups[j]) == null) {
                                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Unknown group " + groups[j] + ", descriped in " + secRoles[i].getRoleName() + " security role!", alias);
                                        warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNKNOWN_GROUP_DESCRIPED_IN_SECURITY_ROLE_IN_WEB_APPLICATION, new Object[]{groups[j], secRoles[i].getRoleName(), alias}));
                                    }
                                }
                                catch (SecurityException se) {
                                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Unknown group " + groups[j] + ", descriped in " + secRoles[i].getRoleName() + " security role!" + se.toString(), alias);
                                    warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNKNOWN_GROUP_DESCRIPED_IN_SECURITY_ROLE_IN_WEB_APPLICATION, new Object[]{groups[j], secRoles[i].getRoleName(), alias}));
                                }
                                secRole.addGroup(groups[j]);
                                ++j;
                            }
                        }
                        if (this.isRoleUsedForRunAs(secRoles[i].getRoleName(), webDesc)) {
                            secRole.setRunAsAccountGenerationPolicy((byte)1);
                        }
                    }
                    ++i;
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(WebContainer.currentLocation, "Error in parsing and initializing the security roles from web.xml!", e, alias);
                throw new WebDeploymentException(WebDeploymentException.ERROR_IN_SECURITY_ROLES_OR_SECURITY_ROLE_MAPPINGS_IN_WEBXML_FOR_WEB_APPLICATION, new Object[]{alias}, e);
            }
        }
    }

    private SecurityContext initSecurityConfiguration(String applicationName, String alias, String aliasForSecurity, Configuration appConfig, WebDeploymentDescriptor webDesc) throws WebDeploymentException {
        ModificationContext securityModificationContext = this.securityContext.getModificationContext();
        Configuration subConfig = null;
        try {
            subConfig = appConfig.getSubConfiguration(aliasForSecurity.replace('/', File.separatorChar));
            if (subConfig == null) {
                subConfig = appConfig.createSubConfiguration(aliasForSecurity.replace('/', File.separatorChar));
            }
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            try {
                subConfig = appConfig.createSubConfiguration(aliasForSecurity.replace('/', File.separatorChar));
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                throw new WebDeploymentException(WebDeploymentException.CANNOT_CREATE_SECURITY_SUBCONFIGURATION_FOR_ALIAS_OF_APPLICATION, new Object[]{aliasForSecurity, applicationName}, e);
            }
        }
        SecurityContext mySecContext = securityModificationContext.beginModifications(subConfig);
        SecurityContext appSecurityContext = mySecContext.getPolicyConfigurationContext(applicationName + "*" + aliasForSecurity);
        if (appSecurityContext == null) {
            mySecContext.registerPolicyConfiguration(applicationName + "*" + aliasForSecurity);
            appSecurityContext = mySecContext.getPolicyConfigurationContext(applicationName + "*" + aliasForSecurity);
        }
        if (appSecurityContext == null) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_APPLICATION_SECURITY_CONTEXT_FOR_WEB_APPLICATION, new Object[]{alias});
        }
        if (webDesc.getLoginConfig() != null && webDesc.getLoginConfig().getAuthMethod() != null) {
            if (webDesc.getAuthentication() != null && webDesc.getAuthentication().getLoginModules() != null && webDesc.getAuthentication().getLoginModules().length > 0) {
                AppConfigurationEntry[] entries = webDesc.getAuthentication().getLoginModules();
                appSecurityContext.getAuthenticationContext().setLoginModules(entries);
            } else {
                appSecurityContext.getAuthenticationContext().setLoginModules(webDesc.getLoginConfig().getAuthMethod().toLowerCase());
            }
            appSecurityContext.getAuthenticationContext().setProperty("auth_method", webDesc.getLoginConfig().getAuthMethod().toLowerCase());
            String policyDomain = webDesc.getSecurityPolicyDomain();
            if (policyDomain == null || policyDomain.length() == 0) {
                policyDomain = "/" + alias;
            }
            appSecurityContext.getAuthenticationContext().setProperty("policy_domain", policyDomain);
            if (webDesc.getLoginConfig().getRealmName() != null) {
                appSecurityContext.getAuthenticationContext().setProperty("realm_name", webDesc.getLoginConfig().getRealmName());
            }
        }
        return appSecurityContext;
    }

    private void removeSecurityResources(String applicationName, String alias) {
        if (alias.equals("/") || alias.equals("\\")) {
            alias = "_default";
        }
        String aliasForSecurity = alias.replace('/', '_');
        aliasForSecurity = aliasForSecurity.replace('\\', '_');
        this.securityContext.unregisterPolicyConfiguration(applicationName + "*" + aliasForSecurity);
    }

    private void setResourceReferences(String aliasName, WebDeploymentDescriptor webDesc) {
        Properties resourceReferences = null;
        resourceReferences = ActionBase.mapAliasResourceRef.get(aliasName) != null ? (Properties)ActionBase.mapAliasResourceRef.get(aliasName) : new Properties();
        ResourceReference[] resources = webDesc.getResReferences();
        if (resources != null) {
            int k = 0;
            while (k < resources.length) {
                String resourceType = resources[k].getResourceType();
                String resourceName = resources[k].getResourceLink();
                if (resourceName == null) {
                    resourceName = resources[k].getResourceName();
                }
                if (!resourceType.equals("javax.mail.Session") && !resourceType.equals("java.net.URL")) {
                    resourceReferences.setProperty(resourceName, resourceType);
                }
                ++k;
            }
        }
        ActionBase.mapAliasResourceRef.put(aliasName, resourceReferences);
    }

    private boolean isRoleUsedForRunAs(String roleName, WebDeploymentDescriptor webDesc) {
        ServletDescriptor[] servletDesc = webDesc.getServlets();
        if (servletDesc == null) {
            return false;
        }
        int i = 0;
        while (i < servletDesc.length) {
            if (servletDesc[i].getRunAs() != null && roleName.equals(servletDesc[i].getRunAs().getSecurityRoleName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private NodeList merge(Document target, NodeList source, String keyNode, String tagName) {
        NodeList targetNodeList = target.getElementsByTagName(keyNode);
        if (targetNodeList.getLength() == 0) {
            return source;
        }
        int i = 0;
        while (i < source.getLength()) {
            if (source.item(i).getNodeType() == 1 && !this.isContainNode(targetNodeList, source.item(i), tagName)) {
                Element root = target.getDocumentElement();
                Element e = this.createElement(source.item(i), keyNode, target);
                if (e != null) {
                    root.appendChild(e);
                }
            }
            ++i;
        }
        targetNodeList = target.getElementsByTagName(keyNode);
        return targetNodeList;
    }

    private Element createElement(Node node, String keyNode, Document mainDocument) {
        Element resultElement = null;
        if (keyNode.equals("security-role") || keyNode.equals("security-role-map")) {
            resultElement = mainDocument.createElement(keyNode);
            NodeList childList = node.getChildNodes();
            Node idNode = null;
            int i = 0;
            while (i < childList.getLength()) {
                idNode = childList.item(i);
                short nodeType = idNode.getNodeType();
                if (nodeType == 1) {
                    String tagName = ((Element)idNode).getTagName();
                    String tagValue = idNode.getFirstChild().getNodeValue();
                    Element nextElement = mainDocument.createElement(tagName);
                    Text textNode = mainDocument.createTextNode(tagValue);
                    nextElement.appendChild(textNode);
                    resultElement.appendChild(nextElement);
                }
                ++i;
            }
        }
        return resultElement;
    }

    private boolean isContainNode(NodeList targetNodeList, Node item, String tagName) {
        boolean result = false;
        NodeList childList = ((Element)item).getElementsByTagName(tagName);
        Node idNode = childList.item(0);
        String tagValue = idNode.getFirstChild().getNodeValue();
        int i = 0;
        while (i < targetNodeList.getLength()) {
            childList = ((Element)targetNodeList.item(i)).getElementsByTagName(tagName);
            idNode = childList.item(0);
            String itemTagValue = idNode.getFirstChild().getNodeValue();
            if (tagValue.equals(itemTagValue)) {
                return true;
            }
            ++i;
        }
        return result;
    }

    public Vector getRemovedResourceReferences(String applicationName, File[] archiveFiles, ContainerDeploymentInfo dInfo) throws DeploymentException {
        Vector<Properties> result = new Vector<Properties>();
        Configuration appConfig = dInfo.getConfiguration();
        String[] oldAliases = SBasic.deployCommunicator.getAliases(applicationName);
        if (oldAliases == null || oldAliases.length == 0) {
            return null;
        }
        int i = 0;
        while (i < oldAliases.length) {
            String oldAlias = oldAliases[i];
            boolean aliasDeleted = true;
            File war = null;
            int j = 0;
            while (j < archiveFiles.length) {
                String newAlias = SBasic.deployCommunicator.getAlias(archiveFiles[j].getName(), applicationName);
                if (oldAlias.equals(newAlias)) {
                    aliasDeleted = false;
                    war = archiveFiles[j];
                    break;
                }
                ++j;
            }
            if (aliasDeleted) {
                Properties props = this.getAllResourceRefereces(oldAlias, applicationName, appConfig);
                if (props != null && !((Hashtable)props).isEmpty()) {
                    result.add(props);
                }
            } else {
                Properties oldResourceReferences = this.getAllResourceRefereces(oldAlias, applicationName, appConfig);
                if (oldResourceReferences != null && !((Hashtable)oldResourceReferences).isEmpty()) {
                    Properties newResourceReferences = this.getAllResourceReferecesFromWar(oldAlias, applicationName, war, dInfo);
                    if (newResourceReferences != null && !((Hashtable)newResourceReferences).isEmpty()) {
                        Properties props = new Properties();
                        Enumeration enumeration = ((Hashtable)oldResourceReferences).keys();
                        while (enumeration.hasMoreElements()) {
                            String resourceName = (String)enumeration.nextElement();
                            if (newResourceReferences.getProperty(resourceName) != null) continue;
                            props.setProperty(resourceName, oldResourceReferences.getProperty(resourceName));
                        }
                        result.add(props);
                    } else {
                        result.add(oldResourceReferences);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private Properties getAllResourceRefereces(String alias, String applicationName, Configuration appConfig) throws DeploymentException {
        WebDeploymentDescriptor webDesc;
        ClassLoader currentThreadLoader;
        Thread currentThread;
        Properties result;
        block31: {
            IOException io2222;
            FileInputStream additionalXmlInputFile;
            FileInputStream xmlInputFile;
            InputStream altDD;
            block29: {
                block28: {
                    result = new Properties();
                    String aliasDir = this.getAliasDir(alias);
                    String webInfDir = this.getDeployTempDir(applicationName) + File.separator + aliasDir + File.separator + "root" + File.separator + "WEB-INF" + File.separator;
                    String xmlFile = webInfDir + "web.xml";
                    if (!new File(xmlFile).exists()) {
                        throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                    }
                    String additionalXmlFile = webInfDir + "web-j2ee-engine.xml";
                    if (!new File(additionalXmlFile).exists()) {
                        additionalXmlFile = null;
                    }
                    currentThread = Thread.currentThread();
                    currentThreadLoader = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(SBasic.classLoader);
                    webDesc = null;
                    altDD = null;
                    xmlInputFile = null;
                    additionalXmlInputFile = null;
                    try {
                        altDD = appConfig.getFile("altDD_" + (alias.equals("/") ? "_default" : alias));
                    }
                    catch (ConfigurationException e) {
                        // empty catch block
                    }
                    if (additionalXmlFile != null && new File(additionalXmlFile).exists()) {
                        additionalXmlInputFile = new FileInputStream(additionalXmlFile);
                    }
                    if (altDD == null) {
                        xmlInputFile = new FileInputStream(xmlFile);
                        webDesc = this.parseXml(xmlInputFile, additionalXmlInputFile, alias, xmlFile, additionalXmlFile);
                        break block28;
                    }
                    webDesc = this.parseXml(altDD, additionalXmlInputFile, alias, " alternative descriptor ", additionalXmlFile);
                }
                Object var17_18 = null;
                if (xmlInputFile == null) break block29;
                try {
                    xmlInputFile.close();
                }
                catch (IOException io2222) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while updating " + alias + " application", alias);
                }
            }
            if (altDD != null) {
                try {
                    altDD.close();
                }
                catch (IOException io2222) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for alternative descriptor while updating " + alias + " application", alias);
                }
            }
            if (additionalXmlInputFile != null) {
                try {
                    additionalXmlInputFile.close();
                    break block31;
                }
                catch (IOException io2222) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while updating " + alias + " application", alias);
                }
                {
                }
            }
            break block31;
            {
                catch (IOException io3) {
                    throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                }
            }
            catch (Throwable throwable) {
                IOException io2222;
                Object var17_19 = null;
                if (xmlInputFile != null) {
                    try {
                        xmlInputFile.close();
                    }
                    catch (IOException io2222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while updating " + alias + " application", alias);
                    }
                }
                if (altDD != null) {
                    try {
                        altDD.close();
                    }
                    catch (IOException io2222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for alternative descriptor while updating " + alias + " application", alias);
                    }
                }
                if (additionalXmlInputFile != null) {
                    try {
                        additionalXmlInputFile.close();
                    }
                    catch (IOException io2222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while updating " + alias + " application", alias);
                    }
                }
                currentThread.setContextClassLoader(currentThreadLoader);
                throw throwable;
            }
        }
        currentThread.setContextClassLoader(currentThreadLoader);
        ResourceReference[] resources = webDesc.getResReferences();
        if (resources != null) {
            int k = 0;
            while (k < resources.length) {
                String resourceType = resources[k].getResourceType();
                String resourceName = resources[k].getResourceLink();
                if (resourceName == null) {
                    resourceName = resources[k].getResourceName();
                }
                if (!resourceType.equals("javax.mail.Session") && !resourceType.equals("java.net.URL")) {
                    result.setProperty(resourceName, resourceType);
                }
                ++k;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private Properties getAllResourceReferecesFromWar(String alias, String applicationName, File war, ContainerDeploymentInfo dInfo) throws DeploymentException {
        WebDeploymentDescriptor webDesc;
        ClassLoader currentThreadLoader;
        Thread currentThread;
        Properties result;
        block38: {
            IOException io2222;
            ZipFile file;
            InputStream additionalXmlInputFile;
            InputStream xmlInputFile;
            InputStream altDD;
            block35: {
                block34: {
                    result = new Properties();
                    ClassLoader loader = dInfo.getLoader();
                    altDD = null;
                    J2EEModule[] modules = dInfo.getEarDescriptor().getWEBs();
                    if (modules != null) {
                        int i = 0;
                        while (i < modules.length) {
                            String altDDName;
                            if (modules[i].getContextRoot().equals(alias) && (altDDName = modules[i].getAlt_dd()) != null && !altDDName.trim().equals("") && (altDD = loader.getResourceAsStream(altDDName)) == null) {
                                Log.getCategory(1).logError(WebContainer.currentLocation, "Alternative descriptor " + altDDName + " not found!", "");
                                throw new WebDeploymentException(WebDeploymentException.ALTERNATIVE_DESCRIPTOR_NOT_FOUND, new Object[]{altDDName, applicationName});
                            }
                            ++i;
                        }
                    }
                    currentThread = Thread.currentThread();
                    currentThreadLoader = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(SBasic.classLoader);
                    webDesc = null;
                    xmlInputFile = null;
                    additionalXmlInputFile = null;
                    file = null;
                    file = new ZipFile(war);
                    ZipEntry entry = file.getEntry("WEB-INF/web-j2ee-engine.xml");
                    if (entry == null) {
                        entry = file.getEntry("web-inf/web-j2ee-engine.xml");
                    }
                    if (entry != null) {
                        additionalXmlInputFile = file.getInputStream(entry);
                    }
                    if (altDD == null) {
                        ZipEntry entry1 = file.getEntry("WEB-INF/web.xml");
                        if (entry1 == null && (entry1 = file.getEntry("web-inf/web.xml")) == null) {
                            throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                        }
                        xmlInputFile = file.getInputStream(entry1);
                        webDesc = this.parseXml(xmlInputFile, additionalXmlInputFile, alias, "web.xml", "web-j2ee-engine.xml");
                        break block34;
                    }
                    webDesc = this.parseXml(altDD, additionalXmlInputFile, alias, " alternative descriptor ", "web-j2ee-engine.xml");
                }
                Object var18_20 = null;
                if (file == null) break block35;
                try {
                    file.close();
                }
                catch (IOException e) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing ZipFile for " + war.getName() + " while updating " + alias + " application", alias);
                }
            }
            if (xmlInputFile != null) {
                try {
                    xmlInputFile.close();
                }
                catch (IOException io2222) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while updating " + alias + " application", alias);
                }
            }
            if (altDD != null) {
                try {
                    altDD.close();
                }
                catch (IOException io2222) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for alternative descriptor while updating " + alias + " application", alias);
                }
            }
            if (additionalXmlInputFile != null) {
                try {
                    additionalXmlInputFile.close();
                    break block38;
                }
                catch (IOException io2222) {
                    Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while updating " + alias + " application", alias);
                }
                {
                }
            }
            break block38;
            {
                catch (IOException io3) {
                    throw new WebDeploymentException(WebDeploymentException.THE_ARCHIVE_FOR_WEB_APPLICATION_DOES_NOT_CONTAIN_WEBINF_WEBXML_FILE_OR_IT_IS_SPELT_INCORRECTLY, new Object[]{alias});
                }
            }
            catch (Throwable throwable) {
                IOException io2222;
                Object var18_21 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing ZipFile for " + war.getName() + " while updating " + alias + " application", alias);
                    }
                }
                if (xmlInputFile != null) {
                    try {
                        xmlInputFile.close();
                    }
                    catch (IOException io2222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web.xml while updating " + alias + " application", alias);
                    }
                }
                if (altDD != null) {
                    try {
                        altDD.close();
                    }
                    catch (IOException io2222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for alternative descriptor while updating " + alias + " application", alias);
                    }
                }
                if (additionalXmlInputFile != null) {
                    try {
                        additionalXmlInputFile.close();
                    }
                    catch (IOException io2222) {
                        Log.getCategory(1).logWarning(WebContainer.currentLocation, "Error while closing InputStream for web-j2ee-engine.xml while updating " + alias + " application", alias);
                    }
                }
                currentThread.setContextClassLoader(currentThreadLoader);
                throw throwable;
            }
        }
        currentThread.setContextClassLoader(currentThreadLoader);
        ResourceReference[] resources = webDesc.getResReferences();
        if (resources != null) {
            int k = 0;
            while (k < resources.length) {
                String resourceType = resources[k].getResourceType();
                String resourceName = resources[k].getResourceLink();
                if (resourceName == null) {
                    resourceName = resources[k].getResourceName();
                }
                if (!resourceType.equals("javax.mail.Session") && !resourceType.equals("java.net.URL")) {
                    result.setProperty(resourceName, resourceType);
                }
                ++k;
            }
        }
        return result;
    }

    private String getAliasDir(String alias) {
        if ((alias = ParseUtils.convertAlias((String)alias)).equals("/")) {
            return "_default";
        }
        return alias.replace('/', '/').replace('\\', '/');
    }

    private String getDeployTempDir(String applicationName) {
        String tempDir = null;
        try {
            tempDir = SBasic.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(WebContainer.currentLocation, "Can't get working directory. ", e, applicationName);
            tempDir = SBasic.tempDir;
        }
        return tempDir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

