/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.deploy.DeployCallback;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressEvent;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.WebMonitoring;
import com.sap.engine.services.servlets_jsp.server.container.AppInfoAction;
import com.sap.engine.services.servlets_jsp.server.container.ContainerInfoAction;
import com.sap.engine.services.servlets_jsp.server.container.DeployAction;
import com.sap.engine.services.servlets_jsp.server.container.RemoveAction;
import com.sap.engine.services.servlets_jsp.server.container.RuntimeChangesAction;
import com.sap.engine.services.servlets_jsp.server.container.SingleFileUpdateAction;
import com.sap.engine.services.servlets_jsp.server.container.StartAction;
import com.sap.engine.services.servlets_jsp.server.container.StopAction;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebContainerServiceException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class WebContainer
implements ContainerInterface,
DeployCallback {
    private static final int APP_PRIORITY = 75;
    private ContainerInfoAction containerInfoApplication = null;
    private DeployAction deployApplication = null;
    private RemoveAction removeApplication = null;
    private SingleFileUpdateAction singleFileUpdateApplication = null;
    private StartAction startApplication = null;
    private StopAction stopApplication = null;
    private RuntimeChangesAction runtimeChangesApplication = null;
    private AppInfoAction appInfoApplication = null;
    private ContainerInfo containerInfo = new ContainerInfo();
    private ArrayObject startedApplications = new ArrayObject();
    private WebContainerHelper servletsAndJsp = null;
    protected static Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$container$WebContainer == null ? (class$com$sap$engine$services$servlets_jsp$server$container$WebContainer = WebContainer.class$("com.sap.engine.services.servlets_jsp.server.container.WebContainer")) : class$com$sap$engine$services$servlets_jsp$server$container$WebContainer));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$container$WebContainer;

    public WebContainer(String serviceName) {
        this.containerInfo.setName("servlet_jsp");
        this.containerInfo.setModuleName(null);
        this.containerInfo.setJ2EEModuleName("web");
        this.containerInfo.setJ2EEContainer(true);
        this.containerInfo.setFileExtensions(new String[]{".war"});
        this.containerInfo.setFileNames(null);
        this.containerInfo.setServiceName(serviceName);
        this.containerInfo.setSupportingSingleFileUpdate(true);
        this.containerInfo.setPriority(75);
    }

    public void initialize(ServletAndJspRuntimeInterface runtimeInterface, HttpProvider httpProvider, SecurityContext securityContext, ConfigurationHandlerFactory configurationFactory, WebMonitoring monitoring) throws WebContainerServiceException {
        this.servletsAndJsp = new WebContainerHelper(securityContext, monitoring);
        this.servletsAndJsp.setHttp(httpProvider);
        this.containerInfoApplication = new ContainerInfoAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.deployApplication = new DeployAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.removeApplication = new RemoveAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.singleFileUpdateApplication = new SingleFileUpdateAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.startApplication = new StartAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.stopApplication = new StopAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.runtimeChangesApplication = new RuntimeChangesAction(this.containerInfo, this.servletsAndJsp, runtimeInterface);
        this.appInfoApplication = new AppInfoAction(this.containerInfo, this.servletsAndJsp, runtimeInterface, configurationFactory);
    }

    public void setHttp(HttpProvider httpRuntimeInterface) {
        this.servletsAndJsp.setHttp(httpRuntimeInterface);
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("Prepare deploy of application " + applicationName + " begin on web container", "");
    }

    public ApplicationDeployInfo deploy(File[] archiveFilesFromDeploy, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Log.getLocation(3).traceInfo("Deploy of application " + dInfo.getApplicationName() + " begin on web container", "");
        return this.deployApplication.deploy(archiveFilesFromDeploy, dInfo, props, this.deployApplication.getAliases(dInfo.getApplicationName(), props));
    }

    public void commitDeploy(String applicationName) throws WarningException {
        Log.getLocation(3).traceInfo("Commit deploy of application " + applicationName + " begin on web container", "");
        this.deployApplication.commitDeploy(applicationName);
        Log.getCategory(1).logInfo(currentLocation, "Deploy of application [" + applicationName + "] finished successfully in web container.", "");
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        Log.getLocation(3).traceInfo("Rollback deploy of application " + applicationName + " begin on web container", "");
        if (applicationName != null && !applicationName.equals("")) {
            try {
                this.remove(applicationName);
            }
            catch (DeploymentException de) {
                Log.getCategory(1).logWarning(currentLocation, "Cannot remove j2ee application [" + applicationName + "] during deploy rollback", (Throwable)((Object)de), applicationName);
                throw new WebWarningException(WebWarningException.CANNOT_REMOVE_APPLICATION_DURING_DEPLOY_ROLLBACK, new Object[]{applicationName}, (Throwable)((Object)de));
            }
        }
        Log.getCategory(1).logInfo(currentLocation, "Deploy of application [" + applicationName + "] rolled back successfully in web container.", "");
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
        Log.getLocation(3).traceInfo("notifyDeployedComponents() starts for application " + applicationName + " on web container", "");
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("Remove of application " + applicationName + " begin on web container", "");
        this.removeApplication.remove(applicationName, false);
        Log.getCategory(1).logInfo(currentLocation, "Remove of application [" + applicationName + "] finished successfully in web container.", "");
    }

    public File[] getClientJar(String appName) {
        return null;
    }

    public void dump(Properties props) {
        Enumeration en = ((Hashtable)props).keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object el = ((Hashtable)props).get(key);
            if (el instanceof String[]) {
                String[] array = (String[])el;
                String value = "";
                int i = 0;
                while (i < array.length) {
                    value = value + array[i] + ", ";
                    ++i;
                }
                System.out.println(key + "  =  " + value);
                continue;
            }
            System.out.println(key + "  =  " + el);
        }
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("needUpdate() of application begin on web container", "");
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("needStopOnUpdate() of application begin on web container", "");
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Log.getLocation(3).traceInfo("makeUpdate() of application begin on web container", "");
        String applicationName = dInfo.getApplicationName();
        Configuration appConfig = dInfo.getConfiguration();
        WarningException downloadFilesWarning = null;
        try {
            this.downloadApplicationFiles(applicationName, appConfig);
        }
        catch (WebDeploymentException e) {
        }
        catch (WarningException e) {
            downloadFilesWarning = e;
        }
        this.servletsAndJsp.updateSecurity(applicationName, archiveFiles, appConfig);
        Vector removedResources = this.servletsAndJsp.getRemovedResourceReferences(applicationName, archiveFiles, dInfo);
        WarningException we = null;
        try {
            this.removeApplication.remove(dInfo.getApplicationName(), true);
        }
        catch (WarningException _we) {
            we = _we;
        }
        try {
            appConfig.deleteConfiguration("servlet_jsp");
        }
        catch (ConfigurationException cex) {
            Log.getCategory(1).logWarning(currentLocation, "Cannot delete the configuration for application [" + applicationName + "", (Throwable)((Object)cex), applicationName);
        }
        String[] oldAliases = SBasic.deployCommunicator.getAliases(applicationName);
        String[] newAliases = this.deployApplication.getAliases(dInfo.getApplicationName(), props);
        int i = 0;
        while (oldAliases != null && i < oldAliases.length) {
            boolean aliasDeleted = true;
            int j = 0;
            while (newAliases != null && j < newAliases.length) {
                if (newAliases[j].equals(oldAliases[i])) {
                    aliasDeleted = false;
                    break;
                }
                ++j;
            }
            if (aliasDeleted) {
                try {
                    appConfig.deleteConfiguration(oldAliases[i]);
                }
                catch (ConfigurationException cex) {
                    Log.getCategory(1).logWarning(currentLocation, "Cannot delete the configuration for application [" + applicationName + "", (Throwable)((Object)cex), applicationName);
                }
            }
            ++i;
        }
        String[] addedAliases = null;
        int i2 = 0;
        while (newAliases != null && i2 < newAliases.length) {
            boolean aliasAdded = true;
            int j = 0;
            while (oldAliases != null && j < oldAliases.length) {
                if (oldAliases[j].equals(newAliases[i2])) {
                    aliasAdded = false;
                    break;
                }
                ++j;
            }
            if (aliasAdded) {
                addedAliases = this.add(addedAliases, newAliases[i2]);
            }
            ++i2;
        }
        try {
            String path = SBasic.deployCommunicator.getMyWorkDirectory(applicationName);
            this.deleteDirectory(new File(path));
        }
        catch (IOException e) {
            Log.getCategory(1).logWarning(currentLocation, "Cannot delete the working directory for application [" + applicationName + "] during update!", e, applicationName);
        }
        ApplicationDeployInfo appDeployInfo = this.deployApplication.deploy(archiveFiles, dInfo, props, addedAliases);
        if (we != null) {
            appDeployInfo.addWarnings(we.getWarnings());
        }
        if (downloadFilesWarning != null) {
            appDeployInfo.addWarnings(downloadFilesWarning.getWarnings());
        }
        if (removedResources != null && removedResources.size() > 0) {
            int i3 = 0;
            while (i3 < removedResources.size()) {
                Properties resourceRefs = (Properties)removedResources.get(i3);
                Enumeration enumeration = ((Hashtable)resourceRefs).keys();
                while (enumeration.hasMoreElements()) {
                    String resourceName = (String)enumeration.nextElement();
                    String resourceType = resourceRefs.getProperty(resourceName);
                    appDeployInfo.addRemovedResourceReference(resourceName, resourceType);
                }
                ++i3;
            }
        }
        return appDeployInfo;
    }

    private void deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteDirectory(files[i]);
                ++i;
            }
            directory.delete();
        } else {
            directory.delete();
        }
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties properties) throws WarningException {
        Log.getLocation(3).traceInfo("notifyUpdatedComponents() of application " + applicationName + " begin on web container", "");
        try {
            String path = SBasic.deployCommunicator.getMyWorkDirectory(applicationName);
            this.deleteDirectory(new File(path));
        }
        catch (Exception e) {
            Log.getCategory(1).logError(currentLocation, "Cannot delete the working directory for application [" + applicationName + "] during update!", e, applicationName);
        }
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("Prepare update of application " + applicationName + " begin on web container", "");
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) {
        Log.getLocation(3).traceInfo("Commit update of application " + applicationName + " begin on web container", "");
        Log.getCategory(1).logInfo(currentLocation, "Update of application [" + applicationName + "] finished successfully in web container.", "");
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        try {
            this.deployApplication.commitDeploy(applicationName);
        }
        catch (Exception e) {
            Log.getCategory(1).logError(currentLocation, "Cannot commit application update.", e, applicationName);
            result.addWarning(e.getMessage());
        }
        return result;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
        Log.getLocation(3).traceInfo("Rollback update of application " + applicationName + " begin on web container", "");
        try {
            this.removeApplication.remove(applicationName, true);
        }
        catch (Exception we) {
            Log.getCategory(1).logError(currentLocation, "Cannot remove application [" + applicationName + "] during update rollback!", we, applicationName);
        }
        try {
            String path = SBasic.deployCommunicator.getMyWorkDirectory(applicationName);
            this.deleteDirectory(new File(path));
        }
        catch (Exception e) {
            Log.getCategory(1).logWarning(currentLocation, "Cannot delete the working directory for application [" + applicationName + "] during update!", e, applicationName);
        }
        try {
            this.containerInfoApplication.downloadApplicationFiles(applicationName, applicationConfig);
        }
        catch (Exception we) {
            Log.getCategory(1).logError(currentLocation, "Cannot synchronize application [" + applicationName + "] during update rollback!", we, applicationName);
        }
        try {
            this.deployApplication.commitDeploy(applicationName);
        }
        catch (Exception e) {
            Log.getCategory(1).logError(currentLocation, "Cannot commit application update.", e, applicationName);
        }
        Log.getCategory(1).logInfo(currentLocation, "Update of application [" + applicationName + "] rolled back successfully in web container.", "");
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return this.containerInfoApplication.getCurrentStatus(applicationName);
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        this.containerInfoApplication.downloadApplicationFiles(applicationName, appConfig);
    }

    public void prepareStart(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("Prepare start of application " + applicationName + " begin on web container", "");
        this.startApplication.prepareStart(applicationName, appConfig);
    }

    public void commitStart(String applicationName) throws WarningException {
        Log.getLocation(3).traceInfo("Commit start of application " + applicationName + " begin on Web Container", "");
        this.startApplication.commitStart(applicationName);
        Log.getCategory(1).logInfo(currentLocation, "Start of application [" + applicationName + "] finished successfully in web container.", "");
    }

    public void rollbackStart(String applicationName) throws WarningException {
        Log.getLocation(3).traceInfo("Rollback start of application " + applicationName + " begin on web container", "");
        this.commitStop(applicationName);
        Log.getCategory(1).logInfo(currentLocation, "Start of application [" + applicationName + "] rolled back successfully in web container.", "");
    }

    public void prepareStop(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        Log.getLocation(3).traceInfo("Prepare stop of application " + applicationName + " begin on web container", "");
    }

    public void commitStop(String applicationName) throws WarningException {
        Log.getLocation(3).traceInfo("Commit stop of application " + applicationName + " begin on web container", "");
        this.stopApplication.commitStop(applicationName);
        Log.getCategory(1).logInfo(currentLocation, "Stop of application [" + applicationName + "] finished successfully in web container.", "");
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
        this.runtimeChangesApplication.notifyRuntimeChanges(applicationName, appConfig);
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        return this.runtimeChangesApplication.commitRuntimeChanges(applicationName);
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return this.singleFileUpdateApplication.needStopOnSingleFileUpdate(files, dInfo, props);
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return this.singleFileUpdateApplication.makeSingleFileUpdate(files, dInfo, props);
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
        this.singleFileUpdateApplication.notifySingleFileUpdate(applicationName, config, props);
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return this.singleFileUpdateApplication.commitSingleFileUpdate(applicationName);
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
        this.singleFileUpdateApplication.rollbackSingleFileUpdate(applicationName, config);
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        throw new WebDeploymentException(WebDeploymentException.NO_SUPPORT);
    }

    public void applicationStatusChanged(String applicationName, byte status) {
        switch (status) {
            case 1: {
                if (!this.sendAppStarted(applicationName)) break;
                this.startedApplications.add(applicationName);
                break;
            }
            case 0: {
                if (!this.sendAppStopped(applicationName)) break;
                this.startedApplications.remove(applicationName);
                break;
            }
            case 6: {
                if (!this.sendAppStopped(applicationName)) break;
                this.startedApplications.remove(applicationName);
            }
        }
    }

    private boolean sendAppStarted(String applicationName) {
        try {
            String[] aliases = SBasic.deployCommunicator.getAliases(applicationName);
            if (aliases.length == 0) {
                return false;
            }
            HttpProvider httpProvider = this.servletsAndJsp.getHttpProvider();
            if (httpProvider != null) {
                httpProvider.changeLoadBalance(applicationName, aliases, true);
            }
        }
        catch (DeploymentException de) {
            Log.getCategory(1).logError(currentLocation, "Can't start load balancing for the application.", (Throwable)((Object)de), applicationName);
            return false;
        }
        return true;
    }

    private boolean sendAppStopped(String applicationName) {
        try {
            String[] aliases = SBasic.deployCommunicator.getAliases(applicationName);
            if (aliases.length == 0) {
                return false;
            }
            HttpProvider httpProvider = this.servletsAndJsp.getHttpProvider();
            if (httpProvider == null) {
                Log.getCategory(1).logWarning(currentLocation, "HTTP service is stopped and cannot stop load balancing for the application!", applicationName);
                return false;
            }
            httpProvider.changeLoadBalance(applicationName, aliases, false);
        }
        catch (DeploymentException de) {
            Log.getCategory(1).logError(currentLocation, "Can't stop load balancing for the application.", (Throwable)((Object)de), applicationName);
            return false;
        }
        return true;
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return this.containerInfoApplication.getResourcesForTempLoader(applicationName);
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return this.appInfoApplication.acceptedAppInfoChange(appName, addAppInfo);
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return true;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
        this.appInfoApplication.makeAppInfoChange(appName, addAppInfo, configuration);
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    public void processApplicationEvent(DeployEvent event) {
        HttpProvider httpProvider;
        if ((event.getAction() == 3 && event.getActionType() == 13 || event.getAction() == 3 && event.getActionType() == 9 && "servlet_jsp".equals(event.whoCausedGroupOperation())) && (httpProvider = this.servletsAndJsp.getHttpProvider()) != null) {
            httpProvider.allApplicationsStarted();
        }
    }

    public void processServiceEvent(DeployEvent event) {
    }

    public void processLibraryEvent(DeployEvent event) {
    }

    public void processInterfaceEvent(DeployEvent event) {
    }

    public void processContainerEvent(ProgressEvent event) {
    }

    public void processReferenceEvent(DeployEvent event) {
    }

    public void processStandaloneModuleEvent(DeployEvent event) {
    }

    public void callbackLost(String s) {
    }

    public void serverAdded(String s) {
    }

    private String[] add(String[] old, String newStr) {
        if (old == null) {
            return new String[]{newStr};
        }
        String[] res = new String[old.length + 1];
        System.arraycopy(old, 0, res, 0, old.length);
        res[old.length] = newStr;
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

