/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.JarComparator;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainer;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebFileNotFoundException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UpdateAction
extends ActionBase {
    private static final String CHANGED_FILES = "ChangedFiles";
    private static final String REMOVED_FILES = "RemovedFiles";
    private static final String NEW_FILES = "NewFiles";
    private static final String CHANGED_ARCHIVES = "changedArchives";
    private static final String NEW_ARCHIVES = "newArchives";
    private static final String REMOVED_ARCHIVES = "removedArchives";

    public UpdateAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Vector<String> removedArchives = new Vector<String>();
        Vector<String> newArchives = new Vector<String>();
        Vector<String> changedArchives = new Vector<String>();
        Configuration appConfig = dInfo.getConfiguration();
        Configuration servlet_jspConfig = null;
        this.extractBeforeUpdate(dInfo.getApplicationName());
        Iterator iter = null;
        try {
            servlet_jspConfig = appConfig.getSubConfiguration(this.containerInfo.getName());
            Map fileEntries = servlet_jspConfig.getAllFileEntries();
            if (fileEntries.isEmpty()) {
                return true;
            }
            iter = fileEntries.keySet().iterator();
        }
        catch (ConfigurationException ce) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Exception occured while getting servlet_jsp subconfiguration of application " + dInfo.getApplicationName() + ".", (Throwable)((Object)ce), "");
            throw new WebDeploymentException(WebDeploymentException.EXCEPTION_OCCURED_WHILE_GETTING_SERVLET_JSP_SUBCONFIGURATION_OF_APPLICATION, new Object[]{dInfo.getApplicationName()}, (Throwable)((Object)ce));
        }
        Vector<String> warsFromDB = new Vector<String>();
        while (iter.hasNext()) {
            String alias;
            String warName = (String)iter.next();
            boolean isRemoveArchive = true;
            byte[] crcDBFile = null;
            try {
                crcDBFile = (byte[])servlet_jspConfig.getConfigEntry(warName);
            }
            catch (ConfigurationException confEx) {
                Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot get configuration entrys for archives.", (Throwable)((Object)confEx), "");
                throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_CONFIGURATION_ENTRIES_FOR_ARCHIVES_OF_APPLICATION, new Object[]{dInfo.getApplicationName()}, (Throwable)((Object)confEx));
            }
            warsFromDB.add(warName);
            int j = 0;
            while (j < archiveFiles.length) {
                alias = this.getAlias(dInfo.getApplicationName(), props, warName);
                if (warName.equals(archiveFiles[j].getName())) {
                    try {
                        byte[] crcHDDFile = HashUtils.generateFileHash(archiveFiles[j]);
                        if (!ByteArrayUtils.equalsBytes((byte[])crcHDDFile, (byte[])crcDBFile)) {
                            changedArchives.add(archiveFiles[j].getName());
                            String aliasDir = alias.equals("/") || alias.equals("\\") ? "_default" : alias;
                            JarComparator moduleComparator = new JarComparator(new ZipFile(archiveFiles[j]), new ZipFile(this.getDeployTempDir(dInfo.getApplicationName()) + File.separator + aliasDir + File.separator + archiveFiles[j].getName()));
                            String[] changedFiles = moduleComparator.getChangedEntries();
                            String[] newFiles = moduleComparator.getNewEntries();
                            String[] removedFiles = moduleComparator.getDeletedEntries();
                            if (newFiles != null && newFiles.length != 0) {
                                ((Hashtable)props).put(alias + NEW_FILES, newFiles);
                            }
                            if (changedFiles != null && changedFiles.length != 0) {
                                ((Hashtable)props).put(alias + CHANGED_FILES, changedFiles);
                            }
                            if (removedFiles != null && removedFiles.length != 0) {
                                ((Hashtable)props).put(alias + REMOVED_FILES, removedFiles);
                            }
                        }
                        isRemoveArchive = false;
                    }
                    catch (IOException ioe) {
                        throw new WebDeploymentException(WebDeploymentException.CANNOT_COMPARE_ARCHIVE_FROM_ORIGINAL_AND_UPDATEING_EAR_OF_THE_APPLCATION, new Object[]{archiveFiles[j].getName(), dInfo.getApplicationName()}, ioe);
                    }
                }
                ++j;
            }
            if (!isRemoveArchive) continue;
            alias = SBasic.deployCommunicator.getAlias(warName, dInfo.getApplicationName());
            removedArchives.add(alias);
        }
        int j = 0;
        while (j < archiveFiles.length) {
            boolean isFind = false;
            int i = 0;
            while (i < warsFromDB.size()) {
                if (warsFromDB.elementAt(i).equals(archiveFiles[j].getName())) {
                    isFind = true;
                    break;
                }
                ++i;
            }
            if (!isFind) {
                newArchives.add(archiveFiles[j].getName());
            }
            ++j;
        }
        boolean returnValue = false;
        if (newArchives.size() != 0) {
            ((Hashtable)props).put(NEW_ARCHIVES, newArchives);
            returnValue = true;
        }
        if (removedArchives.size() != 0) {
            ((Hashtable)props).put(REMOVED_ARCHIVES, removedArchives);
            returnValue = true;
        }
        if (changedArchives.size() != 0) {
            ((Hashtable)props).put(CHANGED_ARCHIVES, changedArchives);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) {
        if (((Hashtable)props).get(NEW_ARCHIVES) != null) {
            props.setProperty("needStop", "true");
            return true;
        }
        if (((Hashtable)props).get(REMOVED_ARCHIVES) != null) {
            props.setProperty("needStop", "true");
            return true;
        }
        if (((Hashtable)props).get(CHANGED_ARCHIVES) != null) {
            Vector changedArchives = (Vector)((Hashtable)props).get(CHANGED_ARCHIVES);
            int i = 0;
            while (i < changedArchives.size()) {
                String alias = SBasic.deployCommunicator.getAlias((String)changedArchives.elementAt(i), dInfo.getApplicationName());
                if (((Hashtable)props).get(alias + NEW_FILES) != null && this.needStop((String[])((Hashtable)props).get(alias + NEW_FILES))) {
                    props.setProperty("needStop", "true");
                    return true;
                }
                if (((Hashtable)props).get(alias + REMOVED_FILES) != null && this.needStop((String[])((Hashtable)props).get(alias + REMOVED_FILES))) {
                    props.setProperty("needStop", "true");
                    return true;
                }
                if (((Hashtable)props).get(alias + CHANGED_FILES) != null && this.needStop((String[])((Hashtable)props).get(alias + CHANGED_FILES))) {
                    props.setProperty("needStop", "true");
                    return true;
                }
                ++i;
            }
        }
        props.setProperty("needStop", "false");
        return false;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Vector removedArchives;
        Object webApplWorkDir;
        Vector warnings = new Vector();
        Vector<String> allAliases = new Vector<String>();
        String[] exsitingAliases = SBasic.deployCommunicator.getAliases(dInfo.getApplicationName());
        int i = 0;
        while (i < exsitingAliases.length) {
            allAliases.add(exsitingAliases[i]);
            ++i;
        }
        ApplicationDeployInfo info = new ApplicationDeployInfo();
        Configuration appConfig = dInfo.getConfiguration();
        Configuration servlet_jspConfig = null;
        Configuration servlet_jspUpdate = null;
        String aliasDir = null;
        try {
            servlet_jspConfig = appConfig.getSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException ce) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Exception occured in createSubConfiguration() method of application " + dInfo.getApplicationName() + ".", (Throwable)((Object)ce), "");
            throw new WebDeploymentException(WebDeploymentException.EXCEPTION_OCCURED_IN_METHOD_FOR_APPLICATION, new Object[]{"createSubConfiguration()", dInfo.getApplicationName()}, (Throwable)((Object)ce));
        }
        this.storeFailOverToDB(dInfo, servlet_jspConfig);
        this.storeAltDDToDB(dInfo, servlet_jspConfig);
        try {
            servlet_jspConfig.deleteSubConfigurations(new String[]{"update"});
            servlet_jspUpdate = servlet_jspConfig.createSubConfiguration("update");
            servlet_jspUpdate.addConfigEntry("FILE_COUNTER", "1");
        }
        catch (ConfigurationException ce) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Exception occured in createSubConfiguration() method of application " + dInfo.getApplicationName() + ".", (Throwable)((Object)ce), "");
            throw new WebDeploymentException(WebDeploymentException.EXCEPTION_OCCURED_IN_METHOD_FOR_APPLICATION, new Object[]{"createSubConfiguration()", dInfo.getApplicationName()}, (Throwable)((Object)ce));
        }
        Vector newArchives = (Vector)((Hashtable)props).get(NEW_ARCHIVES);
        if (newArchives != null && newArchives.size() != 0) {
            int i2 = 0;
            while (i2 < newArchives.size()) {
                String alias = this.getAlias(dInfo.getApplicationName(), props, (String)newArchives.elementAt(i2));
                if (alias == null) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot find the proper alias for " + newArchives.elementAt(i2) + " war file!", "");
                    throw new WebDeploymentException(WebDeploymentException.CANNOT_FIND_THE_PROPER_ALIAS_FOR_WAR_FILE_IN_APPLICATION, new Object[]{newArchives.elementAt(i2), dInfo.getApplicationName()});
                }
                allAliases.add(alias);
                Log.getLocation(3).traceInfo("Adding web application " + alias, alias);
                if (alias.startsWith("/") && !alias.equals("/")) {
                    alias = alias.substring(1);
                }
                if (alias.trim().equals("")) {
                    throw new WebDeploymentException(WebDeploymentException.EMPTY_CONTEXT_ROOT_FOR_ARCHIVE_IN_APPLICATION, new Object[]{newArchives.elementAt(i2), dInfo.getApplicationName()});
                }
                aliasDir = alias.equals("/") || alias.equals("\\") ? "_default" : alias.replace('/', '/').replace('\\', '/');
                webApplWorkDir = new File(this.getDeployTempDir(dInfo.getApplicationName()) + File.separator + aliasDir + File.separator);
                ((File)webApplWorkDir).mkdir();
                String warFileName = (String)newArchives.elementAt(i2);
                File warFile = new File((File)webApplWorkDir, warFileName);
                int indexWarFile = -1;
                int j = 0;
                while (j < archiveFiles.length) {
                    if (archiveFiles[j].getName().equals(newArchives.elementAt(i2))) {
                        indexWarFile = j;
                        break;
                    }
                    ++j;
                }
                if (indexWarFile == -1) {
                    throw new WebDeploymentException(WebDeploymentException.INCONGROUOUS_PROPERTIES_FOR_UPDATE_OF_APPLICATION, new Object[]{dInfo.getApplicationName()});
                }
                File tempWarFile = new File((File)webApplWorkDir, "temp_" + warFileName);
                try {
                    this.copyFile(archiveFiles[indexWarFile], tempWarFile);
                }
                catch (IOException io) {
                    throw new WebDeploymentException(WebDeploymentException.CANNOT_COPY_FILE_IN_WORK_FOLDER_OF_APPLICATION, new Object[]{archiveFiles[indexWarFile].getPath(), dInfo.getApplicationName()}, io);
                }
                this.extractWar(dInfo.getApplicationName(), aliasDir, tempWarFile);
                if (!tempWarFile.renameTo(warFile)) {
                    Log.getCategory(1).logError(WebContainer.currentLocation, "Error while renaming war file!", dInfo.getApplicationName());
                    throw new WebDeploymentException("servlet_jsp_0297", new Object[]{"temp_" + warFileName, dInfo.getApplicationName()});
                }
                try {
                    this.store2DBase(warFile, aliasDir, servlet_jspConfig);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new WebDeploymentException(WebDeploymentException.CANNOT_STORE_FILE_FROM_APPLICATION_IN_DATABASE, new Object[]{archiveFiles[indexWarFile].getPath(), dInfo.getApplicationName()}, e);
                }
                try {
                    this.registerAliasInHttp(dInfo.getApplicationName(), alias);
                }
                catch (WarningException e) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot set alias for the application " + dInfo.getApplicationName() + " in http service.", e, alias);
                }
                warnings = this.servletsAndJsp.deploy(dInfo.getApplicationName(), alias, appConfig, null);
                ++i2;
            }
        }
        if ((removedArchives = (Vector)((Hashtable)props).get(REMOVED_ARCHIVES)) != null && removedArchives.size() != 0) {
            int i3 = 0;
            while (i3 < removedArchives.size()) {
                allAliases.remove(removedArchives.elementAt(i3));
                Log.getLocation(3).traceInfo("Removing web application " + (String)removedArchives.elementAt(i3), (String)removedArchives.elementAt(i3));
                this.deleteAlias(dInfo.getApplicationName(), (String)removedArchives.elementAt(i3));
                this.deleteFromDB(servlet_jspConfig, SBasic.deployCommunicator.getWarName((String)removedArchives.elementAt(i3)));
                ++i3;
            }
        }
        Vector changedArchives = (Vector)((Hashtable)props).get(CHANGED_ARCHIVES);
        webApplWorkDir = null;
        if (changedArchives != null && changedArchives.size() != 0) {
            int i4 = 0;
            while (i4 < changedArchives.size()) {
                String[] deletedFiles;
                String[] changedFiles;
                String alias = SBasic.deployCommunicator.getAlias((String)changedArchives.elementAt(i4), dInfo.getApplicationName());
                if (alias == null) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot find the proper alias for " + newArchives.elementAt(i4) + " war file!", "");
                    throw new WebDeploymentException(WebDeploymentException.CANNOT_FIND_THE_PROPER_ALIAS_FOR_WAR_FILE_IN_APPLICATION, new Object[]{newArchives.elementAt(i4), dInfo.getApplicationName()});
                }
                Log.getLocation(3).traceInfo("Updating web application " + alias, alias);
                if (alias.startsWith("/") && !alias.equals("/")) {
                    alias = alias.substring(1);
                }
                if (alias.trim().equals("")) {
                    throw new WebDeploymentException(WebDeploymentException.EMPTY_CONTEXT_ROOT_FOR_ARCHIVE_IN_APPLICATION, new Object[]{newArchives.elementAt(i4), dInfo.getApplicationName()});
                }
                aliasDir = alias.equals("/") || alias.equals("\\") ? "_default" : alias.replace('/', File.separatorChar);
                webApplWorkDir = this.getDeployTempDir(dInfo.getApplicationName()) + "/" + aliasDir + "/";
                File warFile = new File((String)webApplWorkDir, (String)changedArchives.elementAt(i4));
                int indexWarFile = -1;
                int j = 0;
                while (j < archiveFiles.length) {
                    if (archiveFiles[j].getName().equals(changedArchives.elementAt(i4))) {
                        indexWarFile = j;
                        break;
                    }
                    ++j;
                }
                if (indexWarFile == -1) {
                    throw new WebDeploymentException(WebDeploymentException.INCONGROUOUS_PROPERTIES_FOR_UPDATE_OF_APPLICATION, new Object[]{dInfo.getApplicationName()});
                }
                try {
                    try {
                        this.copyFile(archiveFiles[indexWarFile], warFile);
                    }
                    catch (IOException io) {
                        throw new WebDeploymentException(WebDeploymentException.CANNOT_COPY_FILE_IN_WORK_FOLDER_OF_APPLICATION, new Object[]{archiveFiles[indexWarFile].getPath(), dInfo.getApplicationName()}, io);
                    }
                    this.store2DBase(warFile, servlet_jspConfig);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new WebDeploymentException(WebDeploymentException.CANNOT_STORE_FILE_FROM_APPLICATION_IN_DATABASE, new Object[]{archiveFiles[indexWarFile].getPath(), dInfo.getApplicationName()}, e);
                }
                webApplWorkDir = (String)webApplWorkDir + "root/";
                String[] newFiles = (String[])((Hashtable)props).get(alias + NEW_FILES);
                if (newFiles != null && newFiles.length != 0) {
                    Vector<String> files = new Vector<String>();
                    int k = 0;
                    while (k < newFiles.length) {
                        files.add(newFiles[k]);
                        ++k;
                    }
                    try {
                        this.extractSomeClasses(archiveFiles[indexWarFile].getAbsolutePath(), files, (String)webApplWorkDir);
                    }
                    catch (IOException ioe) {
                        throw new WebDeploymentException(WebDeploymentException.CANNOT_EXTRACT_NEW_FILES_FOR_WEB_APPLICATION_WHILE_UPDATING, new Object[]{alias}, ioe);
                    }
                }
                if ((changedFiles = (String[])((Hashtable)props).get(alias + CHANGED_FILES)) != null && changedFiles.length != 0) {
                    boolean isDescriptorChanged = false;
                    Vector<String> files = new Vector<String>();
                    int k = 0;
                    while (k < changedFiles.length) {
                        files.add(changedFiles[k]);
                        if (changedFiles[k].equals("WEB-INF/web.xml") || changedFiles[k].equals("WEB-INF/web-j2ee-engine.xml")) {
                            isDescriptorChanged = true;
                        }
                        ++k;
                    }
                    try {
                        this.extractSomeClasses(archiveFiles[indexWarFile].getAbsolutePath(), files, (String)webApplWorkDir);
                        if (isDescriptorChanged) {
                            warnings = this.servletsAndJsp.update(dInfo.getApplicationName(), alias, appConfig);
                        }
                    }
                    catch (IOException ioe) {
                        throw new WebDeploymentException(WebDeploymentException.CANNOT_EXTRACT_CHANGED_FILES_FOR_WEB_APPLICATION_WHILE_UPDATING, new Object[]{alias}, ioe);
                    }
                }
                if ((deletedFiles = (String[])((Hashtable)props).get(alias + REMOVED_FILES)) != null && deletedFiles.length != 0) {
                    int k = 0;
                    while (k < deletedFiles.length) {
                        new File((String)webApplWorkDir + deletedFiles[k].replace('/', File.separatorChar)).delete();
                        ++k;
                    }
                }
                ++i4;
            }
        }
        String[] aliases = new String[allAliases.size()];
        int i5 = 0;
        while (i5 < allAliases.size()) {
            aliases[i5] = (String)allAliases.elementAt(i5);
            ++i5;
        }
        info.setDeployedComponentNames(aliases);
        info.addFilesForClassloader(this.getFilesForClassPath(dInfo.getApplicationName(), aliases));
        info.setDeployProperties(props);
        if (warnings != null && warnings.size() != 0) {
            info.addWarning(warnings.toString());
        }
        return info;
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) {
        ApplicationDeployInfo info = new ApplicationDeployInfo();
        try {
            String[] aliases = SBasic.deployCommunicator.getAliases(applicationName);
            info.setDeployedComponentNames(aliases);
            info.addFilesForClassloader(this.getFilesForClassPath(applicationName, aliases));
            int i = 0;
            while (i < aliases.length) {
                Properties resourceRef = null;
                resourceRef = (Properties)ActionBase.mapAliasResourceRef.get(aliases[i]);
                if (resourceRef != null) {
                    Enumeration en = ((Hashtable)resourceRef).keys();
                    while (en.hasMoreElements()) {
                        String resourceName = (String)en.nextElement();
                        String resourceType = resourceRef.getProperty(resourceName);
                        info.addResourceReference(resourceName, resourceType);
                    }
                    ActionBase.mapAliasResourceRef.remove(aliases[i]);
                }
                ++i;
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot set ApplicationDeployInfo for " + applicationName + " in commitSingleFileUpdate phase", e, applicationName);
        }
        try {
            this.runtimeInterface.update(applicationName);
        }
        catch (RemoteException re) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for updating " + applicationName + " application.", re, applicationName);
        }
        catch (RuntimeException runEx) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for updating " + applicationName + " application.", runEx, applicationName);
        }
        return info;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
        File webApplWorkDir = new File(this.getDeployTempDir(applicationName) + File.separator);
        this.deleteTempDir(webApplWorkDir);
        try {
            Vector archives = (Vector)((Hashtable)props).get(CHANGED_ARCHIVES);
            int i = 0;
            while (i < archives.size()) {
                String alias = this.getAlias(applicationName, props, (String)archives.elementAt(i));
                String aliasDir = alias.equals("/") ? "_default" : alias.replace('/', '/').replace('\\', '/');
                File workDir = new File(this.getDeployTempDir(applicationName) + File.separator + aliasDir + File.separator);
                workDir.mkdir();
                workDir = new File(this.getDeployTempDir(applicationName) + File.separator + aliasDir + File.separator + "root");
                workDir.mkdir();
                workDir = new File(this.getDeployTempDir(applicationName) + File.separator + aliasDir + File.separator + "work");
                workDir.mkdir();
                ++i;
            }
            Configuration servlet_jspConfig = applicationConfig.getSubConfiguration(this.containerInfo.getName());
            this.loadFromDBase(applicationName, servlet_jspConfig);
            if (servlet_jspConfig.existsSubConfiguration("update")) {
                Configuration servlet_jspUpdate = servlet_jspConfig.getSubConfiguration("update");
                this.loadUpdatesFromDBase(applicationName, servlet_jspUpdate);
            }
            if ((archives = (Vector)((Hashtable)props).get(NEW_ARCHIVES)) != null && archives.size() != 0) {
                int i2 = 0;
                while (i2 < archives.size()) {
                    String alias = this.getAlias(applicationName, props, (String)archives.elementAt(i2));
                    this.deleteAlias(applicationName, alias);
                    ++i2;
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebWarningException(WebWarningException.CANNOT_DOWNLOAD_UPDATES_OF_APPLICATION_FROM_DATABASE_IN_METHOD, new Object[]{applicationName, "notifySingleFileUpdate()"}, e);
        }
    }

    private void extractBeforeUpdate(String applicationName) throws DeploymentException {
        String[] aliases = SBasic.deployCommunicator.getAliases(applicationName);
        int i = 0;
        while (i < aliases.length) {
            String warPath = SBasic.deployCommunicator.getWarName(aliases[i]);
            this.extractWar(applicationName, aliases[i], new File(warPath));
            ++i;
        }
    }

    private boolean needStop(String[] files) {
        int i = 0;
        while (i < files.length) {
            if (files[i].startsWith("WEB-INF") || files[i].startsWith("//WEB-INF")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getAlias(String applicationName, Properties props, String warName) throws DeploymentException {
        String[] allAliases = this.getAliases(applicationName, props);
        String war = null;
        int i = 0;
        while (i < allAliases.length) {
            war = props.getProperty("web:" + allAliases[i]);
            if (war.equals(warName)) {
                if (allAliases[i] == null || allAliases[i].trim().equals("")) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot find the proper alias for " + warName + " war file!", "");
                    throw new WebDeploymentException(WebDeploymentException.EMPTY_CONTEXT_ROOT_FOR_ARCHIVE_IN_APPLICATION, new Object[]{warName, applicationName});
                }
                if (allAliases[i].startsWith("/") && !allAliases[i].equals("/")) {
                    allAliases[i] = allAliases[i].substring(1);
                }
                return allAliases[i];
            }
            ++i;
        }
        throw new WebDeploymentException(WebDeploymentException.INCORRECT_PROPERTIES_FOR_UPDATE_CANNOT_FIND_WAR_ARCHIVE_WITH_NAME, new Object[]{warName});
    }

    private void deleteAlias(String application, String alias) {
        String tempDir;
        String clearDir;
        int sep;
        String aliasURL = ParseUtils.convertAlias((String)alias);
        String aliasDir = aliasURL;
        if (aliasDir.equals("/")) {
            aliasDir = "_default";
        }
        if ((sep = (clearDir = (tempDir = this.getDeployTempDir(application)) + "/" + aliasDir).indexOf("/", tempDir.length() + 1)) > -1) {
            this.deleteTempDir(new File(clearDir.substring(0, sep)));
        } else {
            this.deleteTempDir(new File(clearDir));
        }
    }

    private void deleteFromDB(Configuration config, String warName) {
        try {
            config.deleteConfigEntry(warName);
            config.deleteFile(warName);
        }
        catch (ConfigurationException e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot delete configuration entries for archive " + warName, (Throwable)((Object)e), "");
        }
    }

    private void deleteTempDir(File file) {
        File[] children = file.listFiles();
        if (children == null || children.length == 0) {
            file.delete();
        } else {
            int i = 0;
            while (i < children.length) {
                this.deleteTempDir(children[i]);
                ++i;
            }
            file.delete();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void extractSomeClasses(String warFilePath, Vector files, String root) throws IOException {
        block24: {
            File f = new File(warFilePath);
            if (!f.exists()) {
                return;
            }
            byte[] buff = new byte[24576];
            if (!f.isDirectory()) {
                ZipFile zip = null;
                zip = new ZipFile(f);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                while (enumeration.hasMoreElements()) {
                    Object var16_19;
                    int index;
                    ZipEntry entry = enumeration.nextElement();
                    if (!files.contains(entry.getName()) || entry.isDirectory()) continue;
                    String dirName = root + entry.getName();
                    File nf = new File(dirName);
                    if (nf.exists()) {
                        nf.delete();
                    }
                    if ((index = dirName.lastIndexOf(47)) != -1) {
                        String packEntryName = dirName.substring(0, index);
                        File d = new File(packEntryName = packEntryName.replace('/', File.separatorChar));
                        if (!d.exists()) {
                            d.mkdirs();
                        }
                    }
                    BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                    RandomAccessFile rm = new RandomAccessFile(dirName, "rw");
                    rm.seek(0L);
                    try {
                        int c;
                        while ((c = ((InputStream)is).read(buff)) != -1) {
                            void var14_18;
                            rm.write(buff, 0, (int)var14_18);
                        }
                        var16_19 = null;
                    }
                    catch (Throwable throwable) {
                        var16_19 = null;
                        rm.close();
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    rm.close();
                    ((InputStream)is).close();
                    {
                    }
                }
                Object var18_21 = null;
                buff = null;
                if (zip == null) break block24;
                try {
                    zip.close();
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Error in closing file " + zip.getName() + ".", e, "");
                }
                {
                    break block24;
                    catch (FileNotFoundException fnfe) {
                        throw new WebFileNotFoundException(WebFileNotFoundException.FILENAME_TOO_LONG, fnfe);
                    }
                    catch (OutOfMemoryError e) {
                        throw e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new WebIOException("servlet_jsp_0134", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var18_22 = null;
                    buff = null;
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (OutOfMemoryError e) {
                            throw e;
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            Log.getCategory(1).logError(ActionBase.currentLocation, "Error in closing file " + zip.getName() + ".", e, "");
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

