/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class StopAction
extends ActionBase {
    public StopAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public void commitStop(String applicationName) throws WarningException {
        String[] aliases = this.getAliases(applicationName);
        int i = 0;
        while (i < aliases.length) {
            String aliasURL = ParseUtils.convertAlias((String)aliases[i]);
            ApplicationContext scf = (ApplicationContext)SBasic.startedWebApplications.get(new MessageBytes(aliasURL.getBytes()));
            if (scf == null) {
                Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot stop web application " + aliasURL + ". Such application does not exist or is not started.", aliases[i]);
            } else {
                ActionBase.destroyAll(scf);
                scf.destroy();
                SBasic.startedWebApplications.remove(new MessageBytes(aliasURL.getBytes()));
                HttpProvider httpProvider = this.servletsAndJsp.getHttpProvider();
                if (httpProvider != null) {
                    httpProvider.clearCacheByAlias(ParseUtils.convertAlias((String)aliases[i]));
                } else {
                    Log.getCategory(1).logWarning(ActionBase.currentLocation, "HTTP service is stopped and cannot clear http cache!", aliases[i]);
                }
            }
            ++i;
        }
        this.unBindApp(applicationName);
        try {
            this.runtimeInterface.appStopped(applicationName);
        }
        catch (RemoteException re) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for stopping " + applicationName + " application.", re, applicationName);
            throw new WebWarningException(WebWarningException.CANNOT_NOTIFY_RUNTIME_INTERFACE_FOR_CHANGING_STATUS_OF_APPLICATION_ERROR_IS, new Object[]{applicationName, re.toString()});
        }
        catch (RuntimeException runEx) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for stopping " + applicationName + " application.", runEx, applicationName);
            throw new WebWarningException(WebWarningException.CANNOT_NOTIFY_RUNTIME_INTERFACE_FOR_CHANGING_STATUS_OF_APPLICATION_ERROR_IS, new Object[]{applicationName, runEx.toString()});
        }
    }

    private void unBindApp(String applicationName) {
        InitialDirContext ctx = null;
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)p).put("Replicate", "false");
        ((Hashtable)p).put("domain", "true");
        try {
            ctx = new InitialDirContext(p);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Can't get a naming context.", e, applicationName);
        }
        try {
            if (applicationName.equals("/")) {
                applicationName = "_default";
            }
            Context web = (Context)ctx.lookup("webContainer/applications/" + applicationName);
            this.destroy(web);
            ((Context)ctx.lookup("webContainer/applications")).destroySubcontext(applicationName);
        }
        catch (NamingException ne) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Can't lookup and destroy an application context of " + applicationName + " application.", ne, "");
        }
    }

    private void destroy(Context root) throws NamingException {
        NameClassPair pair = null;
        NamingEnumeration<NameClassPair> ne = root.list("");
        while (ne.hasMoreElements()) {
            pair = (NameClassPair)ne.nextElement();
            if (this.isContext(pair.getClassName())) {
                try {
                    this.destroy((Context)root.lookup(pair.getName()));
                    root.destroySubcontext(pair.getName());
                }
                catch (ContextNotEmptyException cnee) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot destroy naming context!", cnee, "");
                }
                continue;
            }
            root.unbind("+/" + pair.getName());
        }
    }

    private boolean isContext(String nm) {
        return nm.indexOf("javax.naming.Context") != -1 || nm.indexOf("javax.naming.directory.DirContext") != -1;
    }
}

