/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.ApplicationThreadInitializer;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.rmi.RemoteException;
import java.util.Vector;

public class StartAction
extends ActionBase {
    public StartAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public void prepareStart(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        Configuration sevlet_jspConfig = null;
        Vector warnings = new Vector();
        ApplicationContext scf = null;
        try {
            sevlet_jspConfig = appConfig.getSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException ce) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Exception occured in getSubConfiguration() method of application " + applicationName + ".", (Throwable)((Object)ce), applicationName);
        }
        try {
            String[] aliases = this.getAliases(applicationName);
            int i = 0;
            while (i < aliases.length) {
                try {
                    scf = this.servletsAndJsp.createContext(applicationName, aliases[i], sevlet_jspConfig, warnings);
                    Vector newWarnings = scf.getWarnings();
                    if (newWarnings != null) {
                        int j = 0;
                        while (j < newWarnings.size()) {
                            warnings.add(newWarnings.elementAt(j));
                            ++j;
                        }
                    }
                    CountDown cd = new CountDown(1);
                    ApplicationThreadInitializer initializer = new ApplicationThreadInitializer(cd, scf.getWebApplicationConfiguration(), SBasic.classLoader, scf, scf.getWebApplicationConfiguration().getAllServlets());
                    SBasic.threadSystem.startCleanThread(initializer, false, false);
                    cd.acquire();
                    if (initializer.getException() != null) {
                        Log.getCategory(1).logError(ActionBase.currentLocation, "Error while starting web application " + aliases[i] + "!", initializer.getException(), applicationName);
                        throw new WebDeploymentException(WebDeploymentException.ERROR_IN_STARTING_OF_WEB_APPLICATION, new Object[]{scf.getAliasName()}, initializer.getException());
                    }
                    newWarnings = initializer.getWarnings();
                    if (newWarnings != null && newWarnings.size() != 0) {
                        int j = 0;
                        while (j < newWarnings.size()) {
                            warnings.add(newWarnings.elementAt(j));
                            ++j;
                        }
                    }
                    String alias = ParseUtils.convertAlias((String)aliases[i]);
                    SBasic.startedWebApplications.put(new MessageBytes(alias.getBytes()), scf);
                    this.servletsAndJsp.getHttpProvider().startApplicationAlias(alias, scf.getWebApplicationRootDir());
                    try {
                        this.servletsAndJsp.getHttpProvider().clearCacheByAlias(alias);
                    }
                    catch (OutOfMemoryError e) {
                        throw e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        Log.getCategory(1).logError(ActionBase.currentLocation, "Http cache not cleared.", t, aliases[i]);
                    }
                }
                catch (InterruptedException ex) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Error while starting web application " + aliases[i] + "!", ex, scf.getAliasName());
                    throw new WebDeploymentException(WebDeploymentException.ERROR_IN_STARTING_OF_WEB_APPLICATION, new Object[]{scf.getAliasName()}, ex);
                }
                ++i;
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Error in starting application " + applicationName + ".", e, applicationName);
            if (scf != null) {
                ActionBase.destroyAll(scf);
            }
            throw new WebDeploymentException(WebDeploymentException.ERROR_IN_STARTING_APPLICATION, new Object[]{applicationName}, e);
        }
        this.makeWarningException(warnings);
    }

    public void commitStart(String applicationName) throws WarningException {
        try {
            this.runtimeInterface.appStarted(applicationName);
        }
        catch (RemoteException x) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for starting " + applicationName + " application.", x, applicationName);
            throw new WebWarningException(WebWarningException.CANNOT_NOTIFY_RUNTIME_INTERFACE_FOR_CHANGING_STATUS_OF_APPLICATION_ERROR_IS, new Object[]{applicationName, x.toString()});
        }
        catch (RuntimeException re) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for starting " + applicationName + " application.", re, applicationName);
            throw new WebWarningException(WebWarningException.CANNOT_NOTIFY_RUNTIME_INTERFACE_FOR_CHANGING_STATUS_OF_APPLICATION_ERROR_IS, new Object[]{applicationName, re.toString()});
        }
    }
}

