/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.AdditionalWebDescrDocument;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebRemoteException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.Vector;

public class SingleFileUpdateAction
extends ActionBase {
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$container$SingleFileUpdateAction;

    public SingleFileUpdateAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        boolean needRestart = false;
        int i = 0;
        while (i < files.length) {
            if (files[i].getFileEntryName().endsWith("WEB-INF/web.xml") || files[i].getFileEntryName().endsWith("WEB-INF/web-j2ee-engine.xml")) {
                String applicationName = dInfo.getApplicationName();
                String warName = files[i].getArchiveName();
                String aliasName = SBasic.deployCommunicator.getAlias(warName, applicationName);
                if (this.isSecurityChanged(files[i], aliasName, applicationName, files) || this.isRunAsChanged(files[i].getFileName(), aliasName, applicationName)) {
                    throw new WebDeploymentException(WebDeploymentException.UPDATEING_DEPLOYMENT_DESCRIPTORU_IS_NOT_ALLOWED_AT_THIS_OPERATION);
                }
                needRestart = true;
            } else if (files[i].getFileEntryName().startsWith("WEB-INF") || files[i].getFileEntryName().startsWith("/WEB-INF")) {
                needRestart = true;
            }
            ++i;
        }
        props.setProperty("needRestart", new Boolean(needRestart).toString());
        return needRestart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSecurityChanged(FileUpdateInfo file, String aliasName, String applicationName, FileUpdateInfo[] files) {
        String fileName = file.getFileName();
        WebDeploymentDescriptor webDesc = null;
        if (fileName.endsWith("web.xml")) {
            webDesc = this.getDescriptor(fileName, null);
        } else {
            boolean found = false;
            int i = 0;
            while (i < files.length) {
                if (files[i].getFileEntryName().endsWith("WEB-INF/web.xml") && file.getArchiveName().equals(files[i].getArchiveName())) {
                    found = true;
                    webDesc = this.getDescriptor(files[i].getFileName(), fileName);
                    break;
                }
                ++i;
            }
            if (!found) {
                try {
                    webDesc = this.getDescriptor((this.getDescriptorPath(aliasName, applicationName) + "web.xml").trim(), fileName);
                }
                catch (RemoteException e) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot load the old descriptor for the application " + applicationName + ".", e, aliasName);
                    return true;
                }
            }
        }
        if (webDesc == null) return true;
        WebDeploymentDescriptor oldDescr = null;
        try {
            String descriptorPath = this.getDescriptorPath(aliasName, applicationName);
            oldDescr = fileName.endsWith("web.xml") ? this.getDescriptor((descriptorPath + "web.xml").trim(), null) : (new File(descriptorPath + "web-j2ee-engine.xml").exists() ? this.getDescriptor((descriptorPath + "web.xml").trim(), (descriptorPath + "web-j2ee-engine.xml").trim()) : this.getDescriptor((descriptorPath + "web.xml").trim(), null));
        }
        catch (RemoteException e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot load the old descriptor for the application " + applicationName + ".", e, aliasName);
            return true;
        }
        if (oldDescr == null) return true;
        if (oldDescr.getSecRoles() != null && webDesc.getSecRoles() != null) {
            if (!EqualUtils.equalOrderedArrays(oldDescr.getSecRoles(), webDesc.getSecRoles())) {
                return true;
            }
        } else if (oldDescr.getSecRoles() != null || webDesc.getSecRoles() != null) {
            return true;
        }
        if (oldDescr.getLoginConfig() != null && webDesc.getLoginConfig() != null) {
            if (oldDescr.getLoginConfig().getAuthMethod() != null && webDesc.getLoginConfig().getAuthMethod() != null) {
                if (!oldDescr.getLoginConfig().getAuthMethod().equals(webDesc.getLoginConfig().getAuthMethod())) {
                    return true;
                }
            } else if (oldDescr.getLoginConfig().getAuthMethod() != null || webDesc.getLoginConfig().getAuthMethod() != null) {
                return true;
            }
            if (oldDescr.getLoginConfig().getRealmName() != null && webDesc.getLoginConfig().getRealmName() != null) {
                if (!oldDescr.getLoginConfig().getRealmName().equals(webDesc.getLoginConfig().getRealmName())) {
                    return true;
                }
            } else if (oldDescr.getLoginConfig().getRealmName() != null || webDesc.getLoginConfig().getRealmName() != null) {
                return true;
            }
        } else if (oldDescr.getLoginConfig() != null || webDesc.getLoginConfig() != null) {
            return true;
        }
        if (oldDescr.getAuthentication() != null && webDesc.getAuthentication() != null) {
            if (oldDescr.getAuthentication().equals(webDesc.getAuthentication())) return false;
            return true;
        }
        if (oldDescr.getAuthentication() == null && webDesc.getAuthentication() == null) return false;
        return true;
    }

    private boolean isRunAsChanged(String fileName, String aliasName, String applicationName) {
        if (fileName.endsWith("web-j2ee-engine.xml")) {
            return false;
        }
        WebDeploymentDescriptor webDesc = this.getDescriptor(fileName, null);
        if (webDesc != null) {
            WebDeploymentDescriptor oldDescr = null;
            try {
                oldDescr = this.getDescriptor((this.getDescriptorPath(aliasName, applicationName) + "web.xml").trim(), null);
            }
            catch (RemoteException e) {
                Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot load the old descriptor for the application " + applicationName + ".", e, aliasName);
                return true;
            }
            ServletDescriptor[] servlets1 = null;
            ServletDescriptor[] servlets2 = webDesc.getServlets();
            if (servlets2 == null || servlets2.length == 0) {
                return false;
            }
            if (oldDescr != null) {
                servlets1 = oldDescr.getServlets();
                int j = 0;
                while (j < servlets2.length) {
                    if (servlets2[j].getRunAs() != null) {
                        boolean found = false;
                        int k = 0;
                        while (k < servlets1.length) {
                            RunAsIdentity rasid = servlets1[k].getRunAs();
                            if (rasid != null && rasid.equals(servlets2[j].getRunAs())) {
                                found = true;
                                break;
                            }
                            ++k;
                        }
                        if (!found) {
                            return true;
                        }
                    }
                    ++j;
                }
            } else if (servlets2 != null) {
                int j = 0;
                while (j < servlets2.length) {
                    if (servlets2[j].getRunAs() != null) {
                        return true;
                    }
                    ++j;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private WebDeploymentDescriptor getDescriptor(String xmlFile, String addXmlFile) {
        WebDeploymentDescriptor webDeploymentDescriptor = null;
        ClassLoader previousClassLoader = null;
        StandardDOMParser parser = null;
        try {
            previousClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$servlets_jsp$server$container$SingleFileUpdateAction == null ? (class$com$sap$engine$services$servlets_jsp$server$container$SingleFileUpdateAction = SingleFileUpdateAction.class$("com.sap.engine.services.servlets_jsp.server.container.SingleFileUpdateAction")) : class$com$sap$engine$services$servlets_jsp$server$container$SingleFileUpdateAction).getClassLoader());
            parser = new StandardDOMParser();
            try {
                WebDescriptorDocument doc = new WebDescriptorDocument();
                webDeploymentDescriptor = doc.loadDescriptorFromDocument(parser.parse(xmlFile));
                if (addXmlFile != null) {
                    AdditionalWebDescrDocument addDoc = new AdditionalWebDescrDocument();
                    webDeploymentDescriptor = addDoc.loadDescriptorFromDocument(parser.parse(addXmlFile), webDeploymentDescriptor);
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot load a descriptor for web.xml or web-j2ee-engine.xml.", e, "");
                WebDeploymentDescriptor webDeploymentDescriptor2 = null;
                Object var11_12 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
                return webDeploymentDescriptor2;
            }
            Object var11_13 = null;
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            throw throwable;
        }
        return webDeploymentDescriptor;
    }

    private String getDescriptorPath(String aliasName, String applicationName) throws RemoteException {
        String aliasDir = aliasName;
        if (aliasName.equals("/")) {
            aliasDir = "_default";
        }
        try {
            return SBasic.deployCommunicator.getMyWorkDirectory(applicationName) + File.separator + aliasDir.replace('/', File.separatorChar) + File.separator + "root" + File.separator + "WEB-INF" + File.separator;
        }
        catch (IOException ioe) {
            throw new WebRemoteException(WebRemoteException.CANNOT_GET_PATH_TO_DESCRIPTOR_FOR_WEB_APPLICATION, new Object[]{aliasName}, ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Vector<String> aliases = new Vector<String>();
        Configuration servlet_jspUpdate = null;
        try {
            Configuration servlet_jspConfig = dInfo.getConfiguration().getSubConfiguration(this.containerInfo.getName());
            servlet_jspUpdate = servlet_jspConfig.getSubConfiguration("update");
        }
        catch (ConfigurationException ce) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_CONFIGURATION_FOR_APPLICATION, new Object[]{dInfo.getApplicationName()}, (Throwable)((Object)ce));
        }
        String fileDir = this.getDeployTempDir(dInfo.getApplicationName());
        byte[] buff = new byte[24576];
        int i = 0;
        while (i < files.length) {
            String alias = SBasic.deployCommunicator.getAlias(files[i].getArchiveEntryName(), dInfo.getApplicationName());
            String filePathStr = fileDir + File.separator + alias + File.separator + "root" + File.separator + files[i].getFileEntryName();
            File nf = new File(filePathStr);
            int index = filePathStr.lastIndexOf(47);
            if (nf.isDirectory() || index == filePathStr.length() - 1) {
                throw new WebDeploymentException(WebDeploymentException.UPDATE_OF_DIRECTORY_IS_NOT_SUPPORTED, new Object[]{files[i].getFileEntryName(), files[i].getArchiveName()});
            }
            try {
                Object var17_20;
                this.store2DBase(new File(files[i].getFileName()), alias, files[i].getFileEntryName().replace('/', File.separatorChar), servlet_jspUpdate);
                if (nf.exists()) {
                    nf.delete();
                }
                if (index != -1) {
                    String packEntryName = filePathStr.substring(0, index);
                    File d = new File(packEntryName = packEntryName.replace('/', File.separatorChar));
                    if (!d.exists()) {
                        d.mkdirs();
                    }
                }
                FileInputStream is = new FileInputStream(files[i].getFileName());
                RandomAccessFile rm = new RandomAccessFile(filePathStr, "rw");
                rm.seek(0L);
                try {
                    int c;
                    while ((c = ((InputStream)is).read(buff)) != -1) {
                        void var15_18;
                        rm.write(buff, 0, (int)var15_18);
                    }
                    var17_20 = null;
                }
                catch (Throwable throwable) {
                    var17_20 = null;
                    rm.close();
                    ((InputStream)is).close();
                    throw throwable;
                }
                rm.close();
                ((InputStream)is).close();
                {
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                buff = null;
                throw new WebDeploymentException(WebDeploymentException.CANNOT_UPDATE_FILE_IN_ARCHIVE, new Object[]{files[i].getFileEntryName(), files[i].getArchiveName()}, e);
            }
            if (!aliases.contains(alias)) {
                aliases.add(alias);
            }
            ++i;
        }
        buff = null;
        ApplicationDeployInfo info = new ApplicationDeployInfo();
        String[] aliasArray = new String[aliases.size()];
        int i2 = 0;
        while (i2 < aliases.size()) {
            aliasArray[i2] = (String)aliases.elementAt(i2);
            ++i2;
        }
        info.setDeployedComponentNames(aliasArray);
        info.addFilesForClassloader(this.getFilesForClassPath(dInfo.getApplicationName(), aliasArray));
        info.setDeployProperties(props);
        return info;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
        try {
            Configuration servlet_jspConfig = config.getSubConfiguration(this.containerInfo.getName());
            Configuration servlet_jspUpdate = servlet_jspConfig.getSubConfiguration("update");
            this.loadUpdatesFromDBase(applicationName, servlet_jspUpdate);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebWarningException(WebWarningException.CANNOT_DOWNLOAD_UPDATES_OF_APPLICATION_FROM_DATABASE_IN_METHOD, new Object[]{applicationName, "notifySingleFileUpdate()"}, e);
        }
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) {
        ApplicationDeployInfo info = new ApplicationDeployInfo();
        try {
            String[] allAliases = SBasic.deployCommunicator.getAliases(applicationName);
            info.setDeployedComponentNames(allAliases);
            info.setFilesForClassloader(this.getFilesForClassPath(applicationName, allAliases));
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot set ApplicationDeployInfo for " + applicationName + " in commitSingleFileUpdate phase", e, applicationName);
        }
        return info;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
        try {
            Configuration servlet_jspConfig = config.getSubConfiguration(this.containerInfo.getName());
            Configuration servlet_jspUpdate = servlet_jspConfig.getSubConfiguration("update");
            this.loadFromDBase(applicationName, servlet_jspConfig);
            this.loadUpdatesFromDBase(applicationName, servlet_jspUpdate);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebWarningException(WebWarningException.CANNOT_DOWNLOAD_UPDATES_OF_APPLICATION_FROM_DATABASE_IN_METHOD, new Object[]{applicationName, "notifySingleFileUpdate()"}, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

