/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;

public class RuntimeChangesAction
extends ActionBase {
    public RuntimeChangesAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
        try {
            Configuration servlet_jspConfig = appConfig.getSubConfiguration(this.containerInfo.getName());
            Configuration servlet_jspUpdate = servlet_jspConfig.getSubConfiguration("update");
            this.loadUpdatesFromDBase(applicationName, servlet_jspUpdate);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebWarningException(WebWarningException.CANNOT_DOWNLOAD_UPDATES_OF_APPLICATION_FROM_DATABASE_IN_METHOD, new Object[]{applicationName, "notifyRuntimeChanges()"}, e);
        }
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        ApplicationDeployInfo info = new ApplicationDeployInfo();
        try {
            String[] aliases = SBasic.deployCommunicator.getAliases(applicationName);
            info.setDeployedComponentNames(aliases);
            info.addFilesForClassloader(this.getFilesForClassPath(applicationName, aliases));
        }
        catch (DeploymentException e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot set ApplicationDeployInfo for " + applicationName + " in commitRuntimeChanges phase", (Throwable)((Object)e), applicationName);
            throw new WebWarningException(WebWarningException.CANNOT_SET_APPLICATIONDEPLOYINFO_FOR_APPLICATION_IN_PHASE_ERROR_IS, new Object[]{applicationName, "commitRuntimeChanges()", ((Throwable)((Object)e)).toString()}, (Throwable)((Object)e));
        }
        return info;
    }
}

