/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainer;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DeployAction
extends ActionBase {
    public DeployAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public ApplicationDeployInfo deploy(File[] archiveFilesFromDeploy, ContainerDeploymentInfo dInfo, Properties props, String[] addedAliases) throws DeploymentException {
        Vector warnings = new Vector();
        String[] allAliases = this.getAliases(dInfo.getApplicationName(), props);
        Configuration appConfig = dInfo.getConfiguration();
        Configuration sevlet_jspConfig = null;
        Configuration sevlet_jspUpdate = null;
        try {
            sevlet_jspConfig = appConfig.createSubConfiguration(this.containerInfo.getName());
        }
        catch (ConfigurationException ce) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Exception occured in createSubConfiguration() method of application " + dInfo.getApplicationName() + ".", (Throwable)((Object)ce), "");
            throw new WebDeploymentException(WebDeploymentException.EXCEPTION_OCCURED_IN_METHOD_FOR_APPLICATION, new Object[]{"createSubConfiguration()", dInfo.getApplicationName()}, (Throwable)((Object)ce));
        }
        try {
            sevlet_jspUpdate = sevlet_jspConfig.createSubConfiguration("update");
        }
        catch (ConfigurationException ce) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Exception occured in createSubConfiguration() method of application " + dInfo.getApplicationName() + ".", (Throwable)((Object)ce), "");
            throw new WebDeploymentException(WebDeploymentException.EXCEPTION_OCCURED_IN_METHOD_FOR_APPLICATION, new Object[]{"createSubConfiguration()", dInfo.getApplicationName()}, (Throwable)((Object)ce));
        }
        try {
            sevlet_jspUpdate.addConfigEntry("FILE_COUNTER", "1");
        }
        catch (NameAlreadyExistsException e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Entry with key FILE_COUNTER already exsits.", (Throwable)((Object)e), "");
        }
        catch (ConfigurationException e) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_ADD_CONFIGURATION_ENTRY_WITH_KEY, new Object[]{"FILE_COUNTER"}, (Throwable)((Object)e));
        }
        this.storeFailOverToDB(dInfo, sevlet_jspConfig);
        this.storeAltDDToDB(dInfo, sevlet_jspConfig);
        int i = 0;
        while (i < allAliases.length) {
            String warName = props.getProperty("web:" + allAliases[i]);
            int index = this.getIndexForArchive(archiveFilesFromDeploy, warName);
            String alias = ParseUtils.convertAlias((String)allAliases[i]);
            String aliasDir = null;
            aliasDir = alias.equals("/") ? "_default" : alias.replace('/', '/').replace('\\', '/');
            File webApplWorkDir = new File(this.getDeployTempDir(dInfo.getApplicationName()) + File.separator + aliasDir + File.separator);
            webApplWorkDir.mkdir();
            String warFileName = archiveFilesFromDeploy[index].getName();
            File warFile = new File(webApplWorkDir, warFileName);
            File tempWarFile = new File(webApplWorkDir, "temp_" + warFileName);
            try {
                this.copyFile(archiveFilesFromDeploy[index], tempWarFile);
            }
            catch (IOException io) {
                throw new WebDeploymentException(WebDeploymentException.CANNOT_COPY_FILE_IN_WORK_FOLDER_OF_APPLICATION, new Object[]{archiveFilesFromDeploy[index].getPath(), dInfo.getApplicationName()}, io);
            }
            this.extractWar(dInfo.getApplicationName(), aliasDir, tempWarFile);
            if (!tempWarFile.renameTo(warFile)) {
                Log.getCategory(1).logError(WebContainer.currentLocation, "Error while renaming war file!", dInfo.getApplicationName());
                throw new WebDeploymentException("servlet_jsp_0297", new Object[]{"temp_" + warFileName, dInfo.getApplicationName()});
            }
            try {
                this.store2DBase(warFile, aliasDir, sevlet_jspConfig);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                throw new WebDeploymentException(WebDeploymentException.CANNOT_STORE_FILE_FROM_APPLICATION_IN_DATABASE, new Object[]{warFile.getPath(), dInfo.getApplicationName()}, e);
            }
            warnings = this.servletsAndJsp.deploy(dInfo.getApplicationName(), alias, appConfig, addedAliases);
            this.checkAliasInHttp(dInfo.getApplicationName(), allAliases[i]);
            ++i;
        }
        ApplicationDeployInfo info = new ApplicationDeployInfo();
        info.setDeployedComponentNames(allAliases);
        info.addFilesForClassloader(this.getFilesForClassPath(dInfo.getApplicationName(), allAliases));
        info.setDeployProperties(props);
        int i2 = 0;
        while (i2 < allAliases.length) {
            Properties resourceRef = null;
            resourceRef = (Properties)ActionBase.mapAliasResourceRef.get(allAliases[i2]);
            if (resourceRef != null) {
                Enumeration en = ((Hashtable)resourceRef).keys();
                while (en.hasMoreElements()) {
                    String resourceName = (String)en.nextElement();
                    String resourceType = resourceRef.getProperty(resourceName);
                    info.addResourceReference(resourceName, resourceType);
                }
                ActionBase.mapAliasResourceRef.remove(allAliases[i2]);
            }
            ++i2;
        }
        if (warnings != null && warnings.size() != 0) {
            info.addWarning(warnings.toString());
        }
        return info;
    }

    public void deploy(File[] archiveFilesFromDeploy, String appName, Properties props, String[] addedAliases) throws DeploymentException {
        String[] allAliases = this.getAliases(appName, props);
        int i = 0;
        while (i < allAliases.length) {
            String warName = props.getProperty("web:" + allAliases[i]);
            int index = this.getIndexForArchive(archiveFilesFromDeploy, warName);
            String alias = ParseUtils.convertAlias((String)allAliases[i]);
            String aliasDir = null;
            aliasDir = alias.equals("/") ? "_default" : alias.replace('/', '/').replace('\\', '/');
            File webApplWorkDir = new File(this.getDeployTempDir(appName) + File.separator + aliasDir + File.separator);
            webApplWorkDir.mkdir();
            String warFileName = archiveFilesFromDeploy[index].getName();
            File warFile = new File(webApplWorkDir, warFileName);
            File tempWarFile = new File(webApplWorkDir, "temp_" + warFileName);
            try {
                this.copyFile(archiveFilesFromDeploy[index], tempWarFile);
            }
            catch (IOException io) {
                throw new WebDeploymentException(WebDeploymentException.CANNOT_COPY_FILE_IN_WORK_FOLDER_OF_APPLICATION, new Object[]{archiveFilesFromDeploy[index].getPath(), appName}, io);
            }
            this.extractWar(appName, aliasDir, tempWarFile);
            if (!tempWarFile.renameTo(warFile)) {
                Log.getCategory(1).logError(WebContainer.currentLocation, "Error while renaming war file!", appName);
                throw new WebDeploymentException("servlet_jsp_0297", new Object[]{"temp_" + warFileName, appName});
            }
            ++i;
        }
    }

    public void commitDeploy(String applicationName) throws WarningException {
        String[] allAliases = this.getAliases(applicationName);
        int i = 0;
        while (i < allAliases.length) {
            this.registerAliasInHttp(applicationName, allAliases[i]);
            ++i;
        }
        try {
            this.runtimeInterface.update(applicationName);
        }
        catch (RemoteException re) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for deploying " + applicationName + "application. " + re.toString(), applicationName);
        }
        catch (RuntimeException runtimeEx) {
            Log.getCategory(1).logWarning(ActionBase.currentLocation, "Cannot notify for deploying " + applicationName + "application. " + runtimeEx.toString(), applicationName);
        }
    }

    private int getIndexForArchive(File[] archiveFilesFromDeploy, String warName) throws DeploymentException {
        int i = 0;
        while (i < archiveFilesFromDeploy.length) {
            if (archiveFilesFromDeploy[i].getName().equals(warName)) {
                return i;
            }
            ++i;
        }
        throw new WebDeploymentException(WebDeploymentException.INCORRECT_PROPERTIES_FOR_DEPLOY_CANNOT_FIND_WAR_ARCHIVE_WITH_NAME, new Object[]{warName});
    }
}

