/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.io.File;
import java.util.Enumeration;
import org.w3c.dom.Document;

public class ContainerInfoAction
extends ActionBase {
    public ContainerInfoAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
    }

    public ExportInfo[] getCurrentStatus(String applicationName) {
        ExportInfo[] infos = null;
        ApplicationContext scf = null;
        String xmlFile = null;
        Enumeration en = SBasic.startedWebApplications.elements();
        while (en.hasMoreElements()) {
            scf = (ApplicationContext)en.nextElement();
            if (scf == null || !scf.getApplicationName().equals(applicationName)) continue;
            if (infos == null || infos.length == 0) {
                infos = new ExportInfo[1];
            } else {
                ExportInfo[] temp = new ExportInfo[infos.length + 1];
                System.arraycopy(infos, 0, temp, 0, infos.length);
                infos = temp;
            }
            infos[infos.length - 1] = new ExportInfo();
            infos[infos.length - 1].setComponentName(scf.getAliasName());
            infos[infos.length - 1].setType((byte)2);
            xmlFile = scf.getWebApplicationRootDir() + "WEB-INF" + File.separator + "web.xml";
            if (!new File(xmlFile).isFile()) continue;
            infos[infos.length - 1] = this.getProperties(xmlFile, infos[infos.length - 1]);
        }
        return infos;
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException {
        try {
            Configuration servlet_jspConfig = appConfig.getSubConfiguration(this.containerInfo.getName());
            Configuration servlet_jspUpdate = servlet_jspConfig.getSubConfiguration("update");
            this.loadFromDBase(applicationName, servlet_jspConfig);
            this.loadUpdatesFromDBase(applicationName, servlet_jspUpdate);
            this.createWorkDirectories(applicationName);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_DOWNLOAD_THE_INFORMATION_OF_THE_APPLICATION_FROM_DATABASE, new Object[]{applicationName}, e);
        }
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return this.getFilesForClassPath(applicationName, SBasic.deployCommunicator.getAliases(applicationName));
    }

    private ExportInfo getProperties(String xmlFile, ExportInfo info) {
        WebDeploymentDescriptor webDesc = null;
        try {
            WebDescriptorDocument doc = new WebDescriptorDocument();
            StandardDOMParser parser = new StandardDOMParser();
            Document parsed = parser.parse(xmlFile);
            webDesc = doc.loadDescriptorFromDocument(parsed);
            if (webDesc != null) {
                info.setEJBeanReferences(webDesc.getEjbRefs());
                info.setResourceReferences(webDesc.getResReferences());
                info.setEnvironmentEntries(webDesc.getEnvEntries());
                info.setSecurityRoles(webDesc.getSecRoles());
                info.setContextParams(webDesc.getContextParams());
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(ActionBase.currentLocation, "Error in setting the export info for the application.", e, "");
        }
        return info;
    }

    private void createWorkDirectories(String applicationName) throws DeploymentException {
        String[] aliases = SBasic.deployCommunicator.getAliases(applicationName);
        String deployDir = this.getDeployTempDir(applicationName);
        int i = 0;
        while (i < aliases.length) {
            String aliasDir = ParseUtils.convertAlias((String)aliases[i]);
            aliasDir = aliasDir.equals("/") ? "_default" : aliasDir.replace('/', '/').replace('\\', '/');
            File f = new File(deployDir + "/" + aliasDir + "/" + "work" + "/");
            if (!f.exists()) {
                f.mkdirs();
            }
            ++i;
        }
    }
}

