/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.TagLib;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibDescriptorDocument;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibraryInfoImpl;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibraryValidatorDescriptor;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.ServletNotFoundException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebResourceAccessor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.jsp.JSPCompiler;
import com.sap.engine.services.servlets_jsp.server.jsp.JSPParser;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.WebApplicationConfig;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import org.w3c.dom.Document;

public class ApplicationThreadInitializer
implements Runnable {
    private CountDown cd = null;
    private WebApplicationConfig webAppConfig = null;
    private ClassLoader threadLoader = null;
    private ApplicationContext scf = null;
    private Vector warnings = new Vector();
    private String[][] allServlets = null;
    private Thread currentThread = null;
    private Throwable exceptionDuringInit = null;
    private JSPParser jspParser = null;
    private ConcurrentHashMapIntObject compile = new ConcurrentHashMapIntObject();
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadInitializer == null ? (class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadInitializer = ApplicationThreadInitializer.class$("com.sap.engine.services.servlets_jsp.server.container.ApplicationThreadInitializer")) : class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadInitializer));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadInitializer;

    public ApplicationThreadInitializer(CountDown cd, WebApplicationConfig webDesc, ClassLoader thLoader, ApplicationContext scf, String[][] allServlets) {
        this.cd = cd;
        this.webAppConfig = webDesc;
        this.threadLoader = thLoader;
        this.scf = scf;
        this.allServlets = allServlets;
        this.jspParser = new JSPParser(scf);
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public Throwable getException() {
        return this.exceptionDuringInit;
    }

    /*
     * Loose catch block
     */
    public void run() {
        ResourceContext resourceContext = null;
        resourceContext = this.scf.enterResourceContext();
        this.currentThread = Thread.currentThread();
        this.threadLoader = this.currentThread.getContextClassLoader();
        this.currentThread.setContextClassLoader(this.scf.getClassLoader());
        HashMapObjectObject listenersFromTagLib = this.parseTagLibListaners();
        this.processTldJars(listenersFromTagLib, this.currentThread, this.threadLoader);
        this.loadFilters();
        this.loadListeners();
        this.loadTagLibListeners(listenersFromTagLib);
        this.loadServlets();
        this.compileJspFiles();
        this.scf.getWebEvents().contextInitialized();
        Object var6_4 = null;
        try {
            try {
                this.currentThread.setContextClassLoader(this.threadLoader);
                this.scf.exitResourceContext(resourceContext);
            }
            catch (Exception e2) {
                Log.getCategory(1).logError(this.currentLocation, "Error in finalizing resources after service stop.", e2, this.scf.getAliasName());
                Object var9_8 = null;
                this.cd.release();
            }
            Object var9_7 = null;
            this.cd.release();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cd.release();
            throw throwable;
        }
        {
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(this.currentLocation, "Error while deploying!", e, this.scf.getAliasName());
                this.exceptionDuringInit = new WebDeploymentException(WebDeploymentException.ERROR_IN_STARTING_APPLICATION, new Object[]{this.scf.getAliasName()}, e);
                Object var6_5 = null;
                try {
                    try {
                        this.currentThread.setContextClassLoader(this.threadLoader);
                        this.scf.exitResourceContext(resourceContext);
                    }
                    catch (Exception e2) {
                        Log.getCategory(1).logError(this.currentLocation, "Error in finalizing resources after service stop.", e2, this.scf.getAliasName());
                        Object var9_11 = null;
                        this.cd.release();
                    }
                    Object var9_10 = null;
                    this.cd.release();
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this.cd.release();
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                try {
                    this.currentThread.setContextClassLoader(this.threadLoader);
                    this.scf.exitResourceContext(resourceContext);
                }
                catch (Exception e2) {
                    Log.getCategory(1).logError(this.currentLocation, "Error in finalizing resources after service stop.", e2, this.scf.getAliasName());
                    Object var9_14 = null;
                    this.cd.release();
                }
                Object var9_13 = null;
                this.cd.release();
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                this.cd.release();
                throw throwable2;
            }
            throw throwable;
        }
    }

    private void processTldJars(HashMapObjectObject listenersFromTagLib, Thread currentThread, ClassLoader threadLoader) {
        File lib = new File(this.scf.getWebApplicationRootDir() + "WEB-INF" + File.separator + "lib");
        if (lib.exists() && lib.isDirectory()) {
            File[] list = lib.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].getName().toLowerCase().endsWith(".jar")) {
                    try {
                        this.processTldJar(new JarFile(list[i]), listenersFromTagLib, currentThread, threadLoader);
                    }
                    catch (OutOfMemoryError e) {
                        throw e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Log.getCategory(1).logError(this.currentLocation, "Error parsing tag library descriptors from jar files!", e, this.scf.getAliasName());
                    }
                }
                ++i;
            }
        }
    }

    private void processTldJar(JarFile jarFile, HashMapObjectObject listenersFromTagLib, Thread currentThread, ClassLoader threadLoader) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            try {
                TagLibraryValidatorDescriptor validatorDesc;
                Object var12_16;
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                TagLibDescriptorDocument tagLibDoc = new TagLibDescriptorDocument(this.scf.getClassLoader());
                currentThread.setContextClassLoader(threadLoader);
                Document parsed = null;
                try {
                    StandardDOMParser parser = new StandardDOMParser();
                    parsed = parser.parse(jarFile.getInputStream(entry));
                    var12_16 = null;
                    currentThread.setContextClassLoader(this.scf.getClassLoader());
                }
                catch (Throwable throwable) {
                    var12_16 = null;
                    currentThread.setContextClassLoader(this.scf.getClassLoader());
                    throw throwable;
                }
                TagLibraryInfoImpl t = (TagLibraryInfoImpl)tagLibDoc.loadDescriptorFromDocument(parsed);
                if (t == null || t.getURI() == null) continue;
                String[] listenersTL = t.getListeners();
                if (listenersTL != null) {
                    int j = 0;
                    while (j < listenersTL.length) {
                        listenersFromTagLib.put(listenersTL[j], listenersTL[j]);
                        ++j;
                    }
                }
                if ((validatorDesc = t.getValidator()) != null) {
                    this.instantiateValidator(t.getURI(), validatorDesc);
                }
                this.scf.getWebComponents().addTagLibraryInfo(t.getURI(), t);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(this.currentLocation, "Error in parsing jar file " + jarFile.getName() + ".", e, this.scf.getAliasName());
            }
        }
    }

    private void instantiateValidator(String uri, TagLibraryValidatorDescriptor validatorDesc) {
        if (validatorDesc.getValidatorClass() != null) {
            try {
                Class<?> validatorClass = this.scf.getClassLoader().loadClass(validatorDesc.getValidatorClass());
                TagLibraryValidator t = (TagLibraryValidator)validatorClass.newInstance();
                this.scf.getWebComponents().addTagLibraryValidator(uri, t);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(this.currentLocation, "Cannot instantiate taglib validator " + uri + ".", e, this.scf.getAliasName());
            }
        }
    }

    private HashMapObjectObject getFilterInitParameters(ContextParam[] params) {
        HashMapObjectObject initParams = new HashMapObjectObject();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                initParams.put(params[i].getParamName(), params[i].getParamValue());
                ++i;
            }
        }
        return initParams;
    }

    private HashMapObjectObject parseTagLibListaners() {
        HashMapObjectObject tagLibListeners = new HashMapObjectObject();
        TagLib[] tagLib = this.webAppConfig.getTagLibs();
        if (tagLib == null) {
            return tagLibListeners;
        }
        int i = 0;
        while (i < tagLib.length) {
            this.currentThread.setContextClassLoader(this.threadLoader);
            TagLibDescriptorDocument tagLibDoc = new TagLibDescriptorDocument(this.scf.getClassLoader());
            try {
                StandardDOMParser parser = new StandardDOMParser();
                Document parsed = null;
                if (tagLib[i].getLocation() != null) {
                    if (tagLib[i].getLocation().startsWith("/WEB-INF/") && tagLib[i].getLocation().toUpperCase().endsWith(".JAR")) {
                        ZipFile zipFile = new ZipFile(this.scf.getWebApplicationRootDir() + tagLib[i].getLocation());
                        ZipEntry zipEntry = zipFile.getEntry("META-INF/taglib.tld");
                        InputStream inZip = zipFile.getInputStream(zipEntry);
                        parsed = parser.parse(inZip);
                    } else {
                        parsed = parser.parse(this.scf.getWebApplicationRootDir() + tagLib[i].getLocation());
                    }
                    this.currentThread.setContextClassLoader(this.scf.getClassLoader());
                    TagLibraryInfoImpl t = (TagLibraryInfoImpl)tagLibDoc.loadDescriptorFromDocument(parsed);
                    if (tagLib[i].getUri() != null && t != null) {
                        TagLibraryValidatorDescriptor validatorDesc;
                        String[] listenersTL = t.getListeners();
                        if (listenersTL != null) {
                            int j = 0;
                            while (j < listenersTL.length) {
                                tagLibListeners.put(listenersTL[j], listenersTL[j]);
                                ++j;
                            }
                        }
                        if ((validatorDesc = t.getValidator()) != null) {
                            this.instantiateValidator(tagLib[i].getUri(), validatorDesc);
                        }
                        this.scf.getWebComponents().addTagLibraryInfo(tagLib[i].getUri(), t);
                    }
                }
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(this.currentLocation, "Error parsing a tag library descriptor.", e, this.scf.getAliasName());
                this.warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.ERROR_IN_TAGLIB_TAG_IN_WEBXML_CANNOT_LOCATE_OR_PARSE_IT, new Object[]{tagLib[i].getUri(), e.toString()}));
            }
            ++i;
        }
        return tagLibListeners;
    }

    private void loadFilters() {
        FilterDescriptor[] filterDesc = this.webAppConfig.getFilters();
        if (filterDesc == null) {
            return;
        }
        int i = 0;
        while (i < filterDesc.length) {
            Vector filterWarnings;
            if (filterDesc[i].getName() != null && filterDesc[i].getFilterClass() != null && (filterWarnings = this.scf.getWebComponents().addFilter(filterDesc[i].getName(), filterDesc[i].getFilterClass(), this.getFilterInitParameters(filterDesc[i].getInitParams()))) != null && filterWarnings.size() > 0) {
                Enumeration en = filterWarnings.elements();
                while (en.hasMoreElements()) {
                    this.warnings.add(en.nextElement());
                }
            }
            ++i;
        }
    }

    private void loadListeners() {
        Vector listnerWarnings = new Vector();
        String[] listenerNames = this.webAppConfig.getListeners();
        if (listenerNames != null) {
            Class<?> listenerClass = null;
            int i = 0;
            while (i < listenerNames.length) {
                try {
                    listenerClass = this.scf.getClassLoader().loadClass(listenerNames[i]);
                    listnerWarnings = this.scf.getWebComponents().addListener(listenerClass.newInstance());
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logError(this.currentLocation, "Cannot load listener " + listenerNames[i], e, this.scf.getAliasName());
                    this.warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_LOAD_LISTENER, new Object[]{listenerNames[i], e.toString()}));
                }
                ++i;
            }
            if (listnerWarnings != null && listnerWarnings.size() > 0) {
                Enumeration en = listnerWarnings.elements();
                while (en.hasMoreElements()) {
                    this.warnings.add(en.nextElement());
                }
            }
        }
    }

    private void loadTagLibListeners(HashMapObjectObject listenersFromTagLib) {
        Vector listnerWarnings = new Vector();
        if (listenersFromTagLib.size() > 0) {
            Class<?> listenerClass = null;
            Enumeration en = listenersFromTagLib.elements();
            while (en.hasMoreElements()) {
                try {
                    listenerClass = this.scf.getClassLoader().loadClass((String)en.nextElement());
                    listnerWarnings = this.scf.getWebComponents().addListener(listenerClass.newInstance());
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logError(this.currentLocation, "Cannot load taglib listener " + listenerClass + ".", e, this.scf.getAliasName());
                }
                if (listnerWarnings == null || listnerWarnings.size() <= 0) continue;
                Enumeration enWarnings = listnerWarnings.elements();
                while (enWarnings.hasMoreElements()) {
                    this.warnings.add(enWarnings.nextElement());
                }
            }
        }
    }

    private void loadServlets() {
        if (this.allServlets != null) {
            int i = 0;
            while (i < this.allServlets.length) {
                block9: {
                    Vector servletWarnings;
                    String servletName = this.allServlets[i][1];
                    String servletClass = this.allServlets[i][2];
                    boolean isJsp = servletClass.endsWith(".jsp");
                    if (isJsp) {
                        try {
                            servletClass = this.getClassName(servletClass);
                            if (servletClass == null) break block9;
                            Log.getLocation(3).traceInfo("Jsp < " + servletClass + " > parsed succesfully", this.scf.getAliasName());
                        }
                        catch (OutOfMemoryError e) {
                            throw e;
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            Log.getCategory(1).logError(this.currentLocation, "Error can't parse jsp  " + servletClass, e, this.scf.getAliasName());
                            this.warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_PARSE_JSP_ERROR_IS, new Object[]{servletClass, e.toString()}));
                        }
                    }
                    if ((servletWarnings = this.scf.getWebComponents().addServlet(servletName, servletClass, isJsp)).size() > 0) {
                        Enumeration en = servletWarnings.elements();
                        while (en.hasMoreElements()) {
                            this.warnings.add(en.nextElement());
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void compileJspFiles() {
        if (SBasic.webContainerProperties.compileOnStartup()) {
            new JSPCompiler(this.scf, this.scf.getWebApplicationRootDir()).start();
        }
    }

    private String getClassName(String jspFile) throws ServletException, ServletNotFoundException, IOException {
        jspFile = this.scf.getServletContext().getRealPath(jspFile).replace(File.separatorChar, '/');
        File f = new File(jspFile);
        if (!f.exists() || f.isDirectory()) {
            this.warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), "servlet_jsp_0233", new Object[]{jspFile}));
            return null;
        }
        int hash = jspFile.hashCode();
        long fLastModified = f.lastModified();
        String className = this.compileAndGetClassName(jspFile, fLastModified, hash);
        return className;
    }

    private String compileAndGetClassName(String jspFile, long fLastModified, int hash) throws ServletException, ServletNotFoundException, IOException {
        block23: {
            File file = null;
            String classNamesKey = jspFile.substring(this.scf.getWebApplicationRootDir().length() - 1);
            Object objectJspFile = this.scf.getClassNamesHashtable().get(classNamesKey);
            if (objectJspFile != null) {
                String pathname = this.scf.getWorkingDir() + objectJspFile + ".java";
                file = new File(pathname);
            }
            try {
                if (file != null && file.lastModified() >= fLastModified) {
                    return this.getClassName(this.scf, jspFile, objectJspFile == null);
                }
                throw new Exception();
            }
            catch (Exception e) {
                block24: {
                    Object object;
                    String string;
                    boolean fl = false;
                    ApplicationThreadInitializer applicationThreadInitializer = this;
                    synchronized (applicationThreadInitializer) {
                        if (this.compile.get(hash) == null) {
                            this.compile.put(hash, new Object());
                            fl = true;
                        }
                    }
                    if (!fl) break block24;
                    try {
                        string = this.getClassName(this.scf, jspFile, true);
                        Object var13_14 = null;
                        object = this.compile.get(hash);
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        Object object2 = this.compile.get(hash);
                        synchronized (object2) {
                            Object obj = this.compile.get(hash);
                            this.compile.remove(hash);
                            obj.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        Object obj = this.compile.get(hash);
                        this.compile.remove(hash);
                        obj.notifyAll();
                    }
                    return string;
                }
                if (this.compile.get(hash) == null) break block23;
                Object object = this.compile.get(hash);
                synchronized (object) {
                    long startTime = System.currentTimeMillis();
                    long delta = 0L;
                    while (this.compile.get(hash) != null && delta < 60000L) {
                        try {
                            Log.getLocation(3).traceDebug("JSP file <" + jspFile + "> is compiling by another client!\r\nWaiting while the file is compiled.", this.scf.getAliasName());
                            this.compile.get(hash).wait(60000L);
                        }
                        catch (OutOfMemoryError ex) {
                            throw ex;
                        }
                        catch (ThreadDeath ex) {
                            throw ex;
                        }
                        catch (Throwable ex) {
                            Log.getCategory(1).logError(this.currentLocation, "Thread interrupted while waiting for the jsp to be compiled. Synchronization may fail.", ex, this.scf.getAliasName());
                        }
                        delta = System.currentTimeMillis() - startTime;
                    }
                }
            }
        }
        return this.getClassName(this.scf, jspFile, false);
    }

    private String getClassName(ApplicationContext context, String jspFile, boolean needCompiling) throws ServletException, ServletNotFoundException, IOException {
        if (!needCompiling) {
            String classNamesKey = jspFile.substring(context.getWebApplicationRootDir().length() - 1);
            return (String)context.getClassNamesHashtable().get(classNamesKey);
        }
        return this.jspParser.parse(jspFile, null, true, this.threadLoader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

