/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.SecuritySessionException;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;

public class ApplicationThreadDestroyer
implements Runnable {
    private ApplicationContext scf = null;
    private CountDown cd = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadDestroyer == null ? (class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadDestroyer = ApplicationThreadDestroyer.class$("com.sap.engine.services.servlets_jsp.server.container.ApplicationThreadDestroyer")) : class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadDestroyer));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$container$ApplicationThreadDestroyer;

    public ApplicationThreadDestroyer(CountDown cd, ApplicationContext scf) {
        this.scf = scf;
        this.cd = cd;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadLoader = currentThread.getContextClassLoader();
        ResourceContext resourceContext = null;
        try {
            currentThread.setContextClassLoader(this.scf.getClassLoader());
            Log.getLocation(3).traceInfo("Start destroying web components!", this.scf.getAliasName());
            resourceContext = this.scf.enterResourceContext();
            Log.getLocation(3).traceInfo("Start destroying servlets ...", this.scf.getAliasName());
            this.scf.getWebComponents().destroyServlets();
            Log.getLocation(3).traceInfo("Servlets successfully destroyed!", this.scf.getAliasName());
            Log.getLocation(3).traceInfo("Start destroying jsp servlets ...", this.scf.getAliasName());
            this.scf.getWebComponents().destroyJsps();
            Log.getLocation(3).traceInfo("Jsp servlets successfully destroyed!", this.scf.getAliasName());
            Log.getLocation(3).traceInfo("Start destroying filters ...", this.scf.getAliasName());
            this.scf.getWebComponents().destroyFilters();
            Log.getLocation(3).traceInfo("Filters successfully destroyed!", this.scf.getAliasName());
            Log.getLocation(3).traceInfo("Start destroying http sessions ...", this.scf.getAliasName());
            this.scf.getWebEvents().sessionsWillPassivate(this.scf.getSessionServletContext().getSession());
            this.serializeSessions();
            this.removeSecuritySessions();
            Log.getLocation(3).traceInfo("Http sessions successfully destroyed!", this.scf.getAliasName());
            this.scf.getWebEvents().contextDestroyed();
            Log.getLocation(3).traceInfo("Web components destroyed!", this.scf.getAliasName());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                try {
                    currentThread.setContextClassLoader(threadLoader);
                    this.scf.exitResourceContext(resourceContext);
                }
                catch (Exception e) {
                    Log.getCategory(1).logError(this.currentLocation, "Error in finalizing resources in starting application.", e, this.scf.getAliasName());
                    Object var8_10 = null;
                    this.cd.release();
                }
                Object var8_9 = null;
                this.cd.release();
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                this.cd.release();
                throw throwable2;
            }
            throw throwable;
        }
        try {
            try {
                currentThread.setContextClassLoader(threadLoader);
                this.scf.exitResourceContext(resourceContext);
            }
            catch (Exception e) {
                Log.getCategory(1).logError(this.currentLocation, "Error in finalizing resources in starting application.", e, this.scf.getAliasName());
                Object var8_7 = null;
                this.cd.release();
            }
            Object var8_6 = null;
            this.cd.release();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cd.release();
            throw throwable;
        }
    }

    private void serializeSessions() {
        if (SBasic.failoverPersistentStorage != null) {
            String applicationName = this.scf.getAliasForDirectory();
            Hashtable sessions = this.scf.getSessionServletContext().getSession();
            Enumeration en = sessions.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object appSession = sessions.get(key);
                try {
                    if (Log.isTracing()) {
                        Log.getLocation(7).traceInfo("ApplicationSession.serializeSession [" + key + "] in application [" + applicationName + "].", applicationName);
                    }
                    SBasic.failoverPersistentStorage.serializeSession(applicationName, key, appSession, ((ApplicationSession)appSession).getMaxInactiveInterval() * 1000);
                }
                catch (PersistentStorageException ex) {
                    ((ApplicationSession)appSession).invalidate();
                }
            }
        }
    }

    private void removeSecuritySessions() {
        Enumeration sessEn = this.scf.getSessionServletContext().getSession().elements();
        while (sessEn.hasMoreElements()) {
            try {
                this.scf.getSessionServletContext().getPolicyDomain().removeMe((ApplicationSession)sessEn.nextElement());
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(2).logError(this.currentLocation, "Error in removing a security session in stopping the application.", e, this.scf.getAliasName());
            }
        }
        try {
            SBasic.webContainerPolicy.destroyDomain(this.scf.getWebApplicationConfiguration().getDomainName(), this.scf.getAliasName());
        }
        catch (SecuritySessionException se) {
            Log.getCategory(4).logError(this.currentLocation, "Error in destroying security sessions.", se, this.scf.getAliasName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

