/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.container;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.servlets_jsp.ServletAndJspRuntimeInterface;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.container.ActionBase;
import com.sap.engine.services.servlets_jsp.server.container.WebContainerHelper;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import java.util.StringTokenizer;

public class AppInfoAction
extends ActionBase {
    private ConfigurationHandlerFactory configurationFactory = null;

    public AppInfoAction(ContainerInfo containerInfo, WebContainerHelper servletsAndJsp, ServletAndJspRuntimeInterface runtimeInterface, ConfigurationHandlerFactory configurationFactory) {
        super(containerInfo, servletsAndJsp, runtimeInterface);
        this.configurationFactory = configurationFactory;
    }

    /*
     * Loose catch block
     */
    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        boolean returnValue;
        block13: {
            ConfigurationHandler handler;
            block12: {
                String[] aliases = SBasic.deployCommunicator.getAliases(appName);
                if (aliases == null || aliases.length == 0) {
                    return false;
                }
                returnValue = true;
                handler = null;
                handler = this.configurationFactory.getConfigurationHandler();
                Configuration appsConfig = handler.openConfiguration("apps", 0);
                StringTokenizer strTokenizer = new StringTokenizer(appName, "\\/");
                int numTokens = strTokenizer.countTokens();
                String token = null;
                int i = 0;
                while (i < numTokens) {
                    token = strTokenizer.nextToken();
                    appsConfig = appsConfig.getSubConfiguration(token);
                    ++i;
                }
                String failoverMode = (String)(appsConfig = appsConfig.getSubConfiguration("servlet_jsp")).getConfigEntry("failOver");
                if (failoverMode == null || addAppInfo.getFailOverValue() == null || !failoverMode.equals(addAppInfo.getFailOverValue())) break block12;
                returnValue = false;
            }
            Object var13_15 = null;
            try {
                handler.closeAllConfigurations();
            }
            catch (ConfigurationException ex) {
                Log.getCategory(1).logError(ActionBase.currentLocation, "Error while reading the old value for fialover during changing its value", (Throwable)((Object)ex), appName);
                returnValue = false;
            }
            break block13;
            {
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable ce) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Error while reading the old value for fialover during changing its value", ce, appName);
                    returnValue = false;
                    Object var13_16 = null;
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException ex) {
                        Log.getCategory(1).logError(ActionBase.currentLocation, "Error while reading the old value for fialover during changing its value", (Throwable)((Object)ex), appName);
                        returnValue = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    handler.closeAllConfigurations();
                }
                catch (ConfigurationException ex) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Error while reading the old value for fialover during changing its value", (Throwable)((Object)ex), appName);
                    returnValue = false;
                }
                throw throwable;
            }
        }
        return returnValue;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws DeploymentException {
        block13: {
            try {
                Configuration servlet_jspConfiguration = configuration.getSubConfiguration(this.containerInfo.getName());
                if (servlet_jspConfiguration == null) {
                    throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_CONFIGURATION_FOR_APPLICATION, new Object[]{appName});
                }
                String originalFailover = (String)servlet_jspConfiguration.getConfigEntry("failOver");
                if (originalFailover.equals(addAppInfo.getFailOverValue())) break block13;
                String[] aliases = SBasic.deployCommunicator.getAliases(appName);
                int i = 0;
                while (i < aliases.length) {
                    try {
                        if (SBasic.failoverPersistentStorage != null) {
                            SBasic.failoverPersistentStorage.deleteAllSessions(aliases[i]);
                        } else {
                            Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot remove serialized sessions of " + aliases[i] + " web application of " + appName + " application, while changing fialover property to false. The failover service is not available.", aliases[i]);
                        }
                    }
                    catch (PersistentStorageException e) {
                        Log.getCategory(1).logError(ActionBase.currentLocation, "Cannot remove serialized sessions of " + aliases[i] + " web application of " + appName + " application, while changing fialover property to false.", e, appName);
                    }
                    ++i;
                }
                try {
                    servlet_jspConfiguration.addConfigEntry("failOver", addAppInfo.getFailOverValue());
                }
                catch (NameAlreadyExistsException e) {
                    try {
                        servlet_jspConfiguration.modifyConfigEntry("failOver", addAppInfo.getFailOverValue());
                    }
                    catch (ConfigurationException e1) {
                        Log.getCategory(1).logError(ActionBase.currentLocation, "Entry with key failOver already exsits and cannot overwriet it. May be no write access.", (Throwable)((Object)e1), "");
                    }
                }
                catch (ConfigurationException e) {
                    Log.getCategory(1).logError(ActionBase.currentLocation, "Entry with key failOver already exsits.", (Throwable)((Object)e), "");
                }
            }
            catch (ConfigurationException ce) {
                throw new WebDeploymentException(WebDeploymentException.CONFIGURATION_ERROR_WHILE_UPDATING_RUNTIME_PROPERTY_OF_APPLICATION, new Object[]{appName}, (Throwable)((Object)ce));
            }
        }
    }
}

