/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class MultipartPart {
    private static final String form_data = "form-data";
    protected int size = -1;
    private String contentType = null;
    private String characterEncoding = null;
    private boolean contentTypeParsed = false;
    private String disposition = null;
    private boolean dispositionParsed = false;
    private String fileName = null;
    private String name = null;
    private boolean isFormParameter = false;
    private boolean isFormParameterParsed = false;
    private byte[] body = null;
    protected Hashtable headers = null;

    public int getSize() {
        return this.size;
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.parseContentType();
            this.contentTypeParsed = true;
        }
        return this.contentType;
    }

    public String getDisposition() {
        if (!this.dispositionParsed) {
            this.parseDisposition();
            this.dispositionParsed = true;
        }
        return this.disposition;
    }

    public String getName() {
        if (!this.dispositionParsed) {
            this.parseDisposition();
            this.dispositionParsed = true;
        }
        return this.name;
    }

    public boolean isFormParameter() {
        if (!this.dispositionParsed) {
            this.parseDisposition();
            this.dispositionParsed = true;
        }
        if (!this.isFormParameterParsed) {
            this.parseIsFormParameter();
            this.isFormParameterParsed = true;
        }
        return this.isFormParameter;
    }

    public String getFileName() {
        if (!this.dispositionParsed) {
            this.parseDisposition();
            this.dispositionParsed = true;
        }
        return this.fileName;
    }

    public abstract InputStream getInputStream();

    public byte[] getBody() throws IOException {
        if (this.body != null) {
            return this.body;
        }
        InputStream in = this.getInputStream();
        this.body = new byte[in.available()];
        int offset = 0;
        int read = -1;
        while (offset < this.body.length && (read = in.read(this.body, offset, this.body.length - offset)) != -1) {
            offset += read;
        }
        return this.body;
    }

    public abstract void setText(String var1);

    public abstract void writeTo(OutputStream var1);

    public String getHeader(String headerName) {
        String[] headerValues = this.getHeaderValues(headerName);
        if (headerValues == null || headerValues.length == 0) {
            return null;
        }
        return headerValues[0];
    }

    public String[] getHeaderValues(String headerName) {
        if (this.headers == null) {
            return null;
        }
        return (String[])this.headers.get(headerName);
    }

    public void setHeader(String headerName, String headerValue) {
        if (this.headers == null) {
            this.headers = new Hashtable(3, 3.0f);
        }
        this.headers.put(headerName, new String[]{headerValue});
    }

    public void addHeader(String headerName, String headerValue) {
        String[] oldHeaderValues;
        if (this.headers == null) {
            this.headers = new Hashtable(3, 3.0f);
        }
        if ((oldHeaderValues = (String[])this.headers.get(headerName)) == null || oldHeaderValues.length == 0) {
            this.headers.put(headerName, new String[]{headerValue});
        } else {
            String[] newHeaderValues = new String[oldHeaderValues.length + 1];
            System.arraycopy(oldHeaderValues, 0, newHeaderValues, 0, oldHeaderValues.length);
            newHeaderValues[newHeaderValues.length - 1] = headerValue;
            this.headers.put(headerName, newHeaderValues);
        }
    }

    public void removeHeader(String headerName) {
        if (this.headers != null) {
            this.headers.remove(headerName);
        }
    }

    public Enumeration getAllHeaderNames() {
        return this.headers.keys();
    }

    public String getCharacterEncoding() {
        if (!this.contentTypeParsed) {
            this.parseContentType();
            this.contentTypeParsed = true;
        }
        return this.characterEncoding;
    }

    public String getTransferEncoding() {
        String s = this.getHeader("Content-Transfer-Encoding");
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).equalsIgnoreCase("7bit") || s.equalsIgnoreCase("8bit") || s.equalsIgnoreCase("quoted-printable") || s.equalsIgnoreCase("base64")) {
            return s;
        }
        return s;
    }

    public String getContentID() {
        return this.getHeader("Content-Id");
    }

    private void parseDisposition() {
        this.disposition = this.getHeader("Content-Disposition");
        if (this.disposition == null) {
            return;
        }
        this.disposition = this.disposition.trim();
        int scInd = this.disposition.indexOf(59);
        if (scInd == -1) {
            return;
        }
        if (scInd == this.disposition.length() - 1) {
            this.disposition = this.disposition.substring(0, scInd).trim();
            return;
        }
        String paramString = this.disposition.substring(scInd + 1).trim();
        this.disposition = this.disposition.substring(0, scInd).trim();
        StringTokenizer params = new StringTokenizer(paramString, ";");
        while (params.hasMoreTokens()) {
            String param = params.nextToken();
            int eqInd = param.indexOf(61);
            if (eqInd == -1 || eqInd >= param.length() - 1) continue;
            String paramName = param.substring(0, eqInd).trim();
            String paramValue = param.substring(eqInd + 1).trim();
            if (paramName.equals("name")) {
                this.name = this.unquote(paramValue);
                continue;
            }
            if (!paramName.equals("filename")) continue;
            this.fileName = this.unquote(paramValue);
        }
    }

    private void parseContentType() {
        int charsetLocation;
        this.contentType = this.getHeader("Content-Type");
        if (this.contentType != null && (charsetLocation = this.contentType.indexOf("charset=")) != -1) {
            int end = this.contentType.indexOf(59, charsetLocation);
            if (end == -1) {
                end = this.contentType.length();
            }
            this.characterEncoding = this.contentType.substring(charsetLocation + 8, end - (charsetLocation + 8));
            this.characterEncoding = this.unquote(this.characterEncoding);
        }
    }

    private void parseIsFormParameter() {
        this.isFormParameter = form_data.equalsIgnoreCase(this.getDisposition()) && this.getFileName() == null && this.getName() != null;
    }

    private String unquote(String str) {
        if (str.length() < 2) {
            return str;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        if (str.startsWith("'") && str.endsWith("'")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

