/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax;

import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.DebugInfo;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Element;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Parser;

public class TemplateData
extends Element {
    public static String startTag = "<jsp:text><![CDATA[\n";
    public static String endTag = "\n]]>\n</jsp:text>";
    public static final int MAXSIZE = 32768;
    private boolean constructorCreated;
    private boolean isEmptyFlag = false;

    public TemplateData() {
        this.constructorCreated = true;
    }

    public TemplateData(int start, int end, DebugInfo info) {
        this.startIndex = start;
        this.endIndex = end;
        this.debugInfo = info;
        this.elementType = 0;
        this.constructorCreated = true;
    }

    public void action() {
        this.debugInfo.writeStart(this.parser.getScriptletsCode(), true);
        String s = this.parser.getChars(this.startIndex, this.endIndex);
        s = this.parser.replaceTemplateTextQuotes(s);
        if (s.trim().length() == 0) {
            this.isEmptyFlag = true;
            if (this.parser.isXml) {
                this.debugInfo.writeEnd(this.parser.getScriptletsCode());
                return;
            }
        }
        int mark = 0;
        int from = 0;
        int to = 0;
        int len = s.length();
        if (len > 32768) {
            while (mark < len) {
                from = mark;
                to = Math.min(mark + 32768, len);
                this.chunk(s.substring(from, to));
                mark = to;
            }
        } else {
            this.chunk(s);
        }
        this.debugInfo.writeEnd(this.parser.getScriptletsCode());
    }

    private void chunk(String s) {
        this.parser.getScriptletsCode().append("\t\t\tout.print(\"");
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    this.parser.getScriptletsCode().append("\\b");
                    break;
                }
                case '\t': {
                    this.parser.getScriptletsCode().append("\\t");
                    break;
                }
                case '\r': {
                    this.parser.getScriptletsCode().append("\\r");
                    break;
                }
                case '\n': {
                    this.parser.getScriptletsCode().append("\\n");
                    break;
                }
                case '\f': {
                    this.parser.getScriptletsCode().append("\\f");
                    break;
                }
                case '\'': {
                    this.parser.getScriptletsCode().append("\\'");
                    break;
                }
                case '\"': {
                    this.parser.getScriptletsCode().append("\\\"");
                    break;
                }
                case '\\': {
                    this.parser.getScriptletsCode().append("\\\\");
                    break;
                }
                default: {
                    String s1;
                    if (c > '\u00ff') {
                        s1 = "00" + Integer.toHexString(c);
                        this.parser.getScriptletsCode().append("\\u").append(s1.substring(s1.length() - 4));
                        break;
                    }
                    if (c < ' ' || c >= '\u007f') {
                        s1 = "00" + Integer.toOctalString(c);
                        this.parser.getScriptletsCode().append('\\').append(s1.substring(s1.length() - 3));
                        break;
                    }
                    this.parser.getScriptletsCode().append(c);
                }
            }
            ++i;
        }
        this.parser.getScriptletsCode().append("\");").append("\r\n");
    }

    public char[] indent() {
        return null;
    }

    public Element parse(Parser parser) {
        this.parser = parser;
        if (this.constructorCreated) {
            return this;
        }
        return null;
    }

    public void merge(TemplateData next) {
        this.endIndex = next.endIndex;
        this.debugInfo.end = next.debugInfo.end;
    }

    public boolean isEmpty() {
        return this.isEmptyFlag;
    }

    public String getClearString() {
        String s = this.parser.getChars(this.getStartIndex(), this.getEndIndex()).trim();
        if (s.startsWith("<![CDATA[")) {
            s = s.substring(9, s.length() - 3);
        }
        return s.trim();
    }

    public String getString() {
        return startTag + this.parser.getChars(this.getStartIndex(), this.getEndIndex()) + endTag;
    }
}

