/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax;

import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Element;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.ElementCollection;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.ParserAttributes;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Position;
import com.sap.engine.services.servlets_jsp.lib.jspparser.taglib.TagLibraries;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class Parser {
    protected ClassLoader applicationClassLoader = null;
    protected ClassLoader serviceClassLoader = null;
    protected String rootDirectorty = null;
    protected ConcurrentHashMapObjectObject tagLibDescriptors = null;
    protected ParserAttributes shareAttributes = new ParserAttributes();
    protected int lineNr;
    protected int srcPos;
    protected String src = null;
    protected boolean parsingHtml = false;
    protected Vector begs = new Vector();
    protected Element rootElement = new ElementCollection();
    protected boolean isXml = false;

    public Parser() {
    }

    public Parser(Parser p) {
        this.applicationClassLoader = p.applicationClassLoader;
        this.serviceClassLoader = p.serviceClassLoader;
        this.rootDirectorty = p.rootDirectorty;
        this.src = p.src;
        this.parsingHtml = p.parsingHtml;
        this.begs = p.begs;
        this.rootElement = p.rootElement;
        this.shareAttributes = p.shareAttributes;
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public String getRootDirectorty() {
        return this.rootDirectorty;
    }

    public ConcurrentHashMapObjectObject getTagLibDescriptors() {
        return this.tagLibDescriptors;
    }

    public abstract int currentPos();

    public abstract Position currentDebugPos();

    public abstract String currentFileName();

    public abstract char nextChar();

    public abstract char currentChar();

    public abstract char charAt(int var1);

    public abstract int parseTo(char var1, boolean var2) throws JspParseException;

    public abstract int parseTo(char[] var1, boolean var2) throws JspParseException;

    public abstract int skipWhiteSpace();

    public abstract int skipIndentifier() throws JspParseException;

    public abstract boolean compare(int var1, int var2, char[] var3) throws JspParseException;

    public abstract boolean compareIgnoreCase(int var1, int var2, char[] var3) throws JspParseException;

    public abstract Element getElement();

    public abstract boolean endReached();

    public abstract String getChars(int var1, int var2);

    public abstract String getCharsTrim(int var1, int var2);

    public abstract Element parse(File var1) throws JspParseException;

    protected void clear() {
    }

    public String getException(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(new StringWriter());
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public String firstCap(String old) {
        String firstL = old.substring(0, 1).toUpperCase();
        String newStr = firstL + old.substring(1);
        return newStr;
    }

    public boolean isRuntimeExpr(String expr) {
        return expr.startsWith("<%=") || expr.startsWith("<jsp:expression") || expr.startsWith("%=");
    }

    public String parseRuntimeExpr(String expr) {
        if (((expr = expr.trim()).startsWith("<%=") || expr.startsWith("<jsp:expression") || expr.startsWith("%=")) && (expr.endsWith("%>") || expr.endsWith("/>") || expr.endsWith("%"))) {
            if (expr.startsWith("<%=")) {
                expr = expr.substring("<%=".length());
            } else if (expr.startsWith("<jsp:expression")) {
                expr = expr.substring("<jsp:expression".length());
            } else if (expr.startsWith("%=")) {
                expr = expr.substring("%=".length());
            }
            if (expr.endsWith("%>")) {
                expr = expr.substring(0, expr.length() - "%>".length());
            } else if (expr.endsWith("/>")) {
                expr = expr.substring(0, expr.length() - "/>".length());
            } else if (expr.endsWith("%")) {
                expr = expr.substring(0, expr.length() - "%".length());
            }
        } else {
            expr = "\"".concat(expr).concat("\"");
        }
        return expr;
    }

    public String replaceScriptQuotes(String expr) {
        int pos = -1;
        while ((pos = expr.indexOf("%\\>")) != -1) {
            String temp = expr.substring(0, pos + 1);
            expr = temp + expr.substring(pos + 2);
        }
        return expr;
    }

    public String replaceTemplateTextQuotes(String expr) {
        int pos = -1;
        while ((pos = expr.indexOf("<\\%")) != -1) {
            String temp = expr.substring(0, pos + 1);
            expr = temp + expr.substring(pos + 2);
        }
        return expr;
    }

    public String replaceAttributeQuotes(String expr) {
        String temp;
        int pos = -1;
        while ((pos = expr.indexOf("\\\"")) != -1) {
            temp = expr.substring(0, pos);
            expr = temp + expr.substring(pos + 1);
        }
        while ((pos = expr.indexOf("\\'")) != -1) {
            temp = expr.substring(0, pos);
            expr = temp + expr.substring(pos + 1);
        }
        while ((pos = expr.indexOf("\\\\")) != -1) {
            temp = expr.substring(0, pos);
            expr = temp + expr.substring(pos + 1);
        }
        while ((pos = expr.indexOf("<\\%")) != -1) {
            temp = expr.substring(0, pos + 1);
            expr = temp + expr.substring(pos + 2);
        }
        while ((pos = expr.indexOf("%\\>")) != -1) {
            temp = expr.substring(0, pos + 1);
            expr = temp + expr.substring(pos + 2);
        }
        return expr;
    }

    public boolean getAddIntrospect() {
        return this.shareAttributes.getAddIntrospect();
    }

    public void setAddIntrospect(boolean addIntrospect) {
        this.shareAttributes.setAddIntrospect(addIntrospect);
    }

    public Hashtable getAllBeanNames() {
        return this.shareAttributes.getAllBeanNames();
    }

    public void setAllBeanNames(Hashtable allBeanNames) {
        this.shareAttributes.setAllBeanNames(allBeanNames);
    }

    public boolean getAutoFlush() {
        return this.shareAttributes.getAutoFlush();
    }

    public void setAutoFlush(boolean autoFlush) {
        this.shareAttributes.setAutoFlush(autoFlush);
    }

    public StringBuffer getBeanCode() {
        return this.shareAttributes.getBeanCode();
    }

    public void setBeanCode(StringBuffer beanCode) {
        this.shareAttributes.setBeanCode(beanCode);
    }

    public Hashtable getBeanId() {
        return this.shareAttributes.getBeanId();
    }

    public void setBeanId(Hashtable beanId) {
        this.shareAttributes.setBeanId(beanId);
    }

    public int getBufferSize() {
        return this.shareAttributes.getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        this.shareAttributes.setBufferSize(bufferSize);
    }

    public String getContentType() {
        return this.shareAttributes.getContentType();
    }

    public void setContentType(String contentType) {
        this.shareAttributes.setContentType(contentType);
    }

    public String getPageEncoding() {
        return this.shareAttributes.getPageEncoding();
    }

    public void setPageEncoding(String pageEncoding) {
        this.shareAttributes.setPageEncoding(pageEncoding);
    }

    public boolean getCreateSession() {
        return this.shareAttributes.getCreateSession();
    }

    public void setCreateSession(boolean createSession) {
        this.shareAttributes.setCreateSession(createSession);
    }

    public StringBuffer getDeclarationsCode() {
        return this.shareAttributes.getDeclarationsCode();
    }

    public void setDeclarationsCode(StringBuffer declarationsCode) {
        this.shareAttributes.setDeclarationsCode(declarationsCode);
    }

    public String getErrorPage() {
        return this.shareAttributes.getErrorPage();
    }

    public void setErrorPage(String errorPage) {
        this.shareAttributes.setErrorPage(errorPage);
    }

    public StringBuffer getExtendsDirective() {
        return this.shareAttributes.getExtendsDirective();
    }

    public void setExtendsDirective(StringBuffer extendsDirective) {
        this.shareAttributes.setExtendsDirective(extendsDirective);
    }

    public boolean getHasParam() {
        return this.shareAttributes.getHasParam();
    }

    public void setHasParam(boolean hasParam) {
        this.shareAttributes.setHasParam(hasParam);
    }

    public StringBuffer getImplemetsDirective() {
        return this.shareAttributes.getImplemetsDirective();
    }

    public void setImplemetsDirective(StringBuffer implemetsDirective) {
        this.shareAttributes.setImplemetsDirective(implemetsDirective);
    }

    public StringBuffer getImportDirective() {
        return this.shareAttributes.getImportDirective();
    }

    public void setImportDirective(StringBuffer importDirective) {
        this.shareAttributes.setImportDirective(importDirective);
    }

    public StringBuffer getMethodDirective() {
        return this.shareAttributes.getMethodDirective();
    }

    public void setMethodDirective(StringBuffer methodDirective) {
        this.shareAttributes.setMethodDirective(methodDirective);
    }

    public boolean getPageActionTaken() {
        return this.shareAttributes.getPageActionTaken();
    }

    public void setPageActionTaken(boolean pageActionTaken) {
        this.shareAttributes.setPageActionTaken(pageActionTaken);
    }

    public Hashtable getPageAttributes() {
        return this.shareAttributes.getPageAttributes();
    }

    public void setPageAttributes(Hashtable pageAttributes) {
        this.shareAttributes.setPageAttributes(pageAttributes);
    }

    public String getPageImportAttribute() {
        return this.shareAttributes.getPageImportAttribute();
    }

    public void setPageImportAttribute(String pageImportAttribute) {
        this.shareAttributes.setPageImportAttribute(pageImportAttribute);
    }

    public String getPath() {
        return this.shareAttributes.getPath();
    }

    public void setPath(String path) {
        this.shareAttributes.setPath(path);
    }

    public StringBuffer getScriptletsCode() {
        return this.shareAttributes.getScriptletsCode();
    }

    public void setScriptletsCode(StringBuffer scriptletsCode) {
        this.shareAttributes.setScriptletsCode(scriptletsCode);
    }

    public String getServletInfo() {
        return this.shareAttributes.getServletInfo();
    }

    public void setServletInfo(String servletInfo) {
        this.shareAttributes.setServletInfo(servletInfo);
    }

    public Hashtable getTagAttributes() {
        return this.shareAttributes.getTagAttributes();
    }

    public void setTagAttributes(Hashtable tagAttributes) {
        this.shareAttributes.setTagAttributes(tagAttributes);
    }

    public Hashtable getTaglib() {
        return this.shareAttributes.getTaglib();
    }

    public void setTaglib(Hashtable taglib) {
        this.shareAttributes.setTaglib(taglib);
    }

    public Hashtable getTaglibs() {
        return this.shareAttributes.getTaglibs();
    }

    public void setTaglibs(Hashtable taglibs) {
        this.shareAttributes.setTaglibs(taglibs);
    }

    public void setInner(boolean isInner) {
        this.shareAttributes.setInner(isInner);
    }

    public boolean isInner() {
        return this.shareAttributes.isInner();
    }

    public Stack getTagsStack() {
        return this.shareAttributes.getTagsStack();
    }

    public Hashtable getTagVarNumbers() {
        return this.shareAttributes.getTagVarNumbers();
    }

    public TagLibraries getTagLibraries() {
        return this.shareAttributes.getTagLibraries();
    }

    public Vector getTagMethodsCode() {
        return this.shareAttributes.getTagMethodsCode();
    }

    public void setTagMethodsCode(Vector tagMethodsCode) {
        this.shareAttributes.setTagMethodsCode(tagMethodsCode);
    }

    public boolean isXml() {
        return this.isXml;
    }

    public void setIsXml(boolean isXml) {
        this.isXml = isXml;
    }

    public boolean isErrorPage() {
        return this.shareAttributes.isErrorPage();
    }

    public void setIsErrorPage(boolean isErrorPage) {
        this.shareAttributes.setIsErrorPage(isErrorPage);
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        String realPath1 = null;
        String tDir = new File(this.getRootDirectorty()).getAbsolutePath() + File.separator;
        realPath1 = tDir + (path.startsWith("/") ? path.substring(1) : path);
        if ((realPath1 = realPath1.replace('/', File.separatorChar)).endsWith(File.separator)) {
            return (new File(realPath1).getAbsolutePath() + File.separator).replace(File.separatorChar, '/');
        }
        return new File(realPath1).getAbsolutePath().replace(File.separatorChar, '/');
    }
}

