/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibDescriptorDocument;
import com.sap.engine.services.servlets_jsp.descriptor.taglib.TagLibraryInfoImpl;
import com.sap.engine.services.servlets_jsp.lib.jspparser.exceptions.JspParseException;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Element;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Indentifier;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.JspDirective;
import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.xmlsyntax.CustomJspTag;
import java.util.Arrays;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.w3c.dom.Document;

public class JspTaglibDirective
extends JspDirective {
    public static final char[] DIRECTIVE_NAME = "taglib".toCharArray();
    public static final char[][] attributeNames = new char[][]{"uri".toCharArray(), "prefix".toCharArray()};
    public static final char[][] reservedPrefixes = new char[][]{"jsp".toCharArray(), "jspx".toCharArray(), "java".toCharArray(), "javax".toCharArray(), "servlet".toCharArray(), "sun".toCharArray(), "sunw".toCharArray()};

    public JspTaglibDirective() {
        this.elementType = 5;
    }

    public void action() throws JspParseException {
        this.parser.getImportDirective().append("import javax.servlet.jsp.tagext.*;").append("\r\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyAttributes() throws JspParseException {
        if (this.attributes == null || this.attributes.length != 2) {
            throw new JspParseException("servlet_jsp_0093", new String[]{"taglib"}, this.debugInfo.start, this.parser);
        }
        Indentifier e = null;
        Indentifier value = null;
        boolean[] flags = new boolean[attributeNames.length];
        Arrays.fill(flags, true);
        int i = 0;
        while (i < this.attributes.length) {
            e = this.attributes[i].name;
            value = this.attributes[i].value;
            if (this.parser.compare(e.startIndex, e.endIndex, attributeNames[0])) {
                if (!flags[0]) throw new JspParseException("servlet_jsp_0094", new Object[]{"uri", "taglib"}, this.debugInfo.start, this.parser);
                flags[0] = false;
            } else {
                if (!this.parser.compare(e.startIndex, e.endIndex, attributeNames[1])) throw new JspParseException("servlet_jsp_0096", new Object[]{((Element)value).toString(), "taglib"}, this.debugInfo.start, this.parser);
                if (!flags[1]) {
                    throw new JspParseException("servlet_jsp_0094", new Object[]{"prefix", "taglib"}, this.debugInfo.start, this.parser);
                }
                flags[1] = false;
                int j = 0;
                while (j < reservedPrefixes.length) {
                    if (this.parser.compare(value.startIndex, value.endIndex, reservedPrefixes[j])) {
                        throw new JspParseException("servlet_jsp_0097", new Object[]{((Element)value).toString(), "prefix", "taglib"}, this.debugInfo.start, this.parser);
                    }
                    ++j;
                }
            }
            ++i;
        }
        String uri = this.getAttributeValue("uri");
        String prefix = this.getAttributeValue("prefix");
        if (uri == null) return;
        TagLibraryInfo tagD = (TagLibraryInfo)this.parser.getTagLibDescriptors().get(uri);
        TagInfo[] tags = null;
        try {
            tags = tagD.getTags();
        }
        catch (NullPointerException npex) {
            ClassLoader appLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.parser.getServiceClassLoader());
            TagLibDescriptorDocument tagLibDoc = new TagLibDescriptorDocument(this.parser.getApplicationClassLoader());
            try {
                try {
                    StandardDOMParser parser_ = new StandardDOMParser();
                    Document parsed = null;
                    parsed = parser_.parse(this.parser.getRootDirectorty() + uri);
                    tagD = tagLibDoc.loadDescriptorFromDocument(parsed);
                    ((TagLibraryInfoImpl)tagD).setURI(uri);
                    ((TagLibraryInfoImpl)tagD).setPrefixString(prefix);
                    this.parser.getTagLibDescriptors().put(uri, tagD);
                    tags = tagD.getTags();
                }
                catch (OutOfMemoryError ex) {
                    throw ex;
                }
                catch (ThreadDeath ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new JspParseException("servlet_jsp_0098", ex);
                }
                Object var16_19 = null;
                Thread.currentThread().setContextClassLoader(appLoader);
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                Thread.currentThread().setContextClassLoader(appLoader);
                throw throwable;
            }
        }
        ((TagLibraryInfoImpl)tagD).setURI(uri);
        ((TagLibraryInfoImpl)tagD).setPrefixString(prefix);
        this.parser.getTaglibs().put(prefix, tagD);
        if (tags == null) return;
        int i2 = 0;
        while (i2 < tags.length) {
            String startIndend = "<" + prefix + ":" + tags[i2].getTagName();
            String endIndend = "</" + prefix + ":" + tags[i2].getTagName() + ">";
            CustomJspTag cjt = new CustomJspTag(startIndend.toCharArray(), endIndend.toCharArray());
            cjt.setCopy(true);
            this.parser.getRootElement().registerParsingElement(cjt);
            ++i2;
        }
    }

    public String getString() throws JspParseException {
        return "xmlns:" + this.getAttributeValue("prefix") + "=\"" + this.getAttributeValue("uri") + "\"\n\t";
    }
}

