/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.lib.jspparser.syntax;

import com.sap.engine.services.servlets_jsp.lib.jspparser.syntax.Position;
import java.util.StringTokenizer;

public class DebugInfo {
    public static final char[] END_TAG = "// end\r\n".toCharArray();
    public static final char[] HTML = "// HTML ".toCharArray();
    public static final char[] BEGIN = "// begin [file=\"".toCharArray();
    public static final char[] FROM = "\";from=".toCharArray();
    public static final char[] TO = ";to=".toCharArray();
    public static final char[] END_ = "]\r\n".toCharArray();
    public Position start;
    public Position end;
    public String fileName;

    public DebugInfo(Position start, Position end, String fileName) {
        this.start = start;
        this.end = end;
        this.fileName = fileName;
    }

    public void writeStart(StringBuffer sb, boolean html) {
        if (html) {
            sb.append(HTML);
        }
        sb.append(BEGIN);
        sb.append(this.parseFile());
        sb.append(FROM);
        sb.append(this.parseStartPosition());
        sb.append(TO);
        sb.append(this.parseEndPosition());
        sb.append(END_);
    }

    public void writeEnd(StringBuffer sb) {
        sb.append(END_TAG);
    }

    public String parseFile() {
        this.fileName = this.fileName.replace('/', '\\');
        StringTokenizer st = new StringTokenizer(this.fileName, "\\");
        StringBuffer sb = new StringBuffer();
        sb.append(st.nextElement());
        while (st.hasMoreElements()) {
            sb.append("\\\\");
            sb.append(st.nextElement());
        }
        String ret = sb.toString();
        return ret;
    }

    public String parseStartPosition() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this.start.line).append(",").append(this.start.linePos).append(")");
        String ret = sb.toString();
        return ret;
    }

    public String parseEndPosition() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this.end.line).append(",").append(this.end.linePos).append(")");
        String ret = sb.toString();
        return ret;
    }
}

