/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.servlets_jsp.descriptor.FilterMapping;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import com.sap.engine.services.servlets_jsp.descriptor.gui.URLMappingsPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class URLMappingsPanelLogical
extends URLMappingsPanel
implements MadeFromConstants {
    private WebDeploymentDescriptor descriptor = null;
    private int lastSelected = -1;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;
    private Vector filterToServletMappings = null;

    public URLMappingsPanelLogical() {
        this(null, 0);
    }

    public URLMappingsPanelLogical(Frame mainFrame, int madeFromConstant) {
        this.setFrame(mainFrame);
        this.init(madeFromConstant);
    }

    public void setWebDescriptor(WebDeploymentDescriptor wdd) {
        this.descriptor = wdd;
        this.initList(this.descriptor);
        this.initNameComboBox();
    }

    public WebDeploymentDescriptor getWebDescriptor() {
        return this.descriptor;
    }

    private void addMapping(String type, String name, String url) {
        if (name == null || name.equals("") || url == null || url.equals("")) {
            return;
        }
        ListValues listValue = null;
        ServletMapping sMap = null;
        FilterMapping fMap = null;
        Object temp = null;
        boolean changed = false;
        int answer = 1;
        if (type.equals("SERVLET")) {
            sMap = new ServletMapping(name, url);
        } else {
            fMap = new FilterMapping(name, 1, url);
        }
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            if (!url.equals(listValue.getName())) continue;
            temp = listValue.getMapping();
            if (temp instanceof ServletMapping) {
                if (((ServletMapping)temp).equals(sMap)) {
                    return;
                }
                if (!type.equals("SERVLET")) continue;
                changed = true;
                break;
            }
            if (!(temp instanceof FilterMapping) || !((FilterMapping)temp).equals(fMap)) continue;
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Mapping <" + url + "> already exists.\n Would you like to save the changes and modify this Mapping?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyMapping(listValue, type, name);
            }
            this.clearFields();
            return;
        }
        if (sMap != null) {
            this.model.addElement(new ListValues(sMap, 11));
        } else if (fMap != null) {
            this.model.addElement(new ListValues(fMap, 11));
        }
    }

    private void modifyMapping(ListValues mapping, String type, String name) {
        if (mapping == null || name == null || name.equals("")) {
            return;
        }
        ListValues listValue = null;
        String url = null;
        ServletMapping sMap = null;
        FilterMapping fMap = null;
        Object temp = null;
        boolean answer = true;
        if (type.equals("SERVLET")) {
            url = mapping.getServletMapping().getURLPattern();
            sMap = new ServletMapping(name, url);
        } else {
            url = mapping.getFilterMapping().getURLPattern();
            fMap = new FilterMapping(name, 1, url);
        }
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            if (!url.equals(listValue.getName())) continue;
            temp = listValue.getMapping();
            if (temp instanceof ServletMapping) {
                if (!((ServletMapping)temp).equals(sMap)) continue;
                return;
            }
            if (!(temp instanceof FilterMapping) || !((FilterMapping)temp).equals(fMap)) continue;
            JOptionPane.showMessageDialog(this.mainFrame, "Such a mapping already exists!", "Warning", 2);
            return;
        }
        if (mapping.getMapping() instanceof ServletMapping) {
            if (type.equals("SERVLET")) {
                mapping.getServletMapping().setServletName(name);
            } else {
                mapping.setFilterMapping(new FilterMapping(name, 1, mapping.getName()));
                mapping.setServletMapping(null);
            }
        } else if (mapping.getMapping() instanceof FilterMapping) {
            if (type.equals("FILTER")) {
                mapping.getFilterMapping().setFilterName(name);
            } else {
                mapping.setServletMapping(new ServletMapping(name, mapping.getName()));
                mapping.setFilterMapping(null);
            }
        }
    }

    private void removeMapping(ListValues mapping) {
        if (mapping == null) {
            return;
        }
        this.model.removeElement(mapping);
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (!this.model.isEmpty()) {
            if (!this.mappingsList.isSelectionEmpty()) {
                this.checkPanel();
            }
            this.clearFields();
            if (!this.mappingsList.isSelectionEmpty()) {
                selected = this.mappingsList.getSelectedIndex();
                this.showMapping((ListValues)this.model.get(selected));
                if (this.madeFrom != 1 && this.madeFrom != 2 && this.madeFrom != 0 && this.madeFrom != 5) {
                    this.addButton.setEnabled(false);
                    this.modifyButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                }
            }
            this.lastSelected = selected;
        }
    }

    private void checkPanel() {
        String type = null;
        String name = null;
        String url = null;
        type = this.buttonGroup.getSelection().getActionCommand();
        if (this.nameComboBox.getSelectedItem() != null && ((String)this.nameComboBox.getSelectedItem()).trim() != null && !((String)this.nameComboBox.getSelectedItem()).trim().equals("")) {
            name = ((String)this.nameComboBox.getSelectedItem()).trim();
        }
        if (!this.urlTextField.getText().trim().equals("")) {
            url = this.urlTextField.getText().trim();
        }
        if (name == null || url == null) {
            return;
        }
        ListValues listValue = null;
        ServletMapping sMap = null;
        FilterMapping fMap = null;
        Object temp = null;
        boolean changed = false;
        int answer = 1;
        if (type.equals("SERVLET")) {
            sMap = new ServletMapping(name, url);
        } else {
            fMap = new FilterMapping(name, 1, url);
        }
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            if (!url.equals(listValue.getName())) continue;
            temp = listValue.getMapping();
            if (temp instanceof ServletMapping) {
                if (((ServletMapping)temp).equals(sMap)) {
                    return;
                }
                if (!type.equals("SERVLET")) continue;
                changed = true;
                break;
            }
            if (!(temp instanceof FilterMapping) || !((FilterMapping)temp).equals(fMap)) continue;
            return;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Mapping <" + url + "> was changed.\n Would you like to save the changes and modify this Mapping?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyMapping(listValue, type, name);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Mapping?", "Warning", 0, 2);
        if (answer == 0) {
            this.addMapping(type, name, url);
        }
        this.clearFields();
    }

    private void showMapping(ListValues mapping) {
        if (mapping == null || mapping.getMapping() == null || mapping.getName() == null || mapping.getName().equals("")) {
            return;
        }
        if (mapping.getMapping() instanceof ServletMapping) {
            this.servletRadio.setSelected(true);
            this.nameLabel.setText("Servlet:");
            this.initNameComboBox();
            this.nameComboBox.setSelectedItem(mapping.getServletMapping().getServletName());
            this.nameTextField.setText(mapping.getServletMapping().getServletName());
        } else if (mapping.getMapping() instanceof FilterMapping) {
            this.filterRadio.setSelected(true);
            this.nameLabel.setText("Filter:");
            this.initNameComboBox();
            this.nameComboBox.setSelectedItem(mapping.getFilterMapping().getFilterName());
            this.nameTextField.setText(mapping.getFilterMapping().getFilterName());
        }
        this.urlTextField.setText(mapping.getName());
    }

    public void actionPerformed(ActionEvent e) {
        String cmd;
        String type = null;
        String name = null;
        String url = null;
        type = this.buttonGroup.getSelection().getActionCommand();
        if (this.nameComboBox.getSelectedItem() != null && ((String)this.nameComboBox.getSelectedItem()).trim() != null && !((String)this.nameComboBox.getSelectedItem()).trim().equals("")) {
            name = ((String)this.nameComboBox.getSelectedItem()).trim();
        }
        if (!this.urlTextField.getText().trim().equals("")) {
            url = this.urlTextField.getText().trim();
        }
        if ((cmd = e.getActionCommand()).equals("SERVLET")) {
            this.nameLabel.setText("Servlet:");
            if (!this.mappingsList.isSelectionEmpty()) {
                this.mappingsList.clearSelection();
            }
            this.clearFields();
            this.initNameComboBox();
        } else if (cmd.equals("FILTER")) {
            this.nameLabel.setText("Filter:");
            if (!this.mappingsList.isSelectionEmpty()) {
                this.mappingsList.clearSelection();
            }
            this.clearFields();
            this.initNameComboBox();
        } else if (cmd.equals("ADD_CMD")) {
            this.addMapping(type, name, url);
            this.mappingsList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyMapping((ListValues)this.mappingsList.getSelectedValue(), type, name);
            this.mappingsList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeMapping((ListValues)this.mappingsList.getSelectedValue());
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.mappingsList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        String name = null;
        name = this.nameComboBox.getSelectedItem() != null ? ((String)this.nameComboBox.getSelectedItem()).trim() : "";
        String type = this.buttonGroup.getSelection().getActionCommand();
        String url = this.urlTextField.getText().trim();
        if (name.equals("") && url.equals("") && this.mappingsList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        } else {
            this.clearButton.setEnabled(true);
        }
        if (name.equals("") || url.equals("")) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            if (this.mappingsList.isSelectionEmpty()) {
                this.modifyButton.setEnabled(false);
            } else {
                this.modifyButton.setEnabled(true);
            }
        }
        if (this.mappingsList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.madeFrom == 1 || this.madeFrom == 2 || this.madeFrom == 0 || this.madeFrom == 5) {
            this.servletRadio.setEnabled(true);
            this.filterRadio.setEnabled(true);
            this.nameComboBox.setEnabled(true);
            this.urlTextField.setEnabled(true);
        } else {
            this.servletRadio.setEnabled(false);
            this.filterRadio.setEnabled(false);
            this.nameComboBox.setEnabled(false);
            this.urlTextField.setEnabled(false);
        }
    }

    public void clear() {
        this.model.clear();
        this.descriptor = null;
        this.clearFields();
        this.nameComboBox.setModel(new DefaultComboBoxModel());
    }

    public int isCorrect() {
        ListValues listValue = null;
        String name = null;
        int i = 0;
        while (i < this.model.size()) {
            listValue = (ListValues)this.model.get(i);
            if (listValue.getMapping() instanceof ServletMapping) {
                name = listValue.getServletMapping().getServletName();
                if (!this.findServlet(name)) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Servlet < " + name + " > could not be found!", "Warning", 2);
                    return 2;
                }
            } else if (listValue.getMapping() instanceof FilterMapping && !this.findFilter(name = listValue.getFilterMapping().getFilterName())) {
                JOptionPane.showMessageDialog(this.mainFrame, "Filter < " + name + " > could not be found!", "Warning", 2);
                return 2;
            }
            ++i;
        }
        return 0;
    }

    private boolean findServlet(String name) {
        if (name == null || this.descriptor == null) {
            return false;
        }
        if (this.appProvider == null) {
            return true;
        }
        String[] servletNames = this.appProvider.getServletNames(this.descriptor);
        if (servletNames == null || servletNames.length == 0) {
            return false;
        }
        int i = 0;
        while (i < servletNames.length) {
            if (servletNames[i] != null && name.equals(servletNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findFilter(String name) {
        if (name == null || this.descriptor == null) {
            return false;
        }
        if (this.appProvider == null) {
            return true;
        }
        String[] filterNames = this.appProvider.getFilterNames(this.descriptor);
        if (filterNames == null || filterNames.length == 0) {
            return false;
        }
        int i = 0;
        while (i < filterNames.length) {
            if (filterNames[i] != null && name.equals(filterNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void commitChange() {
        ListValues listValue = null;
        this.descriptor.setServletMapping(null);
        this.descriptor.setFilterMappings(null);
        int i = 0;
        while (i < this.model.size()) {
            listValue = (ListValues)this.model.get(i);
            if (listValue.getMapping() instanceof ServletMapping) {
                this.descriptor.addServletMapping(listValue.getServletMapping());
            } else if (listValue.getMapping() instanceof FilterMapping) {
                this.descriptor.addFilterMapping(listValue.getFilterMapping());
            }
            ++i;
        }
        if (this.filterToServletMappings != null) {
            int i2 = 0;
            while (i2 < this.filterToServletMappings.size()) {
                this.descriptor.addFilterMapping((FilterMapping)this.filterToServletMappings.elementAt(i2));
                ++i2;
            }
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider applicationProvider) {
        this.appProvider = applicationProvider;
        this.initNameComboBox();
        if (this.appProvider != null && this.descriptor != null) {
            this.initList(this.appProvider.getWebDeploymentDescriptor(this.descriptor.getName()));
        }
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    private void initList(WebDeploymentDescriptor descriptor) {
        this.model.clear();
        this.clearFields();
        this.filterToServletMappings = new Vector();
        if (descriptor != null) {
            int i;
            FilterMapping[] filterMap = descriptor.getFilterMappings();
            ServletMapping[] servletMap = descriptor.getServletMapping();
            if (filterMap != null) {
                i = 0;
                while (i < filterMap.length) {
                    if (filterMap[i].getURLPattern() != null) {
                        this.addMapping("FILTER", filterMap[i].getFilterName(), filterMap[i].getURLPattern());
                    } else {
                        this.filterToServletMappings.add(filterMap[i]);
                    }
                    ++i;
                }
            }
            if (servletMap != null) {
                i = 0;
                while (i < servletMap.length) {
                    this.addMapping("SERVLET", servletMap[i].getServletName(), servletMap[i].getURLPattern());
                    ++i;
                }
            }
        }
    }

    private void initNameComboBox() {
        if (this.appProvider != null) {
            String[] temp = null;
            if (this.filterRadio.isSelected()) {
                temp = this.appProvider.getFilterNames(this.descriptor);
                if (temp != null) {
                    this.nameComboBox.setModel(new DefaultComboBoxModel<String>(temp));
                } else {
                    this.nameComboBox.setModel(new DefaultComboBoxModel());
                }
            } else if (this.servletRadio.isSelected()) {
                temp = this.appProvider.getServletNames(this.descriptor);
                if (temp != null) {
                    this.nameComboBox.setModel(new DefaultComboBoxModel<String>(temp));
                } else {
                    this.nameComboBox.setModel(new DefaultComboBoxModel());
                }
            }
        }
    }
}

