/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.servlets_jsp.descriptor.AuthenticationDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.gui.AppConfigurationEntryWrapper;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import com.sap.engine.services.servlets_jsp.descriptor.gui.SecurityConfigPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class SecurityConfigPanelLogical
extends SecurityConfigPanel {
    private AppConfigurationEntryWrapper[] modules = null;
    private String loginPage = null;
    private String errorPage = null;
    private int lastSelected = -1;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;

    public SecurityConfigPanelLogical(Frame frame, int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        this.setFrame(frame);
        this.init(this.madeFrom);
        this.enabledFields(this.madeFrom);
    }

    private void enabledFields(int madeFromConstant) {
        if (madeFromConstant == 5) {
            this.nameTextField.setEnabled(false);
            this.flagCombo.setEnabled(false);
            this.editor.table.setEnabled(false);
            this.editor.keyTextField.setEnabled(false);
            this.editor.valueTextField.setEnabled(false);
            this.editor.addButton.setEnabled(false);
            this.editor.removeButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.loginTextField.setEnabled(true);
            this.errorTextField.setEnabled(true);
            this.modulesList.setEnabled(false);
        }
    }

    private void initList(AppConfigurationEntryWrapper[] values) {
        this.model.clear();
        this.lastSelected = -1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.model.addElement(new ListValues(values[i], 12));
                ++i;
            }
        }
    }

    private void addModule(String name, byte flag, Properties options) {
        if (name == null || name.equals("")) {
            return;
        }
        ListValues listValue = null;
        AppConfigurationEntryWrapper entry = null;
        AppConfigurationEntryWrapper temp = new AppConfigurationEntryWrapper(name, flag, options);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            entry = listValue.getLoginModule();
            if (!name.equals(entry.getName())) continue;
            if (temp.equals(entry)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Login Module <" + name + "> already exists.\n Would you like to save the changes and modify this Login Module?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyModule(listValue, flag, options);
            }
            this.clearFields();
            return;
        }
        if (options != null) {
            String key = null;
            Enumeration<?> en2 = options.propertyNames();
            while (en2.hasMoreElements()) {
                key = (String)en2.nextElement();
                if (options.getProperty(key) != null && !options.getProperty(key).equals("")) continue;
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Property < " + key + " > is not specified.\n" + "If value is missing, the property will not be saved in xml file.", "Warning", 2);
            }
        }
        this.model.addElement(new ListValues(temp, 12));
    }

    private void modifyModule(ListValues module, byte flag, Properties options) {
        if (module == null) {
            return;
        }
        if (flag < 0 || flag > 3) {
            JOptionPane.showMessageDialog(this.mainFrame, "Flag for Login Module < " + module.getLoginModule().getName() + " > is not specified.", "Warning", 2);
            return;
        }
        if (options != null) {
            String key = null;
            Enumeration<?> en = options.propertyNames();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (options.getProperty(key) != null && !options.getProperty(key).equals("")) continue;
                JOptionPane.showMessageDialog(this.mainFrame, "Value for Property < " + key + " > is not specified.\n" + "If value is missing, the property will not be saved in xml file.", "Warning", 2);
            }
        }
        module.getLoginModule().setFlag(flag);
        module.getLoginModule().setOptions(options);
    }

    private void removeModule(ListValues module) {
        if (module == null) {
            return;
        }
        this.model.removeElement(module);
    }

    private void setModules(AppConfigurationEntryWrapper[] entries) {
        this.modules = entries;
        this.clearFields();
        this.initList(this.modules);
    }

    private void setLoginModules(AppConfigurationEntry[] entries) {
        if (entries == null) {
            this.setModules(null);
            return;
        }
        AppConfigurationEntryWrapper[] temp = new AppConfigurationEntryWrapper[entries.length];
        int i = 0;
        while (i < entries.length) {
            temp[i] = new AppConfigurationEntryWrapper(entries[i]);
            ++i;
        }
        this.setModules(temp);
    }

    public void setAuthenticationDescriptor(AuthenticationDescriptor authDescr) {
        this.clear();
        if (authDescr == null) {
            this.setLoginPage(null);
            this.setErrorPage(null);
            this.setModules(null);
        } else {
            this.setLoginPage(authDescr.getChangePasswordPage());
            this.setErrorPage(authDescr.getChangePasswordErrorPage());
            this.setLoginModules(authDescr.getLoginModules());
        }
    }

    public AuthenticationDescriptor getAuthenticationDescriptor() {
        if (this.loginPage == null && this.errorPage == null && this.getLoginModules() == null) {
            return null;
        }
        AuthenticationDescriptor auth = new AuthenticationDescriptor();
        auth.setChangePasswordPage(this.loginPage);
        auth.setChangePasswordErrorPage(this.errorPage);
        auth.setLoginModules(this.getLoginModules());
        return auth;
    }

    private AppConfigurationEntryWrapper[] getModules() {
        return this.modules;
    }

    private AppConfigurationEntry[] getLoginModules() {
        if (this.modules == null || this.modules.length == 0) {
            return null;
        }
        AppConfigurationEntry[] temp = new AppConfigurationEntry[this.modules.length];
        int i = 0;
        while (i < this.modules.length) {
            temp[i] = this.modules[i].getEntry();
            ++i;
        }
        return temp;
    }

    private void setLoginPage(String login) {
        this.loginPage = login;
        if (this.loginPage == null) {
            this.loginTextField.setText("");
        } else {
            this.loginTextField.setText(this.loginPage);
        }
    }

    private String getLoginPage() {
        return this.loginPage;
    }

    private void setErrorPage(String error) {
        this.errorPage = error;
        if (this.errorPage == null) {
            this.errorTextField.setText("");
        } else {
            this.errorTextField.setText(this.errorPage);
        }
    }

    private String getErrorPage() {
        return this.errorPage;
    }

    private void showProp(ListValues module) {
        if (module == null || module.getLoginModule() == null || module.getLoginModule().getName() == null || module.getLoginModule().getName().equals("")) {
            return;
        }
        if (module.getLoginModule().getFlag() < 0 || module.getLoginModule().getFlag() > 3) {
            return;
        }
        AppConfigurationEntryWrapper wrapped = module.getLoginModule();
        this.nameTextField.setText(wrapped.getName());
        this.flagCombo.setSelectedIndex(wrapped.getFlag() + 1);
        this.editor.initProperties((Properties)wrapped.getOptions());
    }

    public void valueChanged(ListSelectionEvent e) {
        int selected = -1;
        if (!this.model.isEmpty()) {
            this.checkPanel();
            this.clearFields();
            if (!this.modulesList.isSelectionEmpty()) {
                selected = this.modulesList.getSelectedIndex();
                this.showProp((ListValues)this.model.get(selected));
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
            this.lastSelected = selected;
        }
    }

    private void checkPanel() {
        String name = null;
        byte flag = -1;
        Properties options = null;
        if (!this.nameTextField.getText().trim().equals("")) {
            name = this.nameTextField.getText().trim();
        }
        flag = (byte)(this.flagCombo.getSelectedIndex() - 1);
        if (name == null || flag == -1) {
            return;
        }
        ListValues listValue = null;
        AppConfigurationEntryWrapper entry = null;
        options = this.editor.getProps();
        AppConfigurationEntryWrapper temp = new AppConfigurationEntryWrapper(name, flag, options);
        boolean changed = false;
        int answer = 1;
        Enumeration en = this.model.elements();
        while (en.hasMoreElements()) {
            listValue = (ListValues)en.nextElement();
            entry = listValue.getLoginModule();
            if (!name.equals(entry.getName())) continue;
            if (temp.equals(entry)) {
                return;
            }
            changed = true;
            break;
        }
        if (changed) {
            answer = JOptionPane.showConfirmDialog(this.mainFrame, "Information for Login Module <" + name + "> was changed.\n Would you like to save the changes and modify this Login Module?", "Warning", 0, 2);
            if (answer == 0) {
                this.modifyModule(listValue, flag, options);
            }
            this.clearFields();
            return;
        }
        answer = JOptionPane.showConfirmDialog(this.mainFrame, "Would you like to add this Login Module?", "Warning", 0, 2);
        if (answer == 0) {
            if (flag < 0 || flag > 3) {
                JOptionPane.showMessageDialog(this.mainFrame, "Flag for Login Module < " + name + " > is not specified.", "Warning", 2);
                return;
            }
            this.addModule(name, flag, options);
        }
        this.clearFields();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.flagCombo)) {
            this.processDocumentEvent();
        }
        String name = null;
        byte flag = -1;
        Properties options = null;
        String cmd = e.getActionCommand();
        if (!this.nameTextField.getText().trim().equals("")) {
            name = this.nameTextField.getText().trim();
        }
        flag = (byte)(this.flagCombo.getSelectedIndex() - 1);
        options = this.editor.getProps();
        if (cmd.equals("ADD_CMD")) {
            if (flag < 0 || flag > 3) {
                JOptionPane.showMessageDialog(this.mainFrame, "Flag for Login Module < " + name + " > is not specified.", "Warning", 2);
                return;
            }
            this.addModule(name, flag, options);
            this.modulesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyModule((ListValues)this.modulesList.getSelectedValue(), flag, options);
            this.modulesList.clearSelection();
            this.clearFields();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeModule((ListValues)this.modulesList.getSelectedValue());
            this.clearFields();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.modulesList.clearSelection();
            this.clearFields();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processDocumentEvent();
    }

    private void processDocumentEvent() {
        String name = this.nameTextField.getText().trim();
        byte flag = (byte)(this.flagCombo.getSelectedIndex() - 1);
        Properties options = this.editor.getProps();
        if (name.equals("") && flag == -1 && options != null && !((Hashtable)options).isEmpty() && this.modulesList.isSelectionEmpty()) {
            this.clearButton.setEnabled(false);
        } else {
            this.clearButton.setEnabled(true);
        }
        if (!name.equals("")) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.model.clear();
        this.modules = null;
        this.setLoginPage(null);
        this.setErrorPage(null);
        this.clearFields();
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.modules = new AppConfigurationEntryWrapper[this.model.size()];
        int i = 0;
        while (i < this.model.size()) {
            this.modules[i] = ((ListValues)this.model.get(i)).getLoginModule();
            ++i;
        }
        this.loginPage = this.loginTextField.getText().trim().equals("") ? null : this.loginTextField.getText().trim();
        this.errorPage = this.errorTextField.getText().trim().equals("") ? null : this.errorTextField.getText().trim();
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

