/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.gui.SimpleListPanel;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListRenderer;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReferencePanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    private Vector listValues = new Vector();
    int lastSelected = -1;
    WebResourceCollection[] collections = null;
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel listPanel = new JPanel();
    JPanel inputPanel = new JPanel();
    JPanel buttonsPanel = new JPanel();
    SimpleListPanel urlPanel = null;
    SimpleListPanel methodPanel = null;
    DescriptionPanel webDescription = new DescriptionPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JList theList = new JList();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JLabel nameLabel = new JLabel();
    JTextField nameTextField = new JTextField();
    JTextArea descrTextArea = new JTextArea();
    JTabbedPane theTabbedPane = new JTabbedPane();
    Frame frame;
    boolean isEnabled = true;
    private static Category category = EditorViewManager.category;
    private static Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$descriptor$gui$ReferencePanel == null ? (class$com$sap$engine$services$servlets_jsp$descriptor$gui$ReferencePanel = ReferencePanel.class$("com.sap.engine.services.servlets_jsp.descriptor.gui.ReferencePanel")) : class$com$sap$engine$services$servlets_jsp$descriptor$gui$ReferencePanel));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$descriptor$gui$ReferencePanel;

    public ReferencePanel(Frame mainFrame) {
        this.frame = mainFrame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            category.logThrowableT(500, currentLocation, "EJBean references and Resource references panel cannot be created!", (Throwable)ex);
        }
    }

    public ReferencePanel(Frame mainFrame, WebResourceCollection[] collections) {
        this.frame = mainFrame;
        try {
            this.collections = collections;
            this.jbInit();
            this.firstInit(collections);
        }
        catch (Exception ex) {
            category.logThrowableT(500, currentLocation, "EJBean references and Resource references panel cannot be created!", (Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.urlPanel = new SimpleListPanel("URL Pattern");
        this.urlPanel.setAddText("Enter URL pattern");
        this.urlPanel.setEditText("Edit URL pattern");
        ListRenderer renderer = new ListRenderer();
        renderer.setType((byte)2);
        this.urlPanel.setListRenderer((ListCellRenderer)renderer);
        this.methodPanel = new SimpleListPanel("HTTP Methods");
        this.methodPanel.setAddText("Enter HTTP method");
        this.methodPanel.setEditText("Edit HTTP method");
        this.methodPanel.setComboElements(new String[]{"", "PUT", "GET", "POST", "DELETE", "OPTIONS", "TRACE"});
        this.methodPanel.setParentComponent((Component)this.frame);
        ListRenderer render = new ListRenderer();
        render.setType((byte)3);
        this.methodPanel.setListRenderer((ListCellRenderer)render);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, "Web Resources");
        this.setLayout(this.borderLayout1);
        this.listPanel.setLayout(this.borderLayout2);
        this.inputPanel.setLayout(this.gridBagLayout1);
        this.addButton.setText("New");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand(ADD_CMD);
        this.removeButton.setText("Delete");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.setEnabled(false);
        this.urlPanel.setEnabled(false);
        this.methodPanel.setEnabled(false);
        this.listPanel.setBorder(this.titledBorder1);
        this.nameLabel.setText("Resource Name:");
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.listPanel, "left");
        this.listPanel.add((Component)this.jScrollPane1, "Center");
        this.listPanel.add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add((Component)this.addButton, null);
        this.buttonsPanel.add((Component)this.removeButton, null);
        this.jScrollPane1.getViewport().add((Component)this.theList, null);
        this.jSplitPane1.add((Component)this.inputPanel, "right");
        this.inputPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(25, 5, 25, 5), 0, 0));
        this.inputPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(25, 5, 25, 5), 0, 0));
        this.inputPanel.add((Component)this.theTabbedPane, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.inputPanel.add((Component)this.webDescription, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.theTabbedPane.add("URL Pattern", (Component)this.urlPanel);
        this.theTabbedPane.add("HTTP Methods", (Component)this.methodPanel);
        this.jSplitPane1.setDividerLocation(200);
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
        this.theList.setCellRenderer(new ListRenderer());
    }

    public void firstInit(WebResourceCollection[] newValues) {
        this.clearAll();
        this.collections = null;
        this.collections = newValues;
        if (newValues != null) {
            int i = 0;
            while (i < newValues.length) {
                if (newValues[i] != null) {
                    WebResourceCollection newCollection = new WebResourceCollection(newValues[i].getWebResourceName(), newValues[i].getHttpMethod(), newValues[i].getUrlPattern());
                    if (newValues[i].getDescription() != null) {
                        newCollection.setDescription(newValues[i].getDescription());
                    } else {
                        newCollection.setDescription("");
                    }
                    this.listValues.addElement(new ListValues(newCollection, 7, newValues[i].getWebResourceName()));
                }
                ++i;
            }
        }
        this.theList.setListData(this.listValues);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.valueChanged();
    }

    public void valueChanged() {
        if (!this.theList.isSelectionEmpty()) {
            this.removeButton.setEnabled(this.isEnabled);
            this.urlPanel.setEnabled(this.isEnabled);
            this.methodPanel.setEnabled(this.isEnabled);
            if (this.lastSelected == -1) {
                this.viewValues(this.theList.getSelectedIndex());
            } else {
                this.setValues(this.lastSelected);
                this.viewValues(this.theList.getSelectedIndex());
            }
            this.lastSelected = this.theList.getSelectedIndex();
        } else if (this.lastSelected != -1) {
            this.setValues(this.lastSelected);
            this.lastSelected = this.theList.getSelectedIndex();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(REMOVE_CMD)) {
            this.removeButtonAction();
        } else if (cmd.equals(ADD_CMD)) {
            this.addButtonAction();
        }
    }

    private void addButtonAction() {
        this.webDescription.setText("");
        String name = JOptionPane.showInputDialog(this.frame, "Insert name for web resource collection:", "Web Collection Name", -1);
        if (name == null || name.trim().equals("")) {
            return;
        }
        int i = 0;
        while (i < this.listValues.size()) {
            if (((ListValues)this.listValues.elementAt(i)).getName().equals(name)) {
                return;
            }
            ++i;
        }
        ListValues newElement = new ListValues(name, 7);
        WebResourceCollection collection = new WebResourceCollection();
        collection.setWebResourceName(name);
        newElement.setWebCollection(collection);
        this.listValues.addElement(newElement);
        this.theList.setListData(this.listValues);
        this.urlPanel.setEnabled(false);
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            this.listValues.removeElementAt(this.theList.getSelectedIndex());
            this.lastSelected = -1;
            this.theList.setListData(this.listValues);
            this.theList.clearSelection();
            this.removeButton.setEnabled(false);
            this.urlPanel.initList(new Vector());
            this.urlPanel.setEnabled(false);
            this.methodPanel.setEnabled(false);
            Vector values = this.methodPanel.getListData();
            values.removeAllElements();
        }
    }

    public void viewValues(int index) {
        ListValues value = null;
        WebResourceCollection collection = null;
        if (!this.theList.isSelectionEmpty() && (collection = (value = (ListValues)this.listValues.elementAt(index)).getWebCollection()) != null) {
            this.nameTextField.setText(collection.getWebResourceName());
            this.webDescription.setText(collection.getDescription());
            this.urlPanel.initList(collection.getUrlPattern());
            this.methodPanel.initList(collection.getHttpMethod());
        }
    }

    private void setValues(int lastSelectedIndex) {
        String[] urlPatterns = null;
        String[] httpMethods = null;
        ListValues value = (ListValues)this.listValues.elementAt(lastSelectedIndex);
        WebResourceCollection webResource = value.getWebCollection();
        if (webResource != null) {
            if (!this.nameTextField.getText().trim().equals(webResource.getWebResourceName())) {
                webResource.setWebResourceName(this.nameTextField.getText().trim());
            }
            if (!this.webDescription.getText().trim().equals(webResource.getDescription())) {
                webResource.setDescription(this.webDescription.getText().trim());
            }
            urlPatterns = this.urlPanel.getListDataArray();
            httpMethods = this.methodPanel.getListDataArray();
            String[] url1 = webResource.getUrlPattern();
            String[] methods = webResource.getHttpMethod();
            if (!this.equalArrays(urlPatterns, url1)) {
                webResource.setUrlPattern(urlPatterns);
            }
            if (!this.equalArrays(httpMethods, methods)) {
                webResource.setHttpMethod(httpMethods);
            }
            value.setWebCollection(webResource);
        }
        this.urlPanel.initList(new Vector());
        this.methodPanel.initList(new Vector());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean equalArrays(String[] array1, String[] array2) {
        if (array1 != null) {
            if (array2 == null) return false;
            if (array1.length != array2.length) return false;
            int index = -1;
            int i = 0;
            while (i < array1.length) {
                index = -1;
                int j = 0;
                while (j < array2.length) {
                    if (array1[i] != null) {
                        if (array1[i].equals(array2[j])) {
                            index = j;
                        }
                    } else if (array1[i] == array2[j]) {
                        index = j;
                    }
                    ++j;
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (array2 == null) return true;
            return false;
        }
    }

    public WebResourceCollection[] commitChanges() {
        this.valueChanged();
        if (this.listValues != null) {
            this.collections = new WebResourceCollection[this.listValues.size()];
            int i = 0;
            while (i < this.listValues.size()) {
                this.collections[i] = ((ListValues)this.listValues.elementAt(i)).getWebCollection();
                ++i;
            }
        }
        return this.collections;
    }

    public void setEnabled(boolean flag) {
        this.isEnabled = flag;
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(flag);
        this.nameTextField.setEnabled(flag);
        this.urlPanel.setEnabled(flag);
        this.methodPanel.setEnabled(flag);
        this.webDescription.setEnabled(flag);
    }

    public void clearAll() {
        this.lastSelected = -1;
        this.listValues.removeAllElements();
        this.theList.setListData(this.listValues);
        this.nameTextField.setText("");
        this.urlPanel.initList(new Vector());
        this.urlPanel.setEnabled(false);
        this.methodPanel.setEnabled(false);
        this.methodPanel.initList(new Vector());
        this.webDescription.setText("");
    }

    public void clear() {
        this.theList.setListData(new Vector());
        this.nameTextField.setText("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

