/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.servlets_jsp.descriptor.AuthConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.SecurityConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.UserDataConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ConstrainsPanel;
import com.sap.engine.services.servlets_jsp.descriptor.gui.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;

public class ConstrainsPanelLogical
extends ConstrainsPanel {
    String displayName = "Security Constraint ";
    WebDeploymentDescriptor webDescriptor = null;
    SecurityConstraints[] secConstraints = null;
    AuthConstraints authConstraint = null;
    UserDataConstraints userConstraint = null;
    String[] availableRoles = null;
    SecurityRoles[] roles = null;
    int lastSelected = -1;
    private ApplicationInformationProvider appProvider;
    int madeFrom;

    public ConstrainsPanelLogical(Frame mainFrame) {
        super(mainFrame);
        this.setTabbedPaneEnabled(false);
    }

    public ConstrainsPanelLogical(Frame mainFrame, int _madeFrom) {
        super(mainFrame);
        this.madeFrom = _madeFrom;
        this.setTabbedPaneEnabled(false);
        if (_madeFrom == 5) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.jScrollPane1.setEnabled(true);
            this.theList.setEnabled(true);
            this.webResourcePanel.setEnabled(false);
            this.transportComboBox.setEnabled(false);
            this.userDataDescription.setEnabled(false);
            this.authDescription.setEnabled(false);
            this.addButton1.setEnabled(false);
            this.removeButton1.setEnabled(false);
        }
    }

    private void firstInit() {
        SecurityRoles[] secRolesArray;
        ListValues value = null;
        if (this.secConstraints != null) {
            int i = 0;
            while (i < this.secConstraints.length) {
                value = new ListValues(this.secConstraints[i], 6, this.displayName + i);
                this.mainModel.addElement(value);
                ++i;
            }
        }
        if ((secRolesArray = this.webDescriptor.getSecRoles()) != null) {
            int i = 0;
            while (i < secRolesArray.length) {
                this.availableModel.addElement(new ListValues(secRolesArray[i].getRoleName(), 8));
                ++i;
            }
        }
    }

    public void initSecurityRoles(Vector roles) {
        this.theList.clearSelection();
        this.availableModel.removeAllElements();
        if (roles != null) {
            int j = 0;
            while (j < roles.size()) {
                this.availableModel.addElement(new ListValues(((SecurityRoles)roles.elementAt(j)).getRoleName(), 8));
                ++j;
            }
        }
        this.checkRemovedRoles(roles);
    }

    private void viewValues(int index) {
        ListValues value = null;
        SecurityConstraints secConstr = new SecurityConstraints();
        WebResourceCollection[] webCollection1 = null;
        AuthConstraints authConstraint1 = null;
        if (!this.theList.isSelectionEmpty()) {
            value = (ListValues)this.mainModel.getElementAt(index);
            secConstr = value.getSecurityConstraint();
            authConstraint1 = secConstr.getAuthConstraints();
            this.userConstraint = secConstr.getUserConstr();
            webCollection1 = secConstr.getWebResourceCollections();
            this.transportComboBox.setSelectedItem(this.userConstraint.getTransport());
            this.userDataDescription.setText(this.userConstraint.getDescription());
            if (authConstraint1 != null && authConstraint1.getRoleNames() != null) {
                int i = 0;
                while (i < authConstraint1.getRoleNames().length) {
                    this.rolesModel.addElement(new ListValues(authConstraint1.getRoleNames()[i], 8));
                    ++i;
                }
                this.authDescription.setText(authConstraint1.getDescription());
            }
            this.webResourcePanel.firstInit(webCollection1);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addButtonAction();
        } else if (cmd.equals("ADD1_CMD")) {
            this.addButton1Action();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAction();
        } else if (cmd.equals("REMOVE1_CMD")) {
            this.remove1Action();
        }
    }

    private void addButtonAction() {
        this.clearAllFields();
        int size = 0;
        if (this.secConstraints != null) {
            size = this.secConstraints.length;
        }
        String name = "";
        name = this.displayName + size;
        ListValues newElement = new ListValues(name, 6);
        SecurityConstraints constr = new SecurityConstraints();
        newElement.setSecurityConstraint(constr);
        this.mainModel.addElement(newElement);
        this.theList.setSelectedValue(newElement, true);
        this.rolesModel.removeAllElements();
        this.viewValues(this.lastSelected);
        this.addSecConstraint(constr);
        this.webResourcePanel.clearAll();
    }

    private void setValues(int lastSelectedIndex) {
        AuthConstraints auth;
        if (lastSelectedIndex < 0 || lastSelectedIndex > this.mainModel.size() - 1) {
            return;
        }
        ListValues value = (ListValues)this.mainModel.getElementAt(lastSelectedIndex);
        SecurityConstraints constr = value.getSecurityConstraint();
        String transport = (String)this.transportComboBox.getSelectedItem();
        if (transport != null && transport.trim() != null) {
            UserDataConstraints userConstraint = new UserDataConstraints(transport.trim());
            if (!this.userDataDescription.getText().trim().equals("")) {
                userConstraint.setDescription(this.userDataDescription.getText().trim());
            }
            constr.setUserDataConstraints(userConstraint);
        }
        if ((auth = constr.getAuthConstraints()) == null) {
            auth = new AuthConstraints();
        }
        String[] roleNames = null;
        if (this.rolesModel.size() > 0) {
            roleNames = new String[this.rolesModel.size()];
        }
        int i = 0;
        while (i < this.rolesModel.size()) {
            roleNames[i] = ((ListValues)this.rolesModel.getElementAt(i)).getRoleName();
            ++i;
        }
        auth.setRoleName(roleNames);
        if (this.authDescription.getText() != null && !this.authDescription.getText().trim().equals("")) {
            auth.setDescription(this.authDescription.getText().trim());
        } else {
            auth.setDescription(null);
        }
        constr.setAuthorityConstraints(auth);
        WebResourceCollection[] cc = this.webResourcePanel.commitChanges();
        constr.setWebCollections(cc);
        value.setSecurityConstraint(constr);
        this.mainModel.setElementAt(value, lastSelectedIndex);
    }

    private boolean isWebResourceCorrect(WebResourceCollection[] wr) {
        return wr != null && wr.length > 0 && wr[0] != null;
    }

    private void clearAllFields() {
        this.transportComboBox.setSelectedIndex(0);
        this.userDataDescription.setText("");
        this.authDescription.setText("");
        this.descriptionTextArea.setText("");
        this.rolesModel.removeAllElements();
    }

    private void addButton1Action() {
        int index = -1;
        if (!this.availableList.isSelectionEmpty()) {
            index = this.availableList.getSelectedIndex();
            String value = ((ListValues)this.availableModel.getElementAt(index)).getRoleName();
            int i = 0;
            while (i < this.rolesModel.size()) {
                if (((ListValues)this.rolesModel.getElementAt(i)).getName().equals(value)) {
                    return;
                }
                ++i;
            }
            this.rolesModel.addElement(new ListValues(value, 8));
        }
        this.rolesList.clearSelection();
        this.availableList.clearSelection();
    }

    private void removeAction() {
        if (!this.theList.isSelectionEmpty()) {
            this.mainModel.removeElementAt(this.theList.getSelectedIndex());
            this.lastSelected = -1;
            this.theList.clearSelection();
            this.webResourcePanel.clearAll();
            this.removeButton.setEnabled(false);
            this.setTabbedPaneEnabled(false);
        }
    }

    private void remove1Action() {
        if (!this.rolesList.isSelectionEmpty()) {
            this.rolesModel.removeElementAt(this.rolesList.getSelectedIndex());
        }
        this.rolesList.clearSelection();
    }

    public void rolesListValueChanged() {
        if (!this.rolesList.isSelectionEmpty()) {
            if (this.madeFrom != 5) {
                this.removeButton1.setEnabled(true);
            }
        } else {
            this.removeButton1.setEnabled(false);
        }
    }

    public void theListValueChanged() {
        ListValues value;
        if (!this.theList.isSelectionEmpty()) {
            if (this.madeFrom != 5) {
                this.removeButton.setEnabled(true);
            }
            this.setTabbedPaneEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.setTabbedPaneEnabled(false);
        }
        int lastID = -1;
        if (!this.theList.isSelectionEmpty()) {
            if (this.lastSelected == -1) {
                this.rolesModel.removeAllElements();
                this.viewValues(this.theList.getSelectedIndex());
            } else {
                this.setValues(this.lastSelected);
                this.rolesModel.removeAllElements();
                this.viewValues(this.theList.getSelectedIndex());
            }
            lastID = this.lastSelected;
            this.lastSelected = this.theList.getSelectedIndex();
        } else if (this.lastSelected != -1) {
            this.setValues(this.lastSelected);
            lastID = this.lastSelected;
            this.lastSelected = this.theList.getSelectedIndex();
            this.rolesModel.removeAllElements();
        } else {
            this.rolesModel.removeAllElements();
        }
        if (lastID > -1 && lastID < this.mainModel.size() && (value = (ListValues)this.mainModel.elementAt(lastID)) != null && value.getSecurityConstraint() != null && !this.isWebResourceCorrect(value.getSecurityConstraint().getWebResourceCollections())) {
            JOptionPane.showMessageDialog(this.mainFrame, ((ListValues)this.mainModel.elementAt(lastID)).getName() + " must contain at least one web resource collection or it will not be saved.", "Warning", 2);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.rolesList) {
            this.rolesListValueChanged();
        } else if (e.getSource() == this.theList) {
            this.theListValueChanged();
        } else if (e.getSource() == this.availableList && this.madeFrom != 5) {
            this.addButton.setEnabled(true);
        }
    }

    private void addSecConstraint(SecurityConstraints constraints) {
        int size = 0;
        SecurityConstraints[] newConstraints = null;
        if (this.secConstraints != null) {
            size = this.secConstraints.length;
            newConstraints = new SecurityConstraints[size + 1];
            System.arraycopy(this.secConstraints, 0, newConstraints, 0, size);
            newConstraints[size] = constraints;
            this.secConstraints = newConstraints;
        } else {
            this.secConstraints = new SecurityConstraints[1];
            this.secConstraints[0] = constraints;
        }
    }

    public void commitChanges(WebDeploymentDescriptor ww) {
        this.theListValueChanged();
        this.rolesListValueChanged();
        if (ww != null) {
            if (this.mainModel.size() > 0) {
                Vector<SecurityConstraints> secTemp = new Vector<SecurityConstraints>();
                SecurityConstraints secConstr = null;
                Object[] secConstraints = null;
                int i = 0;
                while (i < this.mainModel.size()) {
                    secConstr = ((ListValues)this.mainModel.elementAt(i)).getSecurityConstraint();
                    if (secConstr != null && this.isWebResourceCorrect(secConstr.getWebResourceCollections())) {
                        secTemp.add(secConstr);
                    }
                    ++i;
                }
                if (secTemp.size() != 0) {
                    secConstraints = new SecurityConstraints[secTemp.size()];
                    secTemp.copyInto(secConstraints);
                    ww.setSecConstraints((SecurityConstraints[])secConstraints);
                } else {
                    ww.setSecConstraints(null);
                }
            } else {
                ww.setSecConstraints(null);
            }
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int madeFromConstant) {
    }

    public void setDescriptor(WebDeploymentDescriptor descr) {
        this.webDescriptor = descr;
        this.secConstraints = this.webDescriptor.getSecConstraints();
        this.authConstraint = null;
        this.userConstraint = null;
        this.availableRoles = null;
        this.roles = null;
        this.lastSelected = -1;
        this.mainModel.removeAllElements();
        this.availableModel.removeAllElements();
        this.webResourcePanel.clearAll();
        this.clearAllFields();
        this.firstInit();
    }

    private void checkRemovedRoles(Vector roles) {
        ListValues value = null;
        SecurityConstraints secConstr = new SecurityConstraints();
        AuthConstraints authConstraint1 = null;
        boolean found = false;
        int j = 0;
        while (j < this.mainModel.size()) {
            value = (ListValues)this.mainModel.getElementAt(j);
            secConstr = value.getSecurityConstraint();
            authConstraint1 = secConstr.getAuthConstraints();
            if (authConstraint1 != null && authConstraint1.getRoleNames() != null) {
                int i = 0;
                while (i < authConstraint1.getRoleNames().length) {
                    found = false;
                    int k = 0;
                    while (k < roles.size()) {
                        if (authConstraint1.getRoleNames()[i].equals(((SecurityRoles)roles.elementAt(k)).getName())) {
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        authConstraint1.removeRole(authConstraint1.getRoleNames()[i]);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void commitChange() {
    }

    public void clear() {
    }

    private void setTabbedPaneEnabled(boolean b) {
        this.theTabbedPane.setEnabled(b);
        this.theTabbedPane.setSelectedIndex(0);
        if (this.madeFrom != 5) {
            this.webResourcePanel.setEnabled(b);
        } else {
            this.webResourcePanel.setEnabled(false);
        }
        if (!b) {
            if (this.lastSelected != -1) {
                this.setValues(this.lastSelected);
            }
            this.webResourcePanel.clear();
        }
    }
}

