/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;

public class LoginModule
implements Serializable {
    static final long serialVersionUID = 1713242123768564953L;
    public static final int REQUIRED = 1;
    public static final int REQUISITE = 2;
    public static final int SUFFICIENT = 3;
    public static final int OPTIONAL = 4;
    private String loginModuleName = null;
    private int controlFlag = -1;
    private Map options = null;

    public LoginModule(String loginModuleName, int controlFlag, Map options) {
        this.loginModuleName = loginModuleName;
        this.controlFlag = controlFlag;
        this.options = options;
    }

    public LoginModule(AppConfigurationEntry appConfigurationEntry) {
        this.loginModuleName = appConfigurationEntry.getLoginModuleName();
        if (appConfigurationEntry.getControlFlag() != null) {
            if (appConfigurationEntry.getControlFlag().equals(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL)) {
                this.controlFlag = 4;
            } else if (appConfigurationEntry.getControlFlag().equals(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE)) {
                this.controlFlag = 2;
            } else if (appConfigurationEntry.getControlFlag().equals(AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT)) {
                this.controlFlag = 3;
            } else if (appConfigurationEntry.getControlFlag().equals(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL)) {
                this.controlFlag = 4;
            }
        }
        this.options = appConfigurationEntry.getOptions();
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public int getControlFlag() {
        return this.controlFlag;
    }

    public Map getOptions() {
        return this.options;
    }

    public AppConfigurationEntry toAppConfigurationEntry() {
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = null;
        switch (this.controlFlag) {
            case 1: {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                break;
            }
            case 2: {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                break;
            }
            case 3: {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                break;
            }
            case 4: {
                loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        return new AppConfigurationEntry(this.loginModuleName, loginModuleControlFlag, this.options);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LoginModule) {
            return this.equals((LoginModule)obj);
        }
        return false;
    }

    public boolean equals(LoginModule loginModule) {
        if (loginModule == null) {
            return false;
        }
        if (this.options == null && loginModule.options != null || this.options != null && loginModule.options == null) {
            return false;
        }
        if (this.options != null && !this.options.equals(loginModule.options)) {
            return false;
        }
        if (this.loginModuleName == null && loginModule.loginModuleName != null || this.loginModuleName != null && loginModule.loginModuleName == null) {
            return false;
        }
        if (this.loginModuleName != null && !this.loginModuleName.equals(loginModule.loginModuleName)) {
            return false;
        }
        return this.controlFlag == loginModule.controlFlag;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.options == null || this.options.size() == 0) {
            s.defaultWriteObject();
            return;
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator keys = this.options.keySet().iterator();
        while (keys.hasNext()) {
            Object next = keys.next();
            hash.put(next.toString(), this.options.get(next).toString());
        }
        this.options = hash;
        s.defaultWriteObject();
    }
}

