/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.descriptor;

import java.io.Serializable;

public class AuthConstraints
implements Serializable {
    static final long serialVersionUID = 244967506576267285L;
    protected String description = null;
    protected String[] role_name = null;

    public AuthConstraints() {
    }

    public AuthConstraints(String[] roleName) {
        this.role_name = roleName;
    }

    public void setRoleName(String[] roleName) {
        this.role_name = roleName;
    }

    public String[] getRoleNames() {
        return this.role_name;
    }

    public void addRole(String role) {
        if (role == null) {
            return;
        }
        if (this.role_name == null || this.role_name.length == 0) {
            this.role_name = new String[1];
            this.role_name[0] = role;
        } else {
            String[] roles = new String[this.role_name.length + 1];
            System.arraycopy(this.role_name, 0, roles, 0, this.role_name.length);
            roles[this.role_name.length] = role;
            this.role_name = roles;
        }
    }

    public void removeRole(String role) {
        int index = -1;
        if (this.role_name != null) {
            int i = 0;
            while (i < this.role_name.length) {
                if (this.role_name[i].equals(role)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index > -1) {
            String[] newRoleNames = new String[this.role_name.length - 1];
            System.arraycopy(this.role_name, 0, newRoleNames, 0, index);
            System.arraycopy(this.role_name, index + 1, newRoleNames, index, this.role_name.length - 1 - index);
            this.role_name = newRoleNames;
        }
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        String[] roles = null;
        if (!(obj instanceof AuthConstraints)) return false;
        roles = ((AuthConstraints)obj).getRoleNames();
        if (this.role_name != null) {
            if (roles == null) return false;
            if (this.role_name.length != roles.length) return false;
            int index = -1;
            int i = 0;
            while (i < this.role_name.length) {
                index = -1;
                int j = 0;
                while (j < roles.length) {
                    if (this.role_name[i] != null) {
                        if (this.role_name[i].equals(roles[j])) {
                            index = j;
                        }
                    } else if (this.role_name[i] == roles[j]) {
                        index = j;
                    }
                    ++j;
                }
                if (index == -1) {
                    return false;
                }
                ++i;
            }
        } else if (roles != null) {
            return false;
        }
        if (this.description != null) {
            if (((AuthConstraints)obj).getDescription() == null) return false;
            if (this.description.equals(((AuthConstraints)obj).getDescription())) return true;
            return false;
        }
        if (((AuthConstraints)obj).description == null) return true;
        return false;
    }
}

