/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.policy;

import com.sap.engine.frame.ServiceException;
import com.sap.engine.interfaces.security.userstore.config.AuthenticationDescriptor;
import com.sap.engine.interfaces.security.userstore.config.AuthorizationDescriptor;
import com.sap.engine.interfaces.security.userstore.config.PolicyDescriptor;
import com.sap.engine.services.security.exceptions.SecurityServiceException;
import com.sap.engine.services.security.userstore.policy.PolicyConfigurationDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultPolicyDescriptor
implements PolicyDescriptor {
    String userstore = null;
    String anonymousUser = null;
    Hashtable policyConfigurations = new Hashtable();

    public DefaultPolicyDescriptor(Node node) throws ServiceException {
        this.userstore = this.readAttribute(node, "userstore");
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        String configName = null;
        int i = 0;
        while (i < list.getLength()) {
            element = list.item(i);
            elementName = element.getNodeName();
            if ("configuration".equalsIgnoreCase(elementName)) {
                configName = this.readAttribute(element, "name");
                PolicyConfigurationDescriptor config = new PolicyConfigurationDescriptor(element);
                this.policyConfigurations.put(configName, config);
            } else if (element.getNodeType() == 1) {
                System.out.println(" unknown element '" + elementName + "' in policy description.");
            }
            ++i;
        }
        if (this.policyConfigurations.get("SAP-J2EE-Engine") == null) {
            throw new SecurityServiceException("security_5020");
        }
    }

    public String getUserStore() throws SecurityException {
        return this.userstore;
    }

    public String getAnonymousUser() throws SecurityException {
        return this.anonymousUser;
    }

    public Enumeration listPolicyConfigurations() throws SecurityException {
        return this.policyConfigurations.keys();
    }

    public AuthorizationDescriptor getAuthorizationDescriptor(String policyConfiguration) throws SecurityException {
        return ((PolicyConfigurationDescriptor)this.policyConfigurations.get(policyConfiguration)).getAuthorization();
    }

    public AuthenticationDescriptor getAuthenticationDescriptor(String policyConfiguration) throws SecurityException {
        return ((PolicyConfigurationDescriptor)this.policyConfigurations.get(policyConfiguration)).getAuthentication();
    }

    private void readAnonymousUser(Node node) {
        this.anonymousUser = node.getFirstChild().getNodeValue();
    }

    private String readAttribute(Node node, String name) {
        NamedNodeMap attributes = node.getAttributes();
        Node current = null;
        int i = 0;
        while (i < attributes.getLength()) {
            current = attributes.item(i);
            if (current.getNodeName().equalsIgnoreCase(name)) {
                return current.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        String s = "";
        s = s + "<policy userstore=" + this.getUserStore() + ">\r\n";
        Enumeration e = this.listPolicyConfigurations();
        while (e.hasMoreElements()) {
            String configuration = (String)e.nextElement();
            s = s + "CONFGURATION " + configuration + "\r\n";
            s = s + this.policyConfigurations.get(configuration).toString() + "\r\n";
        }
        s = s + "</policy>\r\n";
        return s;
    }
}

