/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.policy;

import com.sap.engine.interfaces.security.userstore.config.AuthorizationDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultAuthorizationDescriptor
implements AuthorizationDescriptor {
    Hashtable userInRole = new Hashtable();
    Hashtable groupInRole = new Hashtable();

    public DefaultAuthorizationDescriptor(Node node) {
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = list.item(i);
            elementName = element.getNodeName();
            if ("security-role".equalsIgnoreCase(elementName)) {
                this.readSecurityRole(element);
            } else if (element.getNodeType() == 1) {
                System.out.println(" unknown element '" + elementName + "' in user-store description.");
            }
            ++i;
        }
    }

    public String[] listSecurityRoles() throws SecurityException {
        Enumeration keys = this.userInRole.keys();
        String[] roles = new String[this.userInRole.size()];
        int i = 0;
        while (i < roles.length) {
            roles[i] = (String)keys.nextElement();
            ++i;
        }
        return roles;
    }

    public String[] listUsersInRole(String role) throws SecurityException {
        return (String[])this.userInRole.get(role);
    }

    public String[] listGroupsInRole(String role) throws SecurityException {
        return (String[])this.groupInRole.get(role);
    }

    private void readSecurityRole(Node node) {
        String securityRole = null;
        NamedNodeMap attributes = node.getAttributes();
        Node current = null;
        int i = 0;
        while (i < attributes.getLength()) {
            current = attributes.item(i);
            if (current.getNodeName().equals("name")) {
                securityRole = current.getNodeValue();
            }
            ++i;
        }
        Vector<String> users = new Vector<String>();
        Vector<String> groups = new Vector<String>();
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        int i2 = 0;
        while (i2 < list.getLength()) {
            element = list.item(i2);
            elementName = element.getNodeName();
            if ("user".equalsIgnoreCase(elementName)) {
                users.addElement(element.getFirstChild().getNodeValue());
            } else if ("group".equalsIgnoreCase(elementName)) {
                groups.addElement(element.getFirstChild().getNodeValue());
            }
            ++i2;
        }
        String[] roleUsers = new String[users.size()];
        int i3 = 0;
        while (i3 < roleUsers.length) {
            roleUsers[i3] = (String)users.elementAt(i3);
            ++i3;
        }
        String[] roleGroups = new String[groups.size()];
        int i4 = 0;
        while (i4 < roleGroups.length) {
            roleGroups[i4] = (String)groups.elementAt(i4);
            ++i4;
        }
        this.userInRole.put(securityRole, roleUsers);
        this.groupInRole.put(securityRole, roleGroups);
    }

    public String toString() {
        String s = "";
        s = s + "<authorization>\r\n";
        String[] roles = this.listSecurityRoles();
        int i = 0;
        while (i < roles.length) {
            s = s + "<security-role name=" + roles[i] + ">\r\n";
            String[] users = this.listUsersInRole(roles[i]);
            s = s + "<users>\r\n";
            int j = 0;
            while (j < users.length) {
                s = s + users[j] + "\r\n";
                ++j;
            }
            s = s + "</users>\r\n";
            String[] groups = this.listGroupsInRole(roles[i]);
            s = s + "<groups>\r\n";
            int j2 = 0;
            while (j2 < groups.length) {
                s = s + groups[j2] + "\r\n";
                ++j2;
            }
            s = s + "</groups>\r\n";
            s = s + "</security-role>\r\n";
            ++i;
        }
        s = s + "</authorization>\r\n";
        return s;
    }
}

