/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.emergency;

import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class EmergencyUserInfoImpl
implements UserInfoSpi {
    public static final String USER_NAME = "SAP*";
    private char[] password = null;
    private Integer lockStatus = null;
    private java.security.Principal principal = null;
    private Date date = null;
    private long lastFailedLogonDate = 0L;
    private long lastSuccessfulLogonDate = 0L;
    private int failedLogonCount = 0;
    private int successfulLogonCount = 0;
    private final Vector PARENTS = new Vector(0);
    private final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];

    EmergencyUserInfoImpl() {
        this.principal = new Principal(USER_NAME);
        this.password = new char[]{'P', 'A', 'S', 'S'};
        this.lockStatus = new Integer(0);
        this.date = new Date(Calendar.getInstance().getTime().getTime());
    }

    public java.security.Principal engineGetPrincipal() {
        return this.principal;
    }

    public String engineGetName() {
        return this.principal.getName();
    }

    public Iterator engineGetParentGroups() throws SecurityException {
        return ((AbstractList)this.PARENTS).iterator();
    }

    public X509Certificate[] engineGetCertificates() throws SecurityException {
        return this.NO_CERTIFICATES;
    }

    public void engineSetPassword(char[] newPassword) throws SecurityException {
    }

    public void engineSetPassword(char[] oldPassword, char[] newPassword) throws SecurityException {
    }

    public void engineSetCertificates(X509Certificate[] certificates) throws SecurityException {
    }

    public Object engineReadUserProperty(int userProperty) throws SecurityException {
        switch (userProperty) {
            case 9: {
                return this.password;
            }
            case 11: {
                return new Long(-1L);
            }
            case 10: {
                return this.date;
            }
            case 1: {
                return this.date;
            }
            case 2: {
                return this.date;
            }
            case 4: {
                if (this.lastFailedLogonDate == 0L) {
                    return null;
                }
                Date date = new Date(this.lastFailedLogonDate);
                return date;
            }
            case 6: {
                if (this.lastSuccessfulLogonDate == 0L) {
                    return null;
                }
                Date date = new Date(this.lastSuccessfulLogonDate);
                return date;
            }
            case 5: {
                return new Integer(this.successfulLogonCount);
            }
            case 3: {
                return new Integer(this.failedLogonCount);
            }
            case 12: {
                return this.lockStatus;
            }
        }
        return null;
    }

    public void engineWriteUserProperty(int userProperty, Object value) throws SecurityException {
        switch (userProperty) {
            case 3: {
                if (!(value instanceof Integer)) break;
                this.failedLogonCount = (Integer)value;
                break;
            }
            case 5: {
                if (!(value instanceof Integer)) break;
                this.successfulLogonCount = (Integer)value;
                break;
            }
            case 4: {
                if (!(value instanceof Date)) break;
                this.lastFailedLogonDate = ((Date)value).getTime();
                break;
            }
            case 6: {
                if (!(value instanceof Date)) break;
                this.lastSuccessfulLogonDate = ((Date)value).getTime();
            }
        }
    }

    public boolean engineCheckUserProperty(int userProperty, Object value) throws SecurityException {
        if (userProperty == 9) {
            try {
                return this.engineCheckPassword((char[])value);
            }
            catch (ClassCastException e) {
                SecurityServerFrame.getLogger().logThrowable((byte)3, e);
                return false;
            }
        }
        throw new BaseSecurityException("security_5025");
    }

    public boolean engineCheckPassword(char[] targetPassword) throws SecurityException {
        if (targetPassword == null || targetPassword.length != 4) {
            return false;
        }
        if (targetPassword[0] != 'P' && targetPassword[0] != 'p') {
            return false;
        }
        if (targetPassword[1] != 'A' && targetPassword[1] != 'a') {
            return false;
        }
        if (targetPassword[2] != 'S' && targetPassword[2] != 's') {
            return false;
        }
        return targetPassword[3] == 'S' || targetPassword[3] == 's';
    }

    public String toString() {
        String result = "User ID:      " + this.engineGetName();
        result = result + "\nParent Groups: ";
        Iterator parents = this.engineGetParentGroups();
        while (parents.hasNext()) {
            result = result + (String)parents.next();
            if (!parents.hasNext()) continue;
            result = result + "\n               ";
        }
        result = result + "\n";
        return result;
    }
}

