/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.emergency;

import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.UserListener;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.interfaces.security.userstore.spi.UserContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.userstore.emergency.EmergencyUserInfoImpl;
import com.sap.engine.services.security.userstore.emergency.search.SearchFilterImpl;
import com.sap.engine.services.security.userstore.emergency.search.SearchResultImpl;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class EmergencyUserContextImpl
implements UserContextSpi {
    static final int PROPERTY_PASSWORD = 9;
    private UserInfoSpi userInfo = new EmergencyUserInfoImpl();
    private Vector users = new Vector(1);
    static /* synthetic */ Class class$com$sap$engine$lib$security$Principal;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public EmergencyUserContextImpl() {
        this.users.addElement(this.userInfo.engineGetName());
    }

    public void enginePropertiesChanged(Properties newProps) {
    }

    public Iterator engineListUsers() throws SecurityException {
        return ((AbstractList)this.users).iterator();
    }

    public SearchResult engineSearchUsers(SearchFilter filter) throws SecurityException {
        return new SearchResultImpl(this);
    }

    public Iterator engineListRootUsers() {
        return this.engineListUsers();
    }

    public UserInfoSpi engineGetUserInfo(String userName) throws SecurityException {
        return this.userInfo;
    }

    public UserInfoSpi engineGetUserInfo(X509Certificate cert) throws SecurityException {
        return this.userInfo;
    }

    public UserInfoSpi engineCreateUser(String userName) throws SecurityException {
        throw new BaseSecurityException("security_5030");
    }

    public void engineDeleteUser(String userName) throws SecurityException {
        throw new BaseSecurityException("security_5033");
    }

    public FilterUsername engineGetFilterUsername() throws SecurityException {
        throw new BaseSecurityException("security_5031");
    }

    public void engineSetFilterUsername(FilterUsername filterUsername) throws SecurityException {
        throw new BaseSecurityException("security_5031");
    }

    public FilterPassword engineGetFilterPassword() throws SecurityException {
        throw new BaseSecurityException("security_5032");
    }

    public void engineSetFilterPassword(FilterPassword filterPassword) throws SecurityException {
        throw new BaseSecurityException("security_5032");
    }

    public boolean engineIsUserPropertySupported(int userProperty, int operation) throws SecurityException {
        switch (userProperty) {
            case 1: {
                return operation == 1 || operation == 3;
            }
            case 2: {
                return operation == 1 || operation == 3;
            }
            case 3: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 4: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 5: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 6: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                return operation == 3 || operation == 1;
            }
            case 10: {
                return operation == 1 || operation == 3;
            }
            case 11: {
                return false;
            }
            case 12: {
                return operation == 1;
            }
        }
        return false;
    }

    public void engineRegisterListener(UserListener userListener, int modifier) throws SecurityException {
    }

    public void engineUnregisterListener(UserListener userlistener) throws SecurityException {
    }

    public boolean engineIsSubjectRetrievalSupported() {
        return true;
    }

    public long engineFillSubject(UserInfoSpi user, Subject subject) throws SecurityException {
        char[] password = (char[])this.userInfo.engineReadUserProperty(9);
        PasswordCredential credential = new PasswordCredential(this.userInfo.engineGetName(), password);
        subject.getPrivateCredentials().add(credential);
        subject.getPrincipals().add(this.userInfo.engineGetPrincipal());
        return Long.MAX_VALUE;
    }

    public void engineEmptySubject(Subject subject) throws SecurityException {
        try {
            Iterator principals = subject.getPrincipals(class$com$sap$engine$lib$security$Principal == null ? (class$com$sap$engine$lib$security$Principal = EmergencyUserContextImpl.class$("com.sap.engine.lib.security.Principal")) : class$com$sap$engine$lib$security$Principal).iterator();
            while (principals.hasNext()) {
                principals.next();
                principals.remove();
            }
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)0, e);
        }
        try {
            Iterator privateCredentials = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = EmergencyUserContextImpl.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential).iterator();
            while (privateCredentials.hasNext()) {
                privateCredentials.next();
                privateCredentials.remove();
            }
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)0, e);
        }
    }

    public int engineGetLockAfterInvalidAttempts() {
        return -1;
    }

    public boolean engineIsInEmergencyMode() {
        return true;
    }

    public boolean engineIsEmergencyUser(String userName) {
        return userName.equals(this.userInfo.engineGetName());
    }

    public String engineGetEmergencyUserName() {
        return this.userInfo.engineGetName();
    }

    public SearchFilter engineGetSearchFilter() {
        return new SearchFilterImpl();
    }

    public void engineRefresh(String userName) {
    }

    public String engineGetAnonymousUserName() {
        return this.userInfo.engineGetName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

