/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.descriptor;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.userstore.descriptor.LoginModuleConfigurationImpl;
import java.util.Properties;

public class UserStoreConfigurationImpl
implements UserStoreConfiguration {
    private boolean isActive;
    private String name;
    private String anonymous = null;
    private String description;
    private String editorClassName;
    private String groupContextClassName;
    private String userContextClassName;
    private Properties configuration = new Properties();
    private LoginModuleConfiguration[] modules;
    private String classLoaderName = null;

    public UserStoreConfigurationImpl(String userstoreName, Configuration container) {
        this.name = userstoreName;
        try {
            Configuration userstoreContainer = container.getSubConfiguration(userstoreName);
            this.classLoaderName = (String)userstoreContainer.getConfigEntry("classloader");
            this.description = (String)userstoreContainer.getConfigEntry("description");
            this.userContextClassName = (String)userstoreContainer.getConfigEntry("user-class-name");
            this.groupContextClassName = (String)userstoreContainer.getConfigEntry("group-class-name");
            this.editorClassName = (String)userstoreContainer.getConfigEntry("configuration-editor");
            if (userstoreContainer.existsConfigEntry("anonymous-user")) {
                this.anonymous = (String)userstoreContainer.getConfigEntry("anonymous-user");
            }
            this.readConfiguration(userstoreContainer.getSubConfiguration("configuration"));
            this.readLoginModules(userstoreContainer.getSubConfiguration("login-module"));
            this.readIsActive(container);
            if (this.anonymous == null) {
                this.anonymous = this.configuration.getProperty("anonymous-user");
            } else {
                this.configuration.setProperty("anonymous-user", this.anonymous);
            }
        }
        catch (Exception e) {
            throw new BaseSecurityException("security_5000", e);
        }
    }

    public String getConfigurationEditorClassName() {
        return this.editorClassName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getAnonymousUser() {
        return this.anonymous;
    }

    public LoginModuleConfiguration[] getLoginModules() {
        return this.modules;
    }

    public String getUserSpiClassName() {
        return this.userContextClassName;
    }

    public String getGroupSpiClassName() {
        return this.groupContextClassName;
    }

    public String getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    public Properties getUserStoreProperties() {
        return this.configuration;
    }

    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    private void readIsActive(Configuration userstoresContainer) throws Exception {
        String activeUserStore = (String)userstoresContainer.getConfigEntry("active_userstore");
        this.isActive = activeUserStore.equals(this.name);
    }

    private void readConfiguration(Configuration propsContainer) throws Exception {
        String[] attributes = propsContainer.getAllConfigEntryNames();
        int i = 0;
        while (i < attributes.length) {
            this.configuration.setProperty(attributes[i], (String)propsContainer.getConfigEntry(attributes[i]));
            ++i;
        }
    }

    private void readLoginModules(Configuration container) throws Exception {
        String[] allModules = container.getAllSubConfigurationNames();
        this.modules = new LoginModuleConfiguration[allModules.length];
        int i = 0;
        while (i < allModules.length) {
            this.modules[i] = new LoginModuleConfigurationImpl(container, allModules[i]);
            ++i;
        }
    }

    public String toString() {
        return "configuration \r\nname : " + this.name + "\r\n" + "UserSpiClass : " + this.userContextClassName + "\r\n" + "GroupSpiClass : " + this.groupContextClassName + "\r\n";
    }
}

