/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.descriptor;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class LoginModuleConfigurationImpl
implements LoginModuleConfiguration {
    private String name;
    private String description;
    private String loginModuleClassName;
    private Properties options = new Properties();
    private String[] suitableAuth = new String[0];
    private String[] notSuitableAuth = new String[0];
    private String editor = null;

    public LoginModuleConfigurationImpl(Configuration loginModulesContainer, String loginModuleName) throws Exception {
        this.name = loginModuleName;
        Configuration container = loginModulesContainer.getSubConfiguration(loginModuleName);
        this.description = (String)container.getConfigEntry("description");
        this.loginModuleClassName = (String)container.getConfigEntry("class-name");
        this.readOptions(container.getSubConfiguration("options"));
        this.suitableAuth = container.getSubConfiguration("suitable-mechanisms").getAllConfigEntryNames();
        this.notSuitableAuth = container.getSubConfiguration("not-suitable-mechanisms").getAllConfigEntryNames();
        if (container.existsConfigEntry("options-editor")) {
            this.editor = (String)container.getConfigEntry("options-editor");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String[] getNotSuitableAuthenticationMechanisms() {
        return this.notSuitableAuth;
    }

    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public Map getOptions() {
        return this.options;
    }

    public String[] getSuitableAuthenticationMechanisms() {
        return this.suitableAuth;
    }

    public String getOptionsEditor() {
        return this.editor;
    }

    private void readOptions(Configuration optionsContainer) throws Exception {
        String[] attributes = optionsContainer.getAllConfigEntryNames();
        int i = 0;
        while (i < attributes.length) {
            this.options.setProperty(attributes[i], (String)optionsContainer.getConfigEntry(attributes[i]));
            ++i;
        }
    }

    public static void store(Configuration container, LoginModuleConfiguration loginModuleConfig) throws Exception {
        Configuration loginModuleContainer = null;
        try {
            loginModuleContainer = container.createSubConfiguration(loginModuleConfig.getName());
        }
        catch (Exception e) {
            loginModuleContainer = container.getSubConfiguration(loginModuleConfig.getName());
        }
        try {
            loginModuleContainer.addConfigEntry("description", loginModuleConfig.getDescription());
        }
        catch (Exception e) {
            loginModuleContainer.modifyConfigEntry("description", loginModuleConfig.getDescription());
        }
        try {
            loginModuleContainer.addConfigEntry("class-name", loginModuleConfig.getLoginModuleClassName());
        }
        catch (Exception e) {
            loginModuleContainer.modifyConfigEntry("class-name", loginModuleConfig.getLoginModuleClassName());
        }
        Configuration optionsContainer = null;
        try {
            optionsContainer = loginModuleContainer.createSubConfiguration("options");
        }
        catch (Exception e) {
            optionsContainer = loginModuleContainer.getSubConfiguration("options");
        }
        Map options = loginModuleConfig.getOptions();
        Iterator enumeration = options.keySet().iterator();
        String key = null;
        while (enumeration.hasNext()) {
            key = (String)enumeration.next();
            try {
                optionsContainer.addConfigEntry(key, options.get(key));
            }
            catch (Exception e) {
                optionsContainer.modifyConfigEntry(key, options.get(key));
            }
        }
        String[] suitableMechanisms = loginModuleConfig.getSuitableAuthenticationMechanisms();
        Configuration suitableContainer = null;
        try {
            suitableContainer = loginModuleContainer.createSubConfiguration("suitable-mechanisms");
        }
        catch (Exception e) {
            suitableContainer = loginModuleContainer.getSubConfiguration("suitable-mechanisms");
        }
        int i = 0;
        while (i < suitableMechanisms.length) {
            try {
                suitableContainer.addConfigEntry(suitableMechanisms[i], new byte[0]);
            }
            catch (Exception e) {
                suitableContainer.modifyConfigEntry(suitableMechanisms[i], new byte[0]);
            }
            ++i;
        }
        String[] not_suitableMechanisms = loginModuleConfig.getNotSuitableAuthenticationMechanisms();
        Configuration not_suitableContainer = null;
        try {
            not_suitableContainer = loginModuleContainer.createSubConfiguration("not-suitable-mechanisms");
        }
        catch (Exception e) {
            not_suitableContainer = loginModuleContainer.getSubConfiguration("not-suitable-mechanisms");
        }
        int i2 = 0;
        while (i2 < not_suitableMechanisms.length) {
            try {
                not_suitableContainer.addConfigEntry(not_suitableMechanisms[i2], new byte[0]);
            }
            catch (Exception e) {
                not_suitableContainer.modifyConfigEntry(not_suitableMechanisms[i2], new byte[0]);
            }
            ++i2;
        }
        String editor = loginModuleConfig.getOptionsEditor();
        if (editor != null) {
            try {
                loginModuleContainer.addConfigEntry("options-editor", editor);
            }
            catch (Exception e) {
                loginModuleContainer.modifyConfigEntry("options-editor", editor);
            }
        }
    }
}

