/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.descriptor;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.userstore.descriptor.DefaultLoginModuleConfiguration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultUserStoreConfiguration
implements UserStoreConfiguration {
    private boolean isActive;
    private String name;
    private String description;
    private String editorClassName;
    private String groupContextClassName;
    private String userContextClassName;
    private Properties configuration = new Properties();
    private Properties startupConfiguration = new Properties();
    private LoginModuleConfiguration[] modules;
    private String anonymous = null;

    public DefaultUserStoreConfiguration(Node node) {
        String elementName = null;
        Node element = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            element = list.item(i);
            elementName = element.getNodeName();
            if ("display-name".equalsIgnoreCase(elementName)) {
                this.readDisplayName(element);
            } else if ("description".equalsIgnoreCase(elementName)) {
                this.readDescription(element);
            } else if ("user-class-name".equalsIgnoreCase(elementName)) {
                this.readUserContextClassName(element);
            } else if ("group-class-name".equalsIgnoreCase(elementName)) {
                this.readGroupContextClassName(element);
            } else if ("configuration-editor".equalsIgnoreCase(elementName)) {
                this.readConfigurationEditorClassName(element);
            } else if ("configuration".equalsIgnoreCase(elementName)) {
                this.readConfiguration(element, false);
            } else if ("startup-configuration".equalsIgnoreCase(elementName)) {
                this.readConfiguration(element, true);
            } else if ("login-module".equalsIgnoreCase(elementName)) {
                this.readLoginModule(element);
            } else if ("anonymous-user".equalsIgnoreCase(elementName)) {
                this.readAnonymousUser(element);
            } else if (element.getNodeType() == 1) {
                System.out.println(" unknown element '" + elementName + "' in user-store description.");
            }
            ++i;
        }
        this.readIsActive(node);
        if (this.anonymous == null) {
            this.anonymous = this.configuration.getProperty("anonymous-user");
        } else {
            this.configuration.setProperty("anonymous-user", this.anonymous);
        }
    }

    public String getConfigurationEditorClassName() {
        return this.editorClassName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getAnonymousUser() throws SecurityException {
        return this.anonymous;
    }

    public LoginModuleConfiguration[] getLoginModules() {
        return this.modules;
    }

    public String getUserSpiClassName() {
        return this.userContextClassName;
    }

    public String getGroupSpiClassName() {
        return this.groupContextClassName;
    }

    public String getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    public Properties getUserStoreProperties() {
        if (((Hashtable)this.startupConfiguration).size() == 0) {
            return this.configuration;
        }
        Properties result = new Properties();
        ((Hashtable)result).putAll(this.configuration);
        ((Hashtable)result).putAll(this.startupConfiguration);
        return result;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void clearStartupConfiguration() {
        ((Hashtable)this.startupConfiguration).clear();
    }

    private void readIsActive(Node node) {
        Node isActiveNode = node.getAttributes().getNamedItem("active");
        if (isActiveNode != null) {
            this.isActive = "yes".equalsIgnoreCase(isActiveNode.getNodeValue());
        }
    }

    private void readConfiguration(Node node, boolean startup) {
        NamedNodeMap attributes = node.getAttributes();
        Node current = null;
        int i = 0;
        while (i < attributes.getLength()) {
            current = attributes.item(i);
            if (!startup) {
                this.configuration.setProperty(current.getNodeName(), current.getNodeValue());
            } else {
                this.startupConfiguration.setProperty(current.getNodeName(), current.getNodeValue());
            }
            ++i;
        }
    }

    private void readDisplayName(Node node) {
        this.name = node.getFirstChild().getNodeValue();
    }

    private void readDescription(Node node) {
        this.description = node.getFirstChild().getNodeValue();
    }

    private void addLoginModule(LoginModuleConfiguration module) {
        if (this.modules == null) {
            this.modules = new LoginModuleConfiguration[1];
        } else {
            LoginModuleConfiguration[] temp = new LoginModuleConfiguration[this.modules.length + 1];
            System.arraycopy(this.modules, 0, temp, 0, this.modules.length);
            this.modules = temp;
        }
        this.modules[this.modules.length - 1] = module;
    }

    private void readLoginModule(Node node) {
        this.addLoginModule(new DefaultLoginModuleConfiguration(node));
    }

    private void readAnonymousUser(Node node) {
        this.anonymous = node.getFirstChild().getNodeValue();
    }

    private void readUserContextClassName(Node node) {
        this.userContextClassName = node.getFirstChild().getNodeValue();
    }

    private void readGroupContextClassName(Node node) {
        this.groupContextClassName = node.getFirstChild().getNodeValue();
    }

    private void readConfigurationEditorClassName(Node node) {
        this.editorClassName = node.getFirstChild().getNodeValue();
    }

    public String toString() {
        return "configuration \r\nname : " + this.name + "\r\n" + "UserSpiClass : " + this.userContextClassName + "\r\n" + "GroupSpiClass : " + this.groupContextClassName + "\r\n";
    }
}

