/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.context;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.restriction.Restrictions;
import com.sap.engine.services.security.userstore.context.UserContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;

public final class UserInfo
implements com.sap.engine.interfaces.security.userstore.context.UserInfo {
    private UserInfoSpi spi = null;
    private transient String username = null;
    private transient Principal principal = null;

    public UserInfo(UserInfoSpi spi) {
        this.spi = spi;
    }

    public Principal getPrincipal() {
        if (this.principal == null) {
            this.principal = this.spi.engineGetPrincipal();
        }
        return this.principal;
    }

    public String getName() {
        if (this.username == null) {
            this.username = this.spi.engineGetName();
        }
        return this.username;
    }

    public X509Certificate[] getCertificates() throws SecurityException {
        return this.spi.engineGetCertificates();
    }

    public void setPassword(char[] newPassword) throws SecurityException {
        if (!this.isCallerTheSameUser()) {
            Restrictions.checkPermission((int)0, (int)3);
        }
        this.spi.engineSetPassword(newPassword);
    }

    public void setPassword(char[] oldPassword, char[] newPassword) throws SecurityException {
        block2: {
            try {
                AccessController.checkPermission(UserContext.ALL_PERMISSION);
            }
            catch (AccessControlException se) {
                if (this.isCallerTheSameUser()) break block2;
                Restrictions.checkPermission((int)0, (int)3);
            }
        }
        this.spi.engineSetPassword(oldPassword, newPassword);
    }

    public void setCertificates(X509Certificate[] certificates) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)3);
        this.spi.engineSetCertificates(certificates);
    }

    public Iterator getParentGroups() throws SecurityException {
        return this.spi.engineGetParentGroups();
    }

    public Object readUserProperty(int userProperty) throws SecurityException {
        if (userProperty == 9 && !this.isCallerTheSameUser()) {
            try {
                AccessController.checkPermission(UserContext.ALL_PERMISSION);
            }
            catch (AccessControlException se) {
                Restrictions.checkPermission((int)0, (int)2);
            }
        }
        return this.spi.engineReadUserProperty(userProperty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeUserProperty(int userProperty, Object value) throws SecurityException {
        if (userProperty == 9) {
            if (!this.isCallerTheSameUser()) {
                Restrictions.checkPermission((int)0, (int)3);
            }
            try {
                this.spi.engineSetPassword((char[])value);
                return;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SecurityException("Password must be of type char[].");
            }
        }
        if (userProperty == 3 || userProperty == 4 || userProperty == 6 || userProperty == 5) {
            try {
                AccessController.checkPermission(UserContext.ALL_PERMISSION);
            }
            catch (AccessControlException se) {
                Restrictions.checkPermission((int)0, (int)3);
            }
        } else if (userProperty == 12) {
            if (this.isCallerTheSameUser()) throw new BaseSecurityException("security_5024");
            Restrictions.checkPermission((int)0, (int)3);
        } else {
            Restrictions.checkPermission((int)0, (int)3);
        }
        this.spi.engineWriteUserProperty(userProperty, value);
    }

    public boolean checkUserProperty(int userProperty, Object value) throws SecurityException {
        return this.spi.engineCheckUserProperty(userProperty, value);
    }

    public boolean checkPassword(char[] password) throws SecurityException {
        return this.spi.engineCheckPassword(password);
    }

    protected UserInfoSpi getSpi() {
        return this.spi;
    }

    public String toString() {
        return this.spi.toString();
    }

    private SecurityContextObject getCurrentSecurityContext() {
        ThreadContext threadContext = SecurityServerFrame.threadContext.getThreadContext();
        if (threadContext != null) {
            return (SecurityContextObject)((Object)threadContext.getContextObject("security"));
        }
        return null;
    }

    private boolean isCallerTheSameUser() {
        SecurityContextObject threadContext = this.getCurrentSecurityContext();
        if (threadContext != null) {
            return threadContext.getSession().getPrincipal().getName().equals(this.spi.engineGetPrincipal().getName());
        }
        return false;
    }
}

