/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.context;

import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.UserListener;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.interfaces.security.userstore.spi.UserContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.services.security.restriction.Restrictions;
import com.sap.engine.services.security.userstore.context.UserInfo;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Properties;
import javax.security.auth.Subject;

public class UserContext
implements com.sap.engine.interfaces.security.userstore.context.UserContext {
    public static final AllPermission ALL_PERMISSION = new AllPermission();
    private UserContextSpi spi = null;

    public UserContext(UserContextSpi spi, Properties props) {
        this.spi = spi;
        this.spi.enginePropertiesChanged(props);
    }

    public void propertiesChanged(Properties newprops) {
        Restrictions.checkPermission((int)0, (int)4);
        this.spi.enginePropertiesChanged(newprops);
    }

    public void registerListener(UserListener userListener, int modifier) throws SecurityException {
    }

    public void unregisterListener(UserListener listener) throws SecurityException {
    }

    public Iterator listUsers() throws SecurityException {
        return this.spi.engineListUsers();
    }

    public SearchResult searchUsers(SearchFilter filter) throws SecurityException {
        return this.spi.engineSearchUsers(filter);
    }

    public com.sap.engine.interfaces.security.userstore.context.UserInfo getUserInfo(String userName) throws SecurityException {
        UserInfoSpi userSpi = this.spi.engineGetUserInfo(userName);
        if (userSpi == null) {
            throw new SecurityException(" Unable to get user " + userName);
        }
        return new UserInfo(userSpi);
    }

    public com.sap.engine.interfaces.security.userstore.context.UserInfo getUserInfo(X509Certificate cert) throws SecurityException {
        return new UserInfo(this.spi.engineGetUserInfo(cert));
    }

    public com.sap.engine.interfaces.security.userstore.context.UserInfo createUser(String userName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)0);
        FilterUsername filter = this.spi.engineGetFilterUsername();
        if (filter != null && !filter.filterUsername(userName)) {
            throw new SecurityException("Name " + userName + " is not allowed for current configuration");
        }
        return new UserInfo(this.spi.engineCreateUser(userName));
    }

    public com.sap.engine.interfaces.security.userstore.context.UserInfo createUserInternal(String userName) throws SecurityException {
        return new UserInfo(this.spi.engineCreateUser(userName));
    }

    public void deleteUser(String userName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)1);
        this.spi.engineDeleteUser(userName);
    }

    public FilterUsername getFilterUsername() throws SecurityException {
        return this.spi.engineGetFilterUsername();
    }

    public void setFilterUsername(FilterUsername filter) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)4);
        this.spi.engineSetFilterUsername(filter);
    }

    public FilterPassword getFilterPassword() throws SecurityException {
        return this.spi.engineGetFilterPassword();
    }

    public void setFilterPassword(FilterPassword filter) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)4);
        this.spi.engineSetFilterPassword(filter);
    }

    public boolean isUserPropertySupported(int userProperty, int operation) throws SecurityException {
        return this.spi.engineIsUserPropertySupported(userProperty, operation);
    }

    public boolean isSubjectRetrievalSupported() {
        return this.spi.engineIsSubjectRetrievalSupported();
    }

    public long fillSubject(com.sap.engine.interfaces.security.userstore.context.UserInfo user, Subject subject) throws SecurityException {
        try {
            AccessController.checkPermission(ALL_PERMISSION);
        }
        catch (AccessControlException se) {
            Restrictions.checkPermission((int)0, (int)6);
        }
        return this.spi.engineFillSubject(((UserInfo)user).getSpi(), subject);
    }

    public void emptySubject(Subject subject) throws SecurityException {
        try {
            AccessController.checkPermission(ALL_PERMISSION);
        }
        catch (AccessControlException se) {
            Restrictions.checkPermission((int)0, (int)7);
        }
        this.spi.engineEmptySubject(subject);
    }

    public Iterator listRootUsers() {
        return this.spi.engineListRootUsers();
    }

    public int getLockAfterInvalidAttempts() {
        return this.spi.engineGetLockAfterInvalidAttempts();
    }

    public boolean isInEmergencyMode() {
        return this.spi.engineIsInEmergencyMode();
    }

    public boolean isEmergencyUser(String userName) {
        return this.spi.engineIsEmergencyUser(userName);
    }

    public String getEmergencyUserName() {
        return this.spi.engineGetEmergencyUserName();
    }

    public SearchFilter getSearchFilter() {
        return this.spi.engineGetSearchFilter();
    }

    public void refresh(String userName) {
        this.spi.engineRefresh(userName);
    }

    public String getAnonymousUserName() {
        return this.spi.engineGetAnonymousUserName();
    }
}

