/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore.context;

import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.GroupListener;
import com.sap.engine.interfaces.security.userstore.spi.GroupContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.GroupInfoSpi;
import com.sap.engine.services.security.restriction.Restrictions;
import com.sap.engine.services.security.userstore.context.GroupInfo;
import java.util.Iterator;
import java.util.Properties;

public class GroupContext
implements com.sap.engine.interfaces.security.userstore.context.GroupContext {
    private GroupContextSpi spi = null;

    public GroupContext(GroupContextSpi spi, Properties props) {
        this.spi = spi;
        this.spi.enginePropertiesChanged(props);
    }

    public void propertiesChanged(Properties newprops) {
        Restrictions.checkPermission((int)0, (int)4);
        this.spi.enginePropertiesChanged(newprops);
    }

    public void registerListener(GroupListener groupListener, int modifier) throws SecurityException {
    }

    public void unregisterListener(GroupListener listener) throws SecurityException {
    }

    public Iterator listGroups() throws SecurityException {
        return this.spi.engineListGroups();
    }

    public SearchResult searchGroups(SearchFilter filter) throws SecurityException {
        return this.spi.engineSearchGroups(filter);
    }

    public com.sap.engine.interfaces.security.userstore.context.GroupInfo getGroupInfo(String groupName) throws SecurityException {
        GroupInfoSpi infoSpi = this.spi.engineGetGroupInfo(groupName);
        if (this.spi == null) {
            return null;
        }
        return new GroupInfo(infoSpi);
    }

    public com.sap.engine.interfaces.security.userstore.context.GroupInfo createGroup(String groupName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)0);
        GroupInfoSpi groupSpi = this.spi.engineCreateGroup(groupName);
        if (this.spi != null) {
            return new GroupInfo(groupSpi);
        }
        return null;
    }

    public void deleteGroup(String groupName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)1);
        this.spi.engineDeleteGroup(groupName);
    }

    public void addGroupToParent(String groupName, String parentName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)5);
        this.spi.engineAddGroupToParent(groupName, parentName);
    }

    public void removeGroupFromParent(String groupName, String parentName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)5);
        this.spi.engineRemoveGroupFromParent(groupName, parentName);
    }

    public Iterator getChildGroups(String groupName) throws SecurityException {
        return this.spi.engineGetChildGroups(groupName);
    }

    public Iterator getParentGroups(String groupName) throws SecurityException {
        return this.spi.engineGetParentGroups(groupName);
    }

    public void addUserToGroup(String userName, String groupName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)5);
        this.spi.engineAddUserToGroup(userName, groupName);
    }

    public void removeUserFromGroup(String userName, String groupName) throws SecurityException {
        Restrictions.checkPermission((int)0, (int)5);
        this.spi.engineRemoveUserFromGroup(userName, groupName);
    }

    public Iterator getUsersOfGroup(String groupName) throws SecurityException {
        return this.spi.engineGetUsersOfGroup(groupName);
    }

    public Iterator getGroupsOfUser(String userName) throws SecurityException {
        return this.spi.engineGetGroupsOfUser(userName);
    }

    public Iterator listRootGroups() {
        return this.spi.engineListRootGroups();
    }

    public SearchFilter getSearchFilter() {
        return this.spi.engineGetSearchFilter();
    }

    public void refresh(String groupName) {
        this.spi.engineRefresh(groupName);
    }
}

