/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore;

import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.AuthorizationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import com.sap.engine.services.security.server.AuthorizationContextImpl;
import com.sap.engine.services.security.server.SecurityContextImpl;

public class UserStoreSwitchHelper {
    private SecurityContext security = null;

    public UserStoreSwitchHelper(SecurityContext security) {
        this.security = security;
    }

    public void onActiveUserStoreChanged() {
        SecurityContext securityContext = this.security;
        synchronized (securityContext) {
            try {
                SecurityServerFrame.updateEmergencyModeFlag();
                this.updateAuthentication();
                this.updateAuthorization();
                this.updateLogger();
                UserStore userStore = SecurityContextImpl.getRoot().getUserStoreContext().getActiveUserStore();
                com.sap.engine.services.security.login.SecurityContext.setAnonymousPrincipal(userStore);
            }
            catch (Exception e) {
                SecurityServerFrame.getLogger().logThrowable((byte)5, e);
            }
        }
    }

    private void updateAuthentication() {
        String[] policies = this.security.listPolicyConfigurations();
        AuthenticationContext authentication = null;
        int i = 0;
        while (i < policies.length) {
            authentication = this.security.getPolicyConfigurationContext(policies[i]).getAuthenticationContext();
            if (authentication instanceof AuthenticationContextImpl) {
                ((AuthenticationContextImpl)authentication).update();
            }
            ++i;
        }
    }

    private void updateAuthorization() {
        String[] policies = this.security.listPolicyConfigurations();
        AuthorizationContext authorization = null;
        int i = 0;
        while (i < policies.length) {
            authorization = this.security.getPolicyConfigurationContext(policies[i]).getAuthorizationContext();
            if (authorization instanceof AuthorizationContextImpl) {
                ((AuthorizationContextImpl)authorization).update();
            }
            ++i;
        }
    }

    private void updateLogger() {
        if (this.security instanceof SecurityContextImpl) {
            ((SecurityContextImpl)this.security).getLogonInfoLogger().update();
            ((SecurityContextImpl)this.security).getLoginModuleHelper().update();
        }
    }
}

