/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore;

import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.remote.UserStoreListenerCallback;
import com.sap.engine.services.security.userstore.RemoteUserStoreImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class RemoteUserStoreFactoryImpl
extends PortableRemoteObject
implements RemoteUserStoreFactory {
    private UserStoreFactory factory = null;

    public RemoteUserStoreFactoryImpl(UserStoreFactory factory) throws RemoteException {
        this.factory = factory;
    }

    public RemoteUserStore getActiveUserStore() throws RemoteException {
        return new RemoteUserStoreImpl(this.factory.getActiveUserStore());
    }

    public void setActiveUserStore(String name) throws RemoteException {
        this.factory.setActiveUserStore(name);
    }

    public RemoteUserStore getUserStore(String name) throws RemoteException {
        if (this.factory.getUserStore(name) != null) {
            return new RemoteUserStoreImpl(this.factory.getUserStore(name));
        }
        return null;
    }

    public RemoteUserStore[] listUserStores() throws RemoteException {
        UserStore[] stores = this.factory.listUserStores();
        RemoteUserStore[] remotes = new RemoteUserStore[stores.length];
        int i = 0;
        while (i < remotes.length) {
            remotes[i] = new RemoteUserStoreImpl(stores[i]);
            ++i;
        }
        return remotes;
    }

    public void registerUserStore(UserStoreConfiguration config) throws RemoteException {
        this.factory.registerUserStore(config, this.getClass().getClassLoader());
    }

    public void updateUserStore(UserStoreConfiguration config) throws RemoteException {
        this.factory.updateUserStore(config, this.getClass().getClassLoader());
    }

    public void unregisterUserStore(String name) throws RemoteException {
        this.factory.unregisterUserStore(name);
    }

    public void registerListener(UserStoreListenerCallback listener) throws RemoteException {
        this.factory.registerListener(listener);
    }

    public void unregisterListener(UserStoreListenerCallback listener) throws RemoteException {
        this.factory.unregisterListener(listener);
    }
}

