/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.userstore;

import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.userstore.RemoteGroupInfoImpl;
import com.sap.engine.services.security.userstore.RemoteIteratorImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class RemoteGroupContextImpl
extends PortableRemoteObject
implements RemoteGroupContext {
    private GroupContext context = null;

    public RemoteGroupContextImpl(GroupContext context) throws RemoteException {
        this.context = context;
    }

    public RemoteIterator listGroups() throws RemoteException {
        return new RemoteIteratorImpl(this.context.listGroups());
    }

    public RemoteIterator searchGroups(SearchFilter filter) throws RemoteException {
        return new RemoteIteratorImpl(this.context.searchGroups(filter));
    }

    public RemoteGroupInfo getGroupInfo(String groupName) throws RemoteException {
        return new RemoteGroupInfoImpl(this.context.getGroupInfo(groupName));
    }

    public void createGroup(String groupName) throws RemoteException {
        this.context.createGroup(groupName);
    }

    public void deleteGroup(String groupName) throws RemoteException {
        this.context.deleteGroup(groupName);
    }

    public void addGroupToParent(String groupName, String parentName) throws RemoteException {
        this.context.addGroupToParent(groupName, parentName);
    }

    public void removeGroupFromParent(String groupName, String parentName) throws RemoteException {
        this.context.removeGroupFromParent(groupName, parentName);
    }

    public RemoteIterator getChildGroups(String groupName) throws RemoteException {
        return new RemoteIteratorImpl(this.context.getChildGroups(groupName));
    }

    public RemoteIterator getParentGroups(String groupName) throws RemoteException {
        return new RemoteIteratorImpl(this.context.getParentGroups(groupName));
    }

    public void addUserToGroup(String userName, String groupName) throws RemoteException {
        this.context.addUserToGroup(userName, groupName);
    }

    public void removeUserFromGroup(String userName, String groupName) throws RemoteException {
        this.context.removeUserFromGroup(userName, groupName);
    }

    public RemoteIterator getUsersOfGroup(String groupName) throws RemoteException {
        return new RemoteIteratorImpl(this.context.getUsersOfGroup(groupName));
    }

    public RemoteIterator getGroupsOfUser(String userName) throws RemoteException {
        return new RemoteIteratorImpl(this.context.getGroupsOfUser(userName));
    }

    public RemoteIterator listRootGroups() throws RemoteException {
        return new RemoteIteratorImpl(this.context.listRootGroups());
    }

    public SearchFilter getSearchFilter() {
        return this.context.getSearchFilter();
    }

    public void refresh(String groupName) {
        this.context.refresh(groupName);
    }
}

