/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.roles;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.exceptions.BaseIllegalStateException;
import com.sap.engine.services.security.roles.SecurityRoleContextImpl;

public class SecurityRoleReference
implements SecurityRole,
Comparable {
    static final long serialVersionUID = 9150184898356412450L;
    private String name = null;
    private String referencePolicy = null;
    private SecurityRole reference = null;
    private String runAsIdentity = null;
    private transient SecurityRoleContextImpl context = null;

    public SecurityRoleReference(String name, String referencePolicy, SecurityRole reference) {
        this.name = name;
        this.reference = reference;
        this.referencePolicy = referencePolicy;
    }

    public SecurityRoleReference(String name, String referencePolicy, SecurityRole reference, String runAsIdentity) {
        this.name = name;
        this.reference = reference;
        this.referencePolicy = referencePolicy;
        this.runAsIdentity = runAsIdentity;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.reference.getDescription();
    }

    public String[] getGroups() {
        return this.reference.getGroups();
    }

    public String[] getReference() {
        return new String[]{this.referencePolicy, this.reference.getName()};
    }

    protected void setReference(String name, SecurityRole reference) {
        this.name = name;
        this.reference = reference;
    }

    public String[] getUsers() {
        return this.reference.getUsers();
    }

    public boolean isCallerInRole() {
        this.context.refreshSecurityRole(this);
        return this.reference.isCallerInRole();
    }

    public void addGroup(String groupName) {
        throw new BaseIllegalStateException("security_3000");
    }

    public void addUser(String userName) {
        throw new BaseIllegalStateException("security_3001");
    }

    public void removeGroup(String groupName) {
        throw new BaseIllegalStateException("security_3002");
    }

    public void removeUser(String userName) {
        throw new BaseIllegalStateException("security_3003");
    }

    public void setDescription(String description) {
        throw new BaseIllegalStateException("security_3004");
    }

    public String toString() {
        return this.name + " [" + this.referencePolicy + ":" + this.reference.getName() + "]";
    }

    public int compareTo(Object o) {
        return 0;
    }

    protected void setContext(SecurityRoleContextImpl context) {
        this.context = context;
    }

    public String getRunAsIdentity(boolean forceAssociation) {
        if (this.context != null) {
            this.runAsIdentity = this.context.getRunAsIdentity(this, forceAssociation);
        }
        return this.runAsIdentity;
    }

    public void setRunAsIdentity(String principal) {
        this.runAsIdentity = principal;
        if (this.context != null) {
            this.context.setRunAsIdentity(this, principal);
        }
    }

    public void setRunAsAccountGenerationPolicy(byte type) {
        if (this.context != null) {
            this.context.setRunAsAccountGenerationPolicy(this, type);
        }
    }
}

