/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.roles;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.GroupInfo;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.lang.SWMRG;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.login.AuthorizationEntry;
import com.sap.engine.services.security.login.SecurityContext;
import com.sap.engine.services.security.roles.SecurityRoleContextImpl;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

public class SecurityRoleImpl
implements SecurityRole,
Serializable,
Comparable {
    static final long serialVersionUID = 9150184898356412447L;
    private String name = null;
    private String description = null;
    private HashSet users = null;
    private HashSet groups = null;
    private String runAsIdentity = null;
    private transient SWMRG guard = new SWMRG();
    private transient SecurityRoleContextImpl context = null;

    public SecurityRoleImpl(String name) {
        this.name = name;
        this.description = "";
        this.users = new HashSet();
        this.groups = new HashSet();
    }

    public SecurityRoleImpl(String name, String[] users, String[] groups) {
        this(name);
        this.setUsers(users);
        this.setGroups(groups);
    }

    public SecurityRoleImpl(String name, String[] users, String[] groups, String runAsIdentity) {
        this(name);
        this.setUsers(users);
        this.setGroups(groups);
        this.runAsIdentity = runAsIdentity;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getGroups() {
        String[] result = new String[this.groups.size()];
        Iterator iterator = this.groups.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = (String)iterator.next();
            ++i;
        }
        return result;
    }

    public String[] getUsers() {
        String[] result = new String[this.users.size()];
        Iterator iterator = this.users.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = (String)iterator.next();
            ++i;
        }
        return result;
    }

    public boolean isCallerInRole() {
        AuthorizationEntry authorization = this.getCurrentAuthorizationContext();
        if (authorization == null) {
            return true;
        }
        if (authorization.impliesSecurityRole(this.name)) {
            return true;
        }
        if (authorization.notImpliesSecurityRole(this.name)) {
            return false;
        }
        boolean inRole = this.isCallerInRolePersistent();
        if (inRole) {
            authorization.addImpliedRole(this.name);
        } else {
            authorization.addNotImpliedRole(this.name);
        }
        return inRole;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCallerInRolePersistent() {
        boolean bl;
        block6: {
            boolean bl2;
            block7: {
                boolean bl3;
                block5: {
                    this.context.refreshSecurityRole(this);
                    String caller = SecurityRoleContextImpl.getCallerName();
                    this.guard.startRead();
                    try {
                        if (this.users.contains(caller)) {
                            boolean bl4 = true;
                            Object var7_4 = null;
                            this.guard.endRead();
                            return bl4;
                        }
                        UserInfo info = this.getUserContext().getUserInfo(caller);
                        if (info == null) {
                            bl3 = false;
                            break block5;
                        }
                        Iterator parents = info.getParentGroups();
                        HashSet checkedParents = new HashSet();
                        do {
                            if (parents.hasNext()) continue;
                            bl = false;
                            break block6;
                        } while (!this.checkGroup((String)parents.next(), checkedParents));
                        bl2 = true;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        this.guard.endRead();
                        throw throwable;
                    }
                }
                Object var7_5 = null;
                this.guard.endRead();
                return bl3;
            }
            Object var7_6 = null;
            this.guard.endRead();
            return bl2;
        }
        Object var7_7 = null;
        this.guard.endRead();
        return bl;
    }

    private boolean checkGroup(String parentGroup, HashSet checkedParents) {
        try {
            if (this.groups.contains(parentGroup)) {
                return true;
            }
            GroupInfo info = this.getGroupContext().getGroupInfo(parentGroup);
            if (info == null) {
                return false;
            }
            Iterator parents = info.getParentGroups();
            String nextParent = null;
            while (parents.hasNext()) {
                nextParent = (String)parents.next();
                if (checkedParents.contains(nextParent)) continue;
                checkedParents.add(nextParent);
                if (!this.checkGroup(nextParent, checkedParents)) continue;
                return true;
            }
        }
        catch (Exception e) {
            SecurityServerFrame.getLogger().logThrowable((byte)4, e);
        }
        return false;
    }

    public void addGroup(String groupName) {
        if (!this.groups.contains(groupName)) {
            this.groups.add(groupName);
            if (this.context != null) {
                this.context.modifySecurityRole(this);
            }
        }
    }

    public void addUser(String userName) {
        if (!this.users.contains(userName)) {
            this.users.add(userName);
            if (this.context != null) {
                this.context.modifySecurityRole(this);
            }
        }
    }

    protected void addUser(String userName, Configuration configuration) {
        if (!this.users.contains(userName)) {
            this.users.add(userName);
            if (this.context != null) {
                this.context.modifySecurityRole(this, configuration);
            }
        }
    }

    void addUserInternal(String userName, Configuration configuration) {
        if (!this.users.contains(userName)) {
            this.users.add(userName);
            if (this.context != null) {
                this.context.modifySecurityRoleInternal(this, configuration);
            }
        }
    }

    public void removeGroup(String groupName) {
        this.groups.remove(groupName);
        if (this.context != null) {
            this.context.modifySecurityRole(this);
        }
    }

    public String[] getReference() {
        return new String[0];
    }

    public void removeUser(String userName) {
        this.users.remove(userName);
        if (this.context != null) {
            this.context.modifySecurityRole(this);
        }
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.context != null) {
            this.context.modifySecurityRole(this);
        }
    }

    public String toString() {
        return this.name;
    }

    public String getRunAsIdentity(boolean forceAssociation) {
        if (this.context != null) {
            this.runAsIdentity = this.context.getRunAsIdentity(this, forceAssociation);
        }
        return this.runAsIdentity;
    }

    public void setRunAsIdentity(String principal) {
        this.runAsIdentity = principal;
        if (this.context != null) {
            this.context.setRunAsIdentity(this, principal);
        }
    }

    public void setRunAsAccountGenerationPolicy(byte type) {
        if (this.context != null) {
            this.context.setRunAsAccountGenerationPolicy(this, type);
        }
    }

    protected void setContext(SecurityRoleContextImpl context) {
        this.context = context;
    }

    protected void setUsers(String[] users) {
        this.guard.startWrite();
        try {
            this.users.clear();
            int i = 0;
            while (i < users.length) {
                this.users.add(users[i]);
                ++i;
            }
            Object var4_3 = null;
            this.guard.endWrite();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }

    protected void setGroups(String[] groups) {
        this.guard.startWrite();
        try {
            this.groups.clear();
            int i = 0;
            while (i < groups.length) {
                this.groups.add(groups[i]);
                ++i;
            }
            Object var4_3 = null;
            this.guard.endWrite();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.guard.endWrite();
            throw throwable;
        }
    }

    private UserContext getUserContext() {
        UserStoreFactory factory = this.context.getUserStoreFactory();
        UserStore active = factory.getActiveUserStore();
        return active.getUserContext();
    }

    private GroupContext getGroupContext() {
        UserStoreFactory factory = this.context.getUserStoreFactory();
        UserStore active = factory.getActiveUserStore();
        return active.getGroupContext();
    }

    public int compareTo(Object o) {
        return 0;
    }

    private AuthorizationEntry getCurrentAuthorizationContext() {
        ThreadContext tc = SecurityServerFrame.threadContext.getThreadContext();
        if (tc == null) {
            return null;
        }
        SecurityContext securityContext = (SecurityContext)tc.getContextObject("security");
        if (securityContext == null) {
            return null;
        }
        return securityContext.getAuthorizationExtension().getAuthorizationEntry(this.context.policyConfiguration);
    }
}

