/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.roles;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseIllegalStateException;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.restriction.Restrictions;
import com.sap.engine.services.security.roles.SecurityRoleImpl;
import com.sap.engine.services.security.roles.SecurityRoleReference;
import com.sap.engine.services.security.roles.SecurityRoleSerializator;
import com.sap.engine.services.security.server.ModificationContextImpl;
import com.sap.engine.services.security.userstore.context.UserContext;
import com.sap.exception.IBaseException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;

public class SecurityRoleContextImpl
implements SecurityRoleContext {
    private static final byte CREATE_RUN_AS_IDENTITY_CONFIG = 0;
    private static final byte GENERATE_RUN_AS_IDENTITY = 1;
    private static final byte ADD_RUN_AS_IDENTITY_TO_ROLE = 2;
    private byte run_as_state;
    protected String policyConfiguration = null;
    private String path = null;
    private SecurityContext root = null;

    public SecurityRoleContextImpl(SecurityContext root, String config, String userStore) {
        this.root = root;
        this.policyConfiguration = config;
        this.path = "security/roles/" + userStore;
    }

    public SecurityRole addSecurityRole(String securityRole) {
        Restrictions.checkPermission((int)2, (int)0, (String)this.policyConfiguration);
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            Configuration configuration = mc.getConfiguration(this.path, true, true);
            if (SecurityRoleSerializator.existsSecurityRole(configuration, securityRole)) {
                throw new BaseSecurityException("security_3005", new Object[]{securityRole});
            }
            SecurityRoleImpl role = new SecurityRoleImpl(securityRole);
            role.setContext(this);
            SecurityRoleSerializator.storeSecurityRole(configuration, role);
            mc.commitModifications();
            return role;
        }
        catch (SecurityException se) {
            mc.rollbackModifications();
            if (se instanceof IBaseException) {
                throw se;
            }
            throw new BaseSecurityException("security_3006", se);
        }
    }

    public SecurityRole addSecurityRoleReference(String roleName, String policyConfiguration, String securityRole) {
        Restrictions.checkPermission((int)2, (int)0, (String)policyConfiguration);
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            SecurityContext policy = this.root.getPolicyConfigurationContext(policyConfiguration);
            if (policy == null) {
                throw new BaseSecurityException("security_3007", new Object[]{policyConfiguration});
            }
            SecurityRole reference = policy.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(securityRole);
            if (reference == null) {
                throw new BaseSecurityException("security_3014", new Object[]{securityRole});
            }
            Configuration configuration = mc.getConfiguration(this.path, true, true);
            if (SecurityRoleSerializator.existsSecurityRole(configuration, roleName)) {
                throw new BaseSecurityException("security_3008", new Object[]{roleName});
            }
            SecurityRoleSerializator.storeSecurityRole(configuration, new SecurityRoleReference(roleName, policyConfiguration, reference));
            mc.commitModifications();
            return new SecurityRoleReference(roleName, policyConfiguration, reference);
        }
        catch (SecurityException se) {
            mc.rollbackModifications();
            if (se instanceof IBaseException) {
                throw se;
            }
            throw new BaseSecurityException("security_3009", se);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SecurityRole[] listSecurityRoles() {
        SecurityRole[] securityRoleArray;
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            try {
                int compact = 0;
                Configuration configuration = mc.getConfiguration(this.path, false, false);
                if (configuration != null) {
                    SecurityRole[] all;
                    block16: {
                        String[] names = configuration.getAllSubConfigurationNames();
                        all = new SecurityRole[names.length];
                        int i = 0;
                        while (true) {
                            if (i >= names.length) {
                                if (compact > 0) {
                                    break;
                                }
                                break block16;
                            }
                            all[i] = SecurityRoleSerializator.loadSecurityRole(this.root, configuration, names[i]);
                            if (all[i] == null) {
                                ++compact;
                            } else if (all[i] instanceof SecurityRoleImpl) {
                                ((SecurityRoleImpl)all[i]).setContext(this);
                            }
                            ++i;
                        }
                        SecurityRole[] temp = new SecurityRole[all.length - compact];
                        int i2 = 0;
                        int j = 0;
                        while (true) {
                            if (i2 >= temp.length) {
                                all = temp;
                                break;
                            }
                            if (all[j] != null) {
                                temp[i2] = all[j];
                            } else {
                                --i2;
                            }
                            ++j;
                            ++i2;
                        }
                    }
                    SecurityRole[] securityRoleArray2 = all;
                    Object var11_9 = null;
                    mc.forgetModifications();
                    return securityRoleArray2;
                }
                securityRoleArray = new SecurityRole[]{};
                Object var11_8 = null;
            }
            catch (SecurityException se) {
                if (!(se instanceof IBaseException)) throw new BaseSecurityException("security_3010", se);
                throw se;
            }
            catch (Exception se) {
                throw new BaseSecurityException("security_3011", se);
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            mc.forgetModifications();
            throw throwable;
        }
        mc.forgetModifications();
        return securityRoleArray;
    }

    public SecurityRole[] listSecurityRolesOfGroup(String groupName) {
        throw new BaseIllegalStateException("security_3012");
    }

    public SecurityRole[] listSecurityRolesOfUser(String userName) {
        throw new BaseIllegalStateException("security_3013");
    }

    public void removeSecurityRole(String securityRole) {
        Restrictions.checkPermission((int)2, (int)2, (String)this.policyConfiguration);
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            Configuration configuration = mc.getConfiguration(this.path, true, false);
            if (!SecurityRoleSerializator.existsSecurityRole(configuration, securityRole)) {
                throw new BaseSecurityException("security_3014", new Object[]{securityRole});
            }
            SecurityRoleSerializator.removeSecurityRole(configuration, securityRole);
            mc.commitModifications();
        }
        catch (SecurityException se) {
            mc.rollbackModifications();
            if (se instanceof IBaseException) {
                throw se;
            }
            throw new BaseSecurityException("security_3015", se);
        }
    }

    public SecurityRole getSecurityRole(String securityRole) {
        if (SecurityServerFrame.isEmergencyMode()) {
            String emergencyUserName = this.root.getUserStoreContext().getActiveUserStore().getUserContext().getEmergencyUserName();
            SecurityRoleImpl emergencyRole = new SecurityRoleImpl(securityRole, new String[]{emergencyUserName}, new String[0]);
            emergencyRole.setContext(this);
            return emergencyRole;
        }
        return this.readSecurityRole(securityRole);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SecurityRole readSecurityRole(String securityRole) {
        SecurityRole securityRole2;
        ModificationContextImpl mc;
        block9: {
            SecurityRole securityRole3;
            block8: {
                mc = (ModificationContextImpl)this.root.getModificationContext();
                mc.beginModifications();
                try {
                    try {
                        Configuration configuration = mc.getConfiguration(this.path, false, false);
                        if (!SecurityRoleSerializator.existsSecurityRole(configuration, securityRole)) {
                            securityRole3 = null;
                            Object var7_7 = null;
                            break block8;
                        }
                        SecurityRole role = SecurityRoleSerializator.loadSecurityRole(this.root, configuration, securityRole);
                        if (role instanceof SecurityRoleImpl) {
                            ((SecurityRoleImpl)role).setContext(this);
                        } else if (role instanceof SecurityRoleReference) {
                            ((SecurityRoleReference)role).setContext(this);
                        }
                        securityRole2 = role;
                        break block9;
                    }
                    catch (SecurityException se) {
                        if (!(se instanceof IBaseException)) throw new BaseSecurityException("security_3016", se);
                        throw se;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    mc.forgetModifications();
                    throw throwable;
                }
            }
            mc.forgetModifications();
            return securityRole3;
        }
        Object var7_8 = null;
        mc.forgetModifications();
        return securityRole2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void refreshSecurityRole(SecurityRole role) {
        ModificationContextImpl mc;
        block8: {
            block7: {
                mc = (ModificationContextImpl)this.root.getModificationContext();
                mc.beginModifications();
                try {
                    try {
                        Configuration configuration = mc.getConfiguration(this.path, false, false);
                        if (!SecurityRoleSerializator.existsSecurityRole(configuration, role.getName())) {
                            Object var5_5 = null;
                            break block7;
                        }
                        SecurityRoleSerializator.refreshSecurityRole(this.root, configuration, role);
                        if (role instanceof SecurityRoleImpl) {
                            ((SecurityRoleImpl)role).setContext(this);
                        }
                        break block8;
                    }
                    catch (SecurityException se) {
                        if (!(se instanceof IBaseException)) throw new BaseSecurityException("security_3016", se);
                        throw se;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    mc.forgetModifications();
                    throw throwable;
                }
            }
            mc.forgetModifications();
            return;
        }
        Object var5_6 = null;
        mc.forgetModifications();
    }

    protected void modifySecurityRole(SecurityRole role) {
        Restrictions.checkPermission((int)2, (int)1, (String)this.policyConfiguration);
        if (role instanceof SecurityRoleReference) {
            throw new BaseSecurityException("security_3017");
        }
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            Configuration configuration = mc.getConfiguration(this.path, true, false);
            if (!SecurityRoleSerializator.existsSecurityRole(configuration, role.getName())) {
                throw new BaseSecurityException("security_3018", new Object[]{role.getName()});
            }
            SecurityRoleSerializator.storeSecurityRole(configuration, role);
            mc.commitModifications();
        }
        catch (SecurityException se) {
            mc.rollbackModifications();
            if (se instanceof IBaseException) {
                throw se;
            }
            throw new BaseSecurityException("security_3019", se);
        }
    }

    protected void modifySecurityRole(SecurityRole role, Configuration configuration) {
        Restrictions.checkPermission((int)2, (int)1, (String)this.policyConfiguration);
        this.modifySecurityRoleInternal(role, configuration);
    }

    protected void modifySecurityRoleInternal(SecurityRole role, Configuration configuration) {
        if (role instanceof SecurityRoleReference) {
            throw new BaseSecurityException("security_3017");
        }
        if (!SecurityRoleSerializator.existsSecurityRole(configuration, role.getName())) {
            throw new BaseSecurityException("security_3018", new Object[]{role.getName()});
        }
        SecurityRoleSerializator.storeSecurityRole(configuration, role);
    }

    protected static String getCallerName() {
        ThreadContext threadContext = SecurityServerFrame.threadContext.getThreadContext();
        if (threadContext == null) {
            return null;
        }
        SecurityContextObject sc = (SecurityContextObject)((Object)threadContext.getContextObject("security"));
        if (sc == null) {
            return null;
        }
        Principal pr = sc.getSession().getPrincipal();
        return pr == null ? null : pr.getName();
    }

    protected UserStoreFactory getUserStoreFactory() {
        return this.root.getUserStoreContext();
    }

    protected void setRunAsIdentity(SecurityRole role, String principal) {
        Restrictions.checkPermission((int)2, (int)1, (String)this.policyConfiguration);
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            Configuration configuration = mc.getConfiguration(this.path, true, false);
            if (!SecurityRoleSerializator.existsSecurityRole(configuration, role.getName())) {
                throw new BaseSecurityException("security_3018", new Object[]{role.getName()});
            }
            SecurityRoleSerializator.setRunAsIdentityToSecurityRole(configuration, role, principal);
            mc.commitModifications();
        }
        catch (SecurityException se) {
            mc.rollbackModifications();
            if (se instanceof IBaseException) {
                throw se;
            }
            throw new BaseSecurityException("security_3030", new Object[]{role.getName()}, se);
        }
    }

    protected void setRunAsAccountGenerationPolicy(SecurityRole role, byte type) {
        Restrictions.checkPermission((int)2, (int)1, (String)this.policyConfiguration);
        ModificationContextImpl mc = (ModificationContextImpl)this.root.getModificationContext();
        mc.beginModifications();
        try {
            Configuration configuration = mc.getConfiguration(this.path, true, false);
            if (!SecurityRoleSerializator.existsSecurityRole(configuration, role.getName())) {
                throw new BaseSecurityException("security_3018", new Object[]{role.getName()});
            }
            if (type < 0 || type > 2) {
                type = (byte)2;
            }
            SecurityRoleSerializator.setRunAsAccountGenerationPolicy(configuration, role, type);
            mc.commitModifications();
        }
        catch (SecurityException se) {
            mc.rollbackModifications();
            if (se instanceof IBaseException) {
                throw se;
            }
            throw new BaseSecurityException("security_3019", se);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getRunAsIdentity(SecurityRole role, boolean forceAssociation) {
        Configuration configuration;
        ModificationContextImpl mc;
        String runAsIdentity;
        block22: {
            block20: {
                String principal2;
                block21: {
                    String string;
                    block19: {
                        String string2;
                        block18: {
                            runAsIdentity = null;
                            this.run_as_state = (byte)-1;
                            mc = (ModificationContextImpl)this.root.getModificationContext();
                            mc.beginModifications();
                            configuration = null;
                            try {
                                try {
                                    configuration = mc.getConfiguration(this.path, false, false);
                                    if (!SecurityRoleSerializator.existsSecurityRole(configuration, role.getName())) {
                                        throw new BaseSecurityException("security_3018", new Object[]{role.getName()});
                                    }
                                    if ((configuration = configuration.getSubConfiguration(role.getName())).existsConfigEntry("run-as_identity")) {
                                        if (!forceAssociation) {
                                            string2 = (String)configuration.getConfigEntry("run-as_identity");
                                            Object var9_11 = null;
                                            break block18;
                                        }
                                        String principal2 = (String)configuration.getConfigEntry("run-as_identity");
                                        if (this.isValidRunAsPrincipal(principal2, role)) {
                                            string = principal2;
                                            break block19;
                                        }
                                        this.run_as_state = 1;
                                        break block20;
                                    }
                                    if (!forceAssociation) {
                                        principal2 = null;
                                        break block21;
                                    }
                                    this.run_as_state = 0;
                                    break block20;
                                }
                                catch (Exception e) {
                                    if (e instanceof IBaseException) {
                                        ((IBaseException)e).log();
                                    }
                                    Object var9_15 = null;
                                    mc.forgetModifications();
                                    break block22;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_16 = null;
                                mc.forgetModifications();
                                throw throwable;
                            }
                        }
                        mc.forgetModifications();
                        return string2;
                    }
                    Object var9_12 = null;
                    mc.forgetModifications();
                    return string;
                }
                Object var9_13 = null;
                mc.forgetModifications();
                return principal2;
            }
            Object var9_14 = null;
            mc.forgetModifications();
        }
        if (this.run_as_state <= -1) return runAsIdentity;
        try {
            configuration = mc.getConfiguration(this.path, true, false);
            Configuration roleConfiguration = configuration.getSubConfiguration(role.getName());
            byte state = this.run_as_state;
            runAsIdentity = this.generateValidRunAsPrincipal(roleConfiguration, role);
            if (runAsIdentity == null) {
                mc.rollbackModifications();
                return runAsIdentity;
            }
            if (state == 1) {
                roleConfiguration.modifyConfigEntry("run-as_identity", runAsIdentity);
            } else if (state == 0) {
                roleConfiguration.addConfigEntry("run-as_identity", runAsIdentity);
            }
            if (this.run_as_state == 2) {
                ((SecurityRoleImpl)role).addUserInternal(runAsIdentity, configuration);
            }
            mc.commitModifications();
            return runAsIdentity;
        }
        catch (Exception se) {
            mc.rollbackModifications();
            if (se instanceof BaseSecurityException) {
                ((BaseSecurityException)se).log();
                throw (BaseSecurityException)se;
            }
            BaseSecurityException bse = new BaseSecurityException("security_3031", new Object[]{role.getName()}, se);
            bse.log();
            throw bse;
        }
    }

    private boolean isValidRunAsPrincipal(String principal, SecurityRole role) {
        UserInfo info = null;
        try {
            info = this.root.getUserStoreContext().getActiveUserStore().getUserContext().getUserInfo(principal);
            if (info == null) {
                return false;
            }
        }
        catch (SecurityException _) {
            return false;
        }
        return this.isUserFromRole(principal, role);
    }

    private String generateValidRunAsPrincipal(Configuration roleConfiguration, SecurityRole role) {
        int runAsGenerationPolicy;
        try {
            runAsGenerationPolicy = roleConfiguration.existsConfigEntry("run-as_generation_policy") ? (int)((Byte)roleConfiguration.getConfigEntry("run-as_generation_policy")).byteValue() : 2;
        }
        catch (Exception _) {
            runAsGenerationPolicy = 2;
        }
        String principal = null;
        if (runAsGenerationPolicy == 2) {
            principal = this.getUserFromRole(role);
        } else {
            if (runAsGenerationPolicy == 1 && (principal = this.getUserFromRole(role)) != null) {
                return principal;
            }
            try {
                if (role instanceof SecurityRoleReference) {
                    throw new BaseSecurityException("security_3017");
                }
                com.sap.engine.interfaces.security.userstore.context.UserContext context = this.root.getUserStoreContext().getActiveUserStore().getUserContext();
                principal = context.getFilterUsername().generateUsername();
                UserInfo userInfo = ((UserContext)context).createUserInternal(principal);
                principal = userInfo.getName();
                this.run_as_state = (byte)2;
            }
            catch (Exception e) {
                throw new BaseSecurityException("security_3032", new Object[]{role.getName()}, e);
            }
        }
        return principal;
    }

    private String getUserFromRole(SecurityRole role) {
        if (SecurityServerFrame.isEmergencyMode()) {
            return this.root.getUserStoreContext().getActiveUserStore().getUserContext().getEmergencyUserName();
        }
        if (role.getUsers().length != 0) {
            return role.getUsers()[0];
        }
        String[] groups = role.getGroups();
        if (groups.length > 0) {
            GroupContext ctx = this.root.getUserStoreContext().getActiveUserStore().getGroupContext();
            HashSet checkedGroups = new HashSet();
            int i = 0;
            while (i < groups.length) {
                String userName = this.getUserFromGroup(groups[i], ctx, checkedGroups);
                if (userName != null) {
                    return userName;
                }
                ++i;
            }
        }
        return null;
    }

    private String getUserFromGroup(String group, GroupContext ctx, HashSet checkedGroups) {
        Iterator users = ctx.getUsersOfGroup(group);
        if (users.hasNext()) {
            return (String)users.next();
        }
        Iterator groups = ctx.getChildGroups(group);
        String nextGroup = null;
        while (groups.hasNext()) {
            nextGroup = (String)groups.next();
            if (checkedGroups.contains(nextGroup)) continue;
            checkedGroups.add(nextGroup);
            String user = this.getUserFromGroup(nextGroup, ctx, checkedGroups);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    private boolean isUserFromRole(String userName, SecurityRole role) {
        String[] mappedUsers = role.getUsers();
        int i = 0;
        while (i < mappedUsers.length) {
            if (mappedUsers[i].equals(userName)) {
                return true;
            }
            ++i;
        }
        String[] groups = role.getGroups();
        if (groups.length > 0) {
            GroupContext ctx = this.root.getUserStoreContext().getActiveUserStore().getGroupContext();
            HashSet checkedGroups = new HashSet();
            int i2 = 0;
            while (i2 < groups.length) {
                if (this.isUserFromGroup(userName, groups[i2], ctx, checkedGroups)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    private boolean isUserFromGroup(String user, String group, GroupContext ctx, HashSet checkedGroups) {
        Iterator users = ctx.getUsersOfGroup(group);
        while (users.hasNext()) {
            if (!users.next().equals(user)) continue;
            return true;
        }
        Iterator groups = ctx.getChildGroups(group);
        String nextGroup = null;
        while (groups.hasNext()) {
            nextGroup = (String)groups.next();
            if (checkedGroups.contains(nextGroup)) continue;
            checkedGroups.add(nextGroup);
            if (!this.isUserFromGroup(user, nextGroup, ctx, checkedGroups)) continue;
            return true;
        }
        return false;
    }
}

