/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl.resource;

import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.interfaces.security.resource.ResourceHandle;
import com.sap.engine.services.security.exceptions.BaseRemoteException;
import com.sap.engine.services.security.remote.resource.RemoteResourceAccessControlHandle;
import com.sap.engine.services.security.remote.resource.RemoteResourceHandle;
import com.sap.engine.services.security.remote.resource.RemoteSecurityResources;
import com.sap.engine.services.security.remoteimpl.resource.RemoteResourceAccessControlHandleImpl;
import com.sap.engine.services.security.remoteimpl.resource.RemoteResourceHandleImpl;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class RemoteSecurityResourcesImpl
extends PortableRemoteObject
implements RemoteSecurityResources {
    private ResourceContext resources = null;

    public RemoteSecurityResourcesImpl(ResourceContext resources) throws RemoteException {
        this.resources = resources;
    }

    public void checkPermission(String actionId, String resourceId, String instanceId) throws RemoteException, SecurityException {
        this.resources.checkPermission(actionId, resourceId, instanceId);
    }

    public void createResource(String alias) throws RemoteException, SecurityException {
        this.resources.createResource(alias);
    }

    public void destroyResource(String alias) throws RemoteException, SecurityException {
        this.resources.destroyResource(alias);
    }

    public RemoteResourceHandle getResourceHandle(String alias) throws RemoteException, SecurityException {
        ResourceHandle handle = this.resources.getResourceHandle(alias);
        if (handle == null) {
            BaseRemoteException exc = new BaseRemoteException("security_6063", new String[]{alias});
            exc.log();
            throw exc;
        }
        return new RemoteResourceHandleImpl(handle);
    }

    public RemoteResourceAccessControlHandle getResourceAccessControlHandle(String alias) throws RemoteException, SecurityException {
        ResourceAccessControlHandle handle = this.resources.getResourceAccessControlHandle(alias);
        if (handle == null) {
            BaseRemoteException exc = new BaseRemoteException("security_6063", new String[]{alias});
            exc.log();
            throw exc;
        }
        return new RemoteResourceAccessControlHandleImpl(handle);
    }

    public void renameResource(String alias, String newAlias) throws RemoteException, SecurityException {
        this.resources.renameResource(alias, newAlias);
    }

    public String[] getResourceAliases() throws RemoteException, SecurityException {
        return this.resources.getResourceAliases();
    }
}

